/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authc.pam;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.UnknownAccountException;
import org.jsecurity.authc.pam.AbstractAuthenticationStrategy;
import org.jsecurity.authc.pam.UnsupportedTokenException;
import org.jsecurity.realm.Realm;

public class AllSuccessfulModularAuthenticationStrategy
extends AbstractAuthenticationStrategy {
    private static final Log log = LogFactory.getLog(AllSuccessfulModularAuthenticationStrategy.class);

    public AuthenticationInfo beforeAttempt(Realm realm, AuthenticationToken token, AuthenticationInfo info) throws AuthenticationException {
        if (!realm.supports(token)) {
            String msg = "Realm [" + realm + "] of type [" + realm.getClass().getName() + "] does not support " + " the submitted AuthenticationToken [" + token + "].  The [" + this.getClass().getName() + "] implementation requires all configured realm(s) to support and be able to process the submitted " + "AuthenticationToken.";
            throw new UnsupportedTokenException(msg);
        }
        return info;
    }

    public AuthenticationInfo afterAttempt(Realm realm, AuthenticationToken token, AuthenticationInfo info, AuthenticationInfo aggregate, Throwable t) throws AuthenticationException {
        if (t != null) {
            if (t instanceof AuthenticationException) {
                throw (AuthenticationException)t;
            }
            String msg = "Unable to acquire account data from realm [" + realm + "].  The [" + this.getClass().getName() + " implementation requires all configured realm(s) to operate successfully " + "for a successful authentication.";
            throw new AuthenticationException(msg, t);
        }
        if (info == null) {
            String msg = "Realm [" + realm + "] could not find any associated account data for the submitted " + "AuthenticationToken [" + token + "].  The [" + this.getClass().getName() + "] implementation requires " + "all configured realm(s) to acquire valid account data for a submitted token during the " + "log-in process.";
            throw new UnknownAccountException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Account successfully authenticated using realm of type [" + realm.getClass().getName() + "]"));
        }
        this.merge(info, aggregate);
        return aggregate;
    }
}

