/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.session.mgt.eis;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.jsecurity.cache.Cache;
import org.jsecurity.cache.CacheManager;
import org.jsecurity.cache.CacheManagerAware;
import org.jsecurity.session.Session;
import org.jsecurity.session.UnknownSessionException;
import org.jsecurity.session.mgt.ValidatingSession;
import org.jsecurity.session.mgt.eis.SessionDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachingSessionDAO
implements SessionDAO,
CacheManagerAware {
    public static final String ACTIVE_SESSION_CACHE_NAME = "jsecurity-activeSessionCache";
    private CacheManager cacheManager;
    private Cache activeSessions;
    private String activeSessionsCacheName = "jsecurity-activeSessionCache";

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.activeSessions = null;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public String getActiveSessionsCacheName() {
        return this.activeSessionsCacheName;
    }

    public void setActiveSessionsCacheName(String activeSessionsCacheName) {
        this.activeSessionsCacheName = activeSessionsCacheName;
    }

    public Cache getActiveSessionsCache() {
        return this.activeSessions;
    }

    protected Cache getActiveSessionsCacheLazy() {
        if (this.activeSessions == null) {
            this.activeSessions = this.createActiveSessionsCache();
        }
        return this.activeSessions;
    }

    public void setActiveSessionsCache(Cache cache) {
        this.activeSessions = cache;
    }

    protected Cache createActiveSessionsCache() {
        Cache cache = null;
        CacheManager mgr = this.getCacheManager();
        if (mgr != null) {
            String name = this.getActiveSessionsCacheName();
            cache = mgr.getCache(name);
        }
        return cache;
    }

    @Override
    public Serializable create(Session session) {
        Serializable sessionId = this.doCreate(session);
        this.verifySessionId(sessionId);
        this.cacheValidSession(session, sessionId);
        return sessionId;
    }

    protected Session getCachedSession(Serializable sessionId) {
        Cache cache;
        Session cached = null;
        if (sessionId != null && (cache = this.getActiveSessionsCacheLazy()) != null) {
            cached = this.getCachedSession(sessionId, cache);
        }
        return cached;
    }

    protected Session getCachedSession(Serializable sessionId, Cache cache) {
        return (Session)cache.get(sessionId);
    }

    protected void cacheValidSession(Session session, Serializable sessionId) {
        if (session == null || sessionId == null) {
            return;
        }
        Cache cache = this.getActiveSessionsCacheLazy();
        if (cache == null) {
            return;
        }
        if (session instanceof ValidatingSession && !((ValidatingSession)session).isValid()) {
            this.uncache(session);
        } else {
            this.cache(session, sessionId, cache);
        }
    }

    protected void cache(Session session, Serializable sessionId, Cache cache) {
        cache.put(sessionId, session);
    }

    protected void verifySessionId(Serializable sessionId) {
        if (sessionId == null) {
            String msg = "sessionId returned from doCreate implementation is null.  Please verify the implementation.";
            throw new IllegalStateException(msg);
        }
        this.ensureUncached(sessionId);
    }

    protected void ensureUncached(Serializable sessionId) {
        Cache cache = this.getActiveSessionsCacheLazy();
        if (cache != null && cache.get(sessionId) != null) {
            String msg = "There is an existing session already created with session id [" + sessionId + "].  Session ID's must be unique.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected abstract Serializable doCreate(Session var1);

    @Override
    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        Session s = this.getCachedSession(sessionId);
        if (s == null && (s = this.doReadSession(sessionId)) != null) {
            this.cacheValidSession(s, sessionId);
        }
        if (s == null) {
            throw new UnknownSessionException("There is no session with id [" + sessionId + "]");
        }
        return s;
    }

    protected abstract Session doReadSession(Serializable var1);

    @Override
    public void update(Session session) throws UnknownSessionException {
        this.doUpdate(session);
        this.cacheValidSession(session, session.getId());
    }

    protected abstract void doUpdate(Session var1);

    @Override
    public void delete(Session session) {
        this.doDelete(session);
        this.uncache(session);
    }

    protected abstract void doDelete(Session var1);

    protected void uncache(Session session) {
        if (session == null) {
            return;
        }
        Serializable id = session.getId();
        if (id == null) {
            return;
        }
        Cache cache = this.getActiveSessionsCacheLazy();
        if (cache != null) {
            cache.remove(id);
        }
    }

    @Override
    public Collection<Session> getActiveSessions() {
        Cache cache = this.getActiveSessionsCacheLazy();
        if (cache != null) {
            return cache.values();
        }
        return Collections.EMPTY_LIST;
    }
}

