/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer.escaping;

import com.google.caja.lexer.escaping.Escape;
import java.util.Arrays;

final class EscapeMap {
    private final int min;
    private final String[] escapes;

    EscapeMap(Escape ... asciiEscapes) {
        this((EscapeMap)null, asciiEscapes);
    }

    EscapeMap(EscapeMap base, Escape ... asciiEscapes) {
        if (asciiEscapes.length == 0) {
            this.min = 0;
            this.escapes = new String[0];
        } else {
            int max;
            Arrays.sort(asciiEscapes);
            if (base == null) {
                this.min = asciiEscapes[0].raw;
                max = asciiEscapes[asciiEscapes.length - 1].raw;
            } else {
                this.min = Math.min(base.min, asciiEscapes[0].raw);
                max = Math.max(asciiEscapes[asciiEscapes.length - 1].raw, base.min + base.escapes.length - 1);
            }
            this.escapes = new String[max - this.min + 1];
            if (base != null) {
                System.arraycopy(base.escapes, 0, this.escapes, base.min - this.min, base.escapes.length);
            }
            for (Escape esc : asciiEscapes) {
                int idx = esc.raw - this.min;
                if (this.escapes[idx] != null) continue;
                this.escapes[idx] = esc.escaped;
            }
        }
    }

    String getEscape(int codepoint) {
        int offset = codepoint - this.min;
        if (offset < 0 || offset >= this.escapes.length) {
            return null;
        }
        return this.escapes[offset];
    }

    EscapeMap plus(Escape ... asciiEscapes) {
        return new EscapeMap(this, asciiEscapes);
    }
}

