/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.plugin.templates.IhtmlMessageType;
import com.google.caja.plugin.templates.IhtmlSanityChecker;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.CajaTestCase;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IhtmlSanityCheckerTest
extends CajaTestCase {
    public final void testEmptyTemplate() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"hi\" />", "<ihtml:template formals='' name='hi'/>", new Message[0]);
    }

    public final void testHtmlInTemplate() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"hi\"><p>Hi</p></ihtml:template>", "<ihtml:template formals=\"\" name=\"hi\"><p>Hi</p></ihtml:template>", new Message[0]);
    }

    public final void testSimpleMessage() throws Exception {
        this.runTest("<ihtml:template formals=\"a\" name=\"t\"><ihtml:message name=\"hi\">Hello</ihtml:message></ihtml:template>", "<ihtml:template formals='a' name='t'><ihtml:message name='hi'>Hello</ihtml:message></ihtml:template>", new Message[0]);
    }

    public final void testMultipleFormals() throws Exception {
        this.runTest("<ihtml:template formals=\"a b\" name=\"t\"><ihtml:message name=\"hi\">Hello</ihtml:message></ihtml:template>", "<ihtml:template formals='a b' name='t'><ihtml:message name='hi'>Hello</ihtml:message></ihtml:template>", new Message[0]);
    }

    public final void testMultipleVars() throws Exception {
        this.runTest("<ihtml:do vars=\"a _b\" />", "<ihtml:do vars=\"a _b\" />", new Message[0]);
    }

    public final void testUnnamedMessage() throws Exception {
        this.runTest("<ihtml:template formals=\"a b\" name=\"t\" />", "<ihtml:template formals='a b' name='t'><ihtml:message>Hello</ihtml:message></ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.MISSING_ATTRIB, IhtmlSanityCheckerTest.elKey("ihtml:message"), IhtmlSanityCheckerTest.attrKey("ihtml:message", "name"), FilePosition.instance(this.is, 1, 40, 40, 36)));
    }

    public final void testMisnamedMessage() throws Exception {
        this.runTest("<ihtml:template formals=\"a b\" name=\"t\" />", "<ihtml:template formals=\"a b\" name=\"t\"><ihtml:message name=\"x__\">Hello</ihtml:message></ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.BAD_ATTRIB, FilePosition.instance(this.is, 1, 55, 55, 10), IhtmlSanityCheckerTest.elKey("ihtml:message"), IhtmlSanityCheckerTest.attrKey("ihtml:message", "name"), MessagePart.Factory.valueOf("x__")));
    }

    public final void testMessageWithPlaceholder() throws Exception {
        this.runTest("<ihtml:template formals=\"x\" name=\"t\"><ihtml:message name=\"hi\">Hello <ihtml:ph name=\"planet\" /><ihtml:dynamic expr=\"planet\" /><ihtml:eph />!</ihtml:message></ihtml:template>", "<ihtml:template formals=\"x\" name=\"t\"><ihtml:message name=\"hi\">Hello <ihtml:ph name=\"planet\"/><ihtml:dynamic expr=\"planet\"/><ihtml:eph/>!</ihtml:message></ihtml:template>", new Message[0]);
    }

    public final void testBadPlaceholderName() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"t\"><ihtml:message name=\"hi\">Hello <ihtml:dynamic expr=\"planet\" />!</ihtml:message></ihtml:template>", "<ihtml:template formals=\"\" name=\"t\"><ihtml:message name=\"hi\">Hello <ihtml:ph name=\"if\"/><ihtml:dynamic expr=\"planet\"/><ihtml:eph/>!</ihtml:message></ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.BAD_ATTRIB, FilePosition.instance(this.is, 1, 78, 78, 9), IhtmlSanityCheckerTest.elKey("ihtml:ph"), IhtmlSanityCheckerTest.attrKey("ihtml:ph", "name"), MessagePart.Factory.valueOf("if")), new Message((MessageTypeInt)IhtmlMessageType.ORPHANED_PLACEHOLDER_END, FilePosition.instance(this.is, 1, 119, 119, 12)));
    }

    public final void testUnnamedPlaceholder() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"t\"><ihtml:message name=\"hi\">Hello <ihtml:dynamic expr=\"planet\" />!</ihtml:message></ihtml:template>", "<ihtml:template formals=\"\" name=\"t\"><ihtml:message name=\"hi\">Hello <ihtml:ph/><ihtml:dynamic expr=\"planet\"/><ihtml:eph/>!</ihtml:message></ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.MISSING_ATTRIB, IhtmlSanityCheckerTest.elKey("ihtml:ph"), IhtmlSanityCheckerTest.attrKey("ihtml:ph", "name"), FilePosition.instance(this.is, 1, 68, 68, 11)), new Message((MessageTypeInt)IhtmlMessageType.ORPHANED_PLACEHOLDER_END, FilePosition.instance(this.is, 1, 109, 109, 12)));
    }

    public final void testNestedMessage() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"t\"><ihtml:message name=\"hi\">Hello <ihtml:ph name=\"planet\" /><ihtml:dynamic expr=\"planet\" /><ihtml:eph />!</ihtml:message></ihtml:template>", "<ihtml:template formals=\"\" name=\"t\"><ihtml:message name=\"hi\"><ihtml:message name=\"there\" />Hello <ihtml:ph name=\"planet\"/><ihtml:dynamic expr=\"planet\"/><ihtml:eph/>!</ihtml:message></ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.NESTED_MESSAGE, FilePosition.instance(this.is, 1, 62, 62, 30), FilePosition.instance(this.is, 1, 37, 37, 145)));
    }

    public final void testUnclosedPlaceholder() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"t\"><ihtml:message name=\"hi\">Hello <ihtml:dynamic expr=\"planet\" />!</ihtml:message></ihtml:template>", "<ihtml:template formals=\"\" name=\"t\"><ihtml:message name=\"hi\">Hello <ihtml:ph name=\"planet\"/><ihtml:dynamic expr=\"planet\"/>!</ihtml:message></ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.UNCLOSED_PLACEHOLDER, FilePosition.instance(this.is, 1, 68, 68, 56)));
    }

    public final void testUnclosedPlaceholder2() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"t\"><ihtml:message name=\"hi\">Hello <ihtml:dynamic expr=\"planet\" /><ihtml:ph name=\"punc\" />!<ihtml:eph /></ihtml:message></ihtml:template>", "<ihtml:template formals=\"\" name=\"t\"><ihtml:message name=\"hi\">Hello <ihtml:ph name=\"planet\"/><ihtml:dynamic expr=\"planet\"/><ihtml:ph name=\"punc\"/>!<ihtml:eph/></ihtml:message></ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.UNCLOSED_PLACEHOLDER, FilePosition.instance(this.is, 1, 68, 68, 55)));
    }

    public final void testOrphanedPlaceholder() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"t\">Hello <ihtml:dynamic expr=\"planet\" />!</ihtml:template>", "<ihtml:template formals=\"\" name=\"t\">Hello <ihtml:ph name=\"planet\"/><ihtml:dynamic expr=\"planet\"/>!<ihtml:eph/></ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.ORPHANED_PLACEHOLDER, FilePosition.instance(this.is, 1, 43, 43, 25)), new Message((MessageTypeInt)IhtmlMessageType.ORPHANED_PLACEHOLDER, FilePosition.instance(this.is, 1, 99, 99, 12)));
    }

    public final void testOrphanedPlaceholderEnd() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"t\">Hello <ihtml:dynamic expr=\"planet\" />!</ihtml:template>", "<ihtml:template formals=\"\" name=\"t\">Hello <ihtml:dynamic expr=\"planet\"/>!<ihtml:eph/></ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.ORPHANED_PLACEHOLDER, FilePosition.instance(this.is, 1, 74, 74, 12)));
    }

    public final void testIhtmlElementInMessageOutsidePlaceholder() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"t\" />", "<ihtml:template formals=\"\" name=\"t\"><ihtml:message name='SayHowdy'>Hello <ihtml:dynamic expr=\"planet\"/>!</ihtml:message></ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.IHTML_IN_MESSAGE_OUTSIDE_PLACEHOLDER, FilePosition.instance(this.is, 1, 74, 74, 30), MessagePart.Factory.valueOf("dynamic")));
    }

    public final void testTemplateNames() throws Exception {
        this.runTest("<ihtml:template formals=\"x\" name=\"hi\" />", "<ihtml:template formals='x' name='hi'><ihtml:template name='3nested' formals='a,,x,if,3' zoinks='ahoy'/></ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.BAD_ATTRIB, FilePosition.instance(this.is, 1, 55, 55, 14), IhtmlSanityCheckerTest.elKey("ihtml:template"), IhtmlSanityCheckerTest.attrKey("ihtml:template", "name"), MessagePart.Factory.valueOf("3nested")), new Message((MessageTypeInt)IhtmlMessageType.BAD_ATTRIB, FilePosition.instance(this.is, 1, 70, 70, 19), IhtmlSanityCheckerTest.elKey("ihtml:template"), IhtmlSanityCheckerTest.attrKey("ihtml:template", "formals"), MessagePart.Factory.valueOf("a,,x,if,3")), new Message((MessageTypeInt)IhtmlMessageType.BAD_ATTRIB, FilePosition.instance(this.is, 1, 90, 90, 13), IhtmlSanityCheckerTest.elKey("ihtml:template"), IhtmlSanityCheckerTest.attrKey("ihtml:template", "zoinks"), MessagePart.Factory.valueOf("ahoy")));
    }

    public final void testCalls() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"hi\">\n  <ihtml:call baz=\"boo\" foo=\"bar\" template=\"bye\" />\n</ihtml:template>", "<ihtml:template name='hi' formals=''>\n  <ihtml:call ihtml:template='bye' foo='bar' baz='boo'/>\n</ihtml:template>", new Message[0]);
    }

    public final void testBadCall() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"hi\">\n  \n</ihtml:template>", "<ihtml:template name='hi' formals=''>\n  <ihtml:call foo='bar' baz:boo='far'/>\n</ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.MISSING_ATTRIB, FilePosition.instance(this.is, 2, 41, 3, 37), IhtmlSanityCheckerTest.elKey("ihtml:call"), IhtmlSanityCheckerTest.attrKey("ihtml:call", "ihtml:template")), new Message((MessageTypeInt)IhtmlMessageType.BAD_ATTRIB, FilePosition.instance(this.is, 2, 63, 25, 13), IhtmlSanityCheckerTest.elKey("ihtml:call"), AttribKey.forAttribute(new Namespaces(Namespaces.XML_SPECIAL, "baz", "unknown:///baz"), IhtmlSanityCheckerTest.elKey("ihtml:call"), "baz:boo"), MessagePart.Factory.valueOf("far")), new Message((MessageTypeInt)MessageType.NO_SUCH_NAMESPACE, FilePosition.fromLinePositions(this.is, 2, 25, 2, 32), MessagePart.Factory.valueOf("baz"), MessagePart.Factory.valueOf("baz:boo")));
    }

    public final void testMisplacedPlaceholderContent() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"t\">\n  <ihtml:message name=\"m\">\n    \n    \n  </ihtml:message>\n</ihtml:template>", "<ihtml:template formals=\"\" name=\"t\">\n  <ihtml:message name=\"m\">\n    <ihtml:ph name=\"p\">Hi</ihtml:ph>\n    <ihtml:eph>There</ihtml:eph>\n  </ihtml:message>\n</ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.INAPPROPRIATE_CONTENT, FilePosition.instance(this.is, 3, 88, 24, 2), MessagePart.Factory.valueOf("ph")), new Message((MessageTypeInt)IhtmlMessageType.INAPPROPRIATE_CONTENT, FilePosition.instance(this.is, 4, 117, 16, 5), MessagePart.Factory.valueOf("eph")));
    }

    public final void testBadAttr() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"t\">\n  \n  <div><ihtml:element>p</ihtml:element></div>\n</ihtml:template>", "<ihtml:template formals=\"\" name=\"t\">\n  <ihtml:element bogus=\"\">p</ihtml:element>\n  <div><ihtml:element>p</ihtml:element></div>\n</ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.BAD_ATTRIB, FilePosition.instance(this.is, 2, 55, 18, 8), IhtmlSanityCheckerTest.elKey("ihtml:element"), IhtmlSanityCheckerTest.attrKey("ihtml:element", "bogus"), MessagePart.Factory.valueOf("")));
    }

    public final void testDynamicAttr() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"t\">\n  <a>\n    <ihtml:attribute name=\"href\"><ihtml:dynamic expr=\"url\" /></ihtml:attribute>\n    <ihtml:attribute name=\"title\">\n      <ihtml:message name=\"linkHover\">Howdy</ihtml:message>\n    </ihtml:attribute>\n    Link Text\n    \n  </a>\n</ihtml:template>", "<ihtml:template formals=\"\" name=\"t\">\n  <a>\n    <ihtml:attribute name=\"href\"><ihtml:dynamic expr=\"url\"     /></ihtml:attribute>\n    <ihtml:attribute name=\"title\">\n      <ihtml:message name=\"linkHover\">Howdy</ihtml:message>\n    </ihtml:attribute>\n    Link Text\n    <ihtml:attribute>onclick=\"badness()\"</ihtml:attribute>\n  </a>\n</ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.MISSING_ATTRIB, FilePosition.instance(this.is, 8, 264, 5, 54), IhtmlSanityCheckerTest.elKey("ihtml:attribute"), IhtmlSanityCheckerTest.attrKey("ihtml:attribute", "name")));
    }

    public final void testMisplacedElementAndAttribute() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"t\">\n  <ihtml:element />\n  <ihtml:message name=\"m\">\n    \n    <ihtml:ph name=\"ph\" />\n      \n    <ihtml:eph />\n  </ihtml:message>\n  <ihtml:do init=\"maybe\">\n    <ihtml:element />\n  <ihtml:else />\n    <ihtml:element />\n  </ihtml:do>\n</ihtml:template>", "<ihtml:template formals=\"\" name=\"t\">\n  <ihtml:element/>\n  <ihtml:message name=\"m\">\n    <ihtml:element/>\n    <ihtml:ph name=\"ph\"/>\n      <ihtml:element/>\n    <ihtml:eph/>\n  </ihtml:message>\n  <ihtml:do init=\"maybe\">\n    <ihtml:element/>\n  <ihtml:else/>\n    <ihtml:element/>\n  </ihtml:do>\n</ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.MISPLACED_ELEMENT, FilePosition.instance(this.is, 4, 88, 5, 16), MessagePart.Factory.valueOf("ihtml:element"), MessagePart.Factory.valueOf("ihtml:message")), new Message((MessageTypeInt)IhtmlMessageType.MISPLACED_ELEMENT, FilePosition.instance(this.is, 6, 137, 7, 16), MessagePart.Factory.valueOf("ihtml:element"), MessagePart.Factory.valueOf("ihtml:message")));
    }

    public final void testContentType() throws Exception {
        this.runTest("<ihtml:template formals=\"\" name=\"main\">\n  \n</ihtml:template>", "<ihtml:template formals=\"\" name=\"main\">\n  <ihtml:template formals=\"\" name=\"sub\"\n   callingContext=\"div\">\n  </ihtml:template>\n</ihtml:template>", new Message((MessageTypeInt)IhtmlMessageType.BAD_ATTRIB, FilePosition.instance(this.is, 3, 4, 4, 20), IhtmlSanityCheckerTest.elKey("ihtml:template"), IhtmlSanityCheckerTest.attrKey("ihtml:template", "callingContext"), MessagePart.Factory.valueOf("div")));
    }

    private void runTest(String goldenIhtml, String inputIhtml, Message ... expectedMessages) throws Exception {
        Element ihtmlRoot = new DomParser(DomParser.makeTokenQueue(FilePosition.startOfFile(this.is), (Reader)new StringReader(inputIhtml), true, false), true, this.mq).parseDocument();
        new IhtmlSanityChecker(this.mq).check(ihtmlRoot);
        for (Message msg : expectedMessages) {
            this.assertMessage(true, msg.getMessageType(), msg.getMessageLevel(), msg.getMessageParts().toArray(new MessagePart[0]));
        }
        this.assertMessagesLessSevereThan(MessageLevel.WARNING);
        String checkedIhtml = Nodes.render((Node)ihtmlRoot, true);
        IhtmlSanityCheckerTest.assertEquals((String)goldenIhtml, (String)checkedIhtml);
    }

    static ElKey elKey(String qname) {
        return ElKey.forElement(Namespaces.HTML_DEFAULT, qname);
    }

    static AttribKey attrKey(String elQName, String aQName) {
        return AttribKey.forAttribute(Namespaces.HTML_DEFAULT, ElKey.forElement(Namespaces.HTML_DEFAULT, elQName), aQName);
    }
}

