/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CollectionCacheEntry;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.InitializeCollectionEvent;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInitializeCollectionEventListener
implements InitializeCollectionEventListener {
    private static final Logger log = LoggerFactory.getLogger((Class)DefaultInitializeCollectionEventListener.class);

    public void onInitializeCollection(InitializeCollectionEvent event) throws HibernateException {
        PersistentCollection collection = event.getCollection();
        EventSource source = event.getSession();
        CollectionEntry ce = source.getPersistenceContext().getCollectionEntry(collection);
        if (ce == null) {
            throw new HibernateException("collection was evicted");
        }
        if (!collection.wasInitialized()) {
            if (log.isTraceEnabled()) {
                log.trace("initializing collection " + MessageHelper.collectionInfoString(ce.getLoadedPersister(), ce.getLoadedKey(), source.getFactory()));
            }
            log.trace("checking second-level cache");
            boolean foundInCache = this.initializeCollectionFromCache(ce.getLoadedKey(), ce.getLoadedPersister(), collection, source);
            if (foundInCache) {
                log.trace("collection initialized from cache");
            } else {
                log.trace("collection not cached");
                ce.getLoadedPersister().initialize(ce.getLoadedKey(), source);
                log.trace("collection initialized");
                if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                    source.getFactory().getStatisticsImplementor().fetchCollection(ce.getLoadedPersister().getRole());
                }
            }
        }
    }

    private boolean initializeCollectionFromCache(Serializable id, CollectionPersister persister, PersistentCollection collection, SessionImplementor source) {
        boolean useCache;
        if (!source.getEnabledFilters().isEmpty() && persister.isAffectedByEnabledFilters(source)) {
            log.trace("disregarding cached version (if any) of collection due to enabled filters ");
            return false;
        }
        boolean bl = useCache = persister.hasCache() && source.getCacheMode().isGetEnabled();
        if (!useCache) {
            return false;
        }
        SessionFactoryImplementor factory = source.getFactory();
        CacheKey ck = new CacheKey(id, persister.getKeyType(), persister.getRole(), source.getEntityMode(), source.getFactory());
        Object ce = persister.getCacheAccessStrategy().get(ck, source.getTimestamp());
        if (factory.getStatistics().isStatisticsEnabled()) {
            if (ce == null) {
                factory.getStatisticsImplementor().secondLevelCacheMiss(persister.getCacheAccessStrategy().getRegion().getName());
            } else {
                factory.getStatisticsImplementor().secondLevelCacheHit(persister.getCacheAccessStrategy().getRegion().getName());
            }
        }
        if (ce == null) {
            return false;
        }
        CollectionCacheEntry cacheEntry = (CollectionCacheEntry)persister.getCacheEntryStructure().destructure(ce, factory);
        PersistenceContext persistenceContext = source.getPersistenceContext();
        cacheEntry.assemble(collection, persister, persistenceContext.getCollectionOwner(id, persister));
        persistenceContext.getCollectionEntry(collection).postInitialize(collection);
        return true;
    }
}

