/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.io.Serializable;
import java.util.HashMap;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;

public class CacheHandler {
    public static final String MEMBERSHIPTYPE_PREFIX = "mt=";
    public static final String GROUP_PREFIX = "g=";
    public static final String USER_PREFIX = "u=";
    protected final ExoCache<Serializable, User> userCache;
    protected final ExoCache<Serializable, UserProfile> userProfileCache;
    protected final ExoCache<Serializable, MembershipType> membershipTypeCache;
    protected final ExoCache<Serializable, Membership> membershipCache;
    protected final ExoCache<Serializable, Group> groupCache;

    public CacheHandler(CacheService cservice) {
        this.userCache = cservice.getCacheInstance(this.getClass().getName() + "userCache");
        this.userProfileCache = cservice.getCacheInstance(this.getClass().getName() + "userProfileCache");
        this.membershipTypeCache = cservice.getCacheInstance(this.getClass().getName() + "membershipTypeCache");
        this.groupCache = cservice.getCacheInstance(this.getClass().getName() + "groupCache");
        this.membershipCache = cservice.getCacheInstance(this.getClass().getName() + "membershipCache");
    }

    public void put(Serializable key, Object value, CacheType cacheType) {
        if (cacheType == CacheType.USER) {
            this.userCache.put(key, (Object)((User)value));
        } else if (cacheType == CacheType.GROUP) {
            this.groupCache.put(key, (Object)((Group)value));
        } else if (cacheType == CacheType.MEMBERSHIP) {
            this.membershipCache.put(key, (Object)((Membership)value));
        } else if (cacheType == CacheType.MEMBERSHIPTYPE) {
            this.membershipTypeCache.put(key, (Object)((MembershipType)value));
        } else if (cacheType == CacheType.USER_PROFILE) {
            this.userProfileCache.put(key, (Object)((UserProfile)value));
        }
    }

    public Object get(Serializable key, CacheType cacheType) {
        Object obj = null;
        if (cacheType == CacheType.USER) {
            obj = this.userCache.get(key);
        } else if (cacheType == CacheType.GROUP) {
            obj = this.groupCache.get(key);
        } else if (cacheType == CacheType.MEMBERSHIP) {
            obj = this.membershipCache.get(key);
        } else if (cacheType == CacheType.MEMBERSHIPTYPE) {
            obj = this.membershipTypeCache.get(key);
        } else if (cacheType == CacheType.USER_PROFILE) {
            obj = this.userProfileCache.get(key);
        }
        if (obj != null && obj instanceof Cloneable) {
            try {
                return obj.getClass().getMethod("clone", new Class[0]).invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                return obj;
            }
        }
        return obj;
    }

    public void remove(Serializable key, CacheType cacheType) {
        if (cacheType == CacheType.USER) {
            this.userCache.remove(key);
        } else if (cacheType == CacheType.GROUP) {
            this.groupCache.remove(key);
        } else if (cacheType == CacheType.MEMBERSHIP) {
            try {
                for (Membership m : this.membershipCache.getCachedObjects()) {
                    String mkey = this.getMembershipKey(m);
                    if (mkey.indexOf((String)((Object)key)) < 0) continue;
                    this.membershipCache.remove((Serializable)((Object)mkey));
                }
            }
            catch (Exception exception) {}
        } else if (cacheType == CacheType.MEMBERSHIPTYPE) {
            this.membershipTypeCache.remove(key);
        } else if (cacheType == CacheType.USER_PROFILE) {
            this.userProfileCache.remove(key);
        }
    }

    public void move(Serializable oldKey, Serializable newKey, CacheType cacheType) {
        if (cacheType == CacheType.USER) {
            this.userCache.put(newKey, this.userCache.remove(oldKey));
        } else if (cacheType == CacheType.GROUP) {
            this.groupCache.put(newKey, this.groupCache.remove(oldKey));
        } else if (cacheType == CacheType.MEMBERSHIP) {
            try {
                HashMap<String, Object> wait4Adding = new HashMap<String, Object>();
                for (Membership m : this.membershipCache.getCachedObjects()) {
                    String mkey = this.getMembershipKey(m);
                    if (mkey.indexOf((String)((Object)oldKey)) < 0) continue;
                    wait4Adding.put(mkey.replace((String)((Object)oldKey), (String)((Object)newKey)), this.membershipCache.remove((Serializable)((Object)mkey)));
                }
                this.membershipCache.putMap(wait4Adding);
            }
            catch (Exception e) {}
        } else if (cacheType == CacheType.MEMBERSHIPTYPE) {
            this.membershipTypeCache.put(newKey, this.membershipTypeCache.remove(oldKey));
        } else if (cacheType == CacheType.USER_PROFILE) {
            this.userProfileCache.put(newKey, this.userProfileCache.remove(oldKey));
        }
    }

    public String getMembershipKey(Membership m) {
        StringBuilder key = new StringBuilder();
        key.append(GROUP_PREFIX + m.getGroupId());
        key.append(MEMBERSHIPTYPE_PREFIX + m.getMembershipType());
        key.append(USER_PREFIX + m.getUserName());
        return key.toString();
    }

    public String getMembershipKey(String username, String groupId, String type) {
        StringBuilder key = new StringBuilder();
        key.append(GROUP_PREFIX + groupId);
        key.append(MEMBERSHIPTYPE_PREFIX + type);
        key.append(USER_PREFIX + username);
        return key.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheType {
        USER,
        GROUP,
        MEMBERSHIP,
        MEMBERSHIPTYPE,
        USER_PROFILE;

    }
}

