/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.jsecurity.io.ResourceException;
import org.jsecurity.io.ResourceUtils;

public abstract class AbstractResource
implements Serializable {
    public AbstractResource() {
    }

    public AbstractResource(String resourcePath) {
        this.load(resourcePath);
    }

    public AbstractResource(InputStream is) {
        this.load(is);
    }

    public void load(String resourcePath) {
        if (resourcePath == null) {
            throw new IllegalArgumentException("resourcePath argument cannot be null.");
        }
        InputStream is = this.getPathInputStream(resourcePath);
        this.load(is);
    }

    protected InputStream getPathInputStream(String path) throws ResourceException {
        try {
            return ResourceUtils.getInputStreamForPath(path);
        }
        catch (IOException e) {
            String msg = "Unable to create input stream from resource path [" + path + "].";
            throw new ResourceException(msg, e);
        }
    }

    public void load(InputStream is) throws ResourceException {
        try {
            this.doLoad(is);
        }
        catch (Exception e) {
            String msg = "Unable to load data from input stream [" + is + "].";
            throw new ResourceException(msg, e);
        }
    }

    protected abstract void doLoad(InputStream var1) throws Exception;
}

