/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.Pair;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceMutateVisitor
implements DomWalker.Visitor {
    protected final Map<String, String> resourceTags;
    protected final ContentRewriterFeature.Config featureConfig;

    public ResourceMutateVisitor(ContentRewriterFeature.Config featureConfig, Tags ... resourceTags) {
        this.featureConfig = featureConfig;
        HashMap rTags = Maps.newHashMap();
        for (Tags r : resourceTags) {
            rTags.putAll(r.getResourceTags());
        }
        this.resourceTags = ImmutableMap.builder().putAll((Map)rTags).build();
    }

    @Override
    public DomWalker.Visitor.VisitStatus visit(Gadget gadget, Node node) throws RewritingException {
        String nodeName = node.getNodeName().toLowerCase();
        if (node.getNodeType() == 1 && this.resourceTags.containsKey(nodeName) && this.featureConfig.shouldRewriteTag(nodeName)) {
            String urlValue;
            Attr attr;
            if ("link".equals(nodeName)) {
                String type = ((Element)node).getAttribute("type");
                String rel = ((Element)node).getAttribute("rel");
                if (!"stylesheet".equalsIgnoreCase(rel) || !"text/css".equalsIgnoreCase(type)) {
                    return DomWalker.Visitor.VisitStatus.BYPASS;
                }
            }
            if ((attr = (Attr)node.getAttributes().getNamedItem(this.resourceTags.get(nodeName))) != null && !StringUtils.isEmpty((String)(urlValue = attr.getValue())) && this.featureConfig.shouldRewriteURL(urlValue)) {
                return DomWalker.Visitor.VisitStatus.RESERVE_NODE;
            }
        }
        return DomWalker.Visitor.VisitStatus.BYPASS;
    }

    @Override
    public boolean revisit(Gadget gadget, List<Node> nodes) throws RewritingException {
        Collection<Pair<Node, Uri>> proxiedUris = this.mutateUris(gadget, nodes);
        boolean mutated = false;
        for (Pair<Node, Uri> proxyPair : proxiedUris) {
            if (proxyPair.two == null) continue;
            Element element = (Element)proxyPair.one;
            String nodeName = element.getNodeName().toLowerCase();
            element.setAttribute(this.resourceTags.get(nodeName), ((Uri)proxyPair.two).toString());
            mutated = true;
        }
        return mutated;
    }

    protected abstract Collection<Pair<Node, Uri>> mutateUris(Gadget var1, Collection<Node> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tags {
        SCRIPT((Map<String, String>)ImmutableMap.of((Object)"script", (Object)"src")),
        STYLESHEET((Map<String, String>)ImmutableMap.of((Object)"link", (Object)"href")),
        EMBEDDED_IMAGES((Map<String, String>)ImmutableMap.of((Object)"body", (Object)"background", (Object)"img", (Object)"src", (Object)"input", (Object)"src")),
        ALL_RESOURCES((Map<String, String>)ImmutableMap.builder().putAll(SCRIPT.getResourceTags()).putAll(STYLESHEET.getResourceTags()).putAll(EMBEDDED_IMAGES.getResourceTags()).build());

        private Map<String, String> resourceTags;

        private Tags(Map<String, String> resourceTags) {
            this.resourceTags = resourceTags;
        }

        public Map<String, String> getResourceTags() {
            return this.resourceTags;
        }
    }
}

