/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.render.SanitizingGadgetRewriter;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.tags.AbstractTagHandler;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashTagHandler
extends AbstractTagHandler {
    static final String SWFOBJECT = "swfobject";
    static final String TAG_NAME = "Flash";
    private final BeanJsonConverter beanConverter;
    private final FeatureRegistry featureRegistry;
    private final String flashMinVersion;
    final AtomicLong idGenerator = new AtomicLong();
    private static final String ALT_CONTENT_PREFIX = "os_xFlash_alt_";

    @Inject
    public FlashTagHandler(BeanJsonConverter beanConverter, FeatureRegistry featureRegistry, @Named(value="shindig.template-rewrite.extension-tag-namespace") String namespace, @Named(value="shindig.flash.min-version") String flashMinVersion) {
        super(namespace, TAG_NAME);
        this.beanConverter = beanConverter;
        this.featureRegistry = featureRegistry;
        this.flashMinVersion = flashMinVersion;
    }

    @Override
    public void process(Node result, Element tag, TemplateProcessor processor) {
        SwfObjectConfig config;
        try {
            config = this.getSwfConfig(tag, processor);
        }
        catch (RuntimeException re) {
            Element err = result.getOwnerDocument().createElement("span");
            err.setTextContent("Failed to process os:Flash tag: " + StringEscapeUtils.escapeHtml((String)re.getMessage()));
            result.appendChild(err);
            return;
        }
        String st = processor.getTemplateContext().getGadget().getContext().getParameter("st");
        if (!StringUtils.isEmpty((String)st)) {
            String stVar = "st=" + Utf8UrlCoder.encode((String)st);
            config.flashvars = StringUtils.isEmpty((String)config.flashvars) ? stVar : config.flashvars + '&' + stVar;
        }
        if (processor.getTemplateContext().getGadget().sanitizeOutput()) {
            config.allowscriptaccess = SwfObjectConfig.ScriptAccess.never;
            config.swliveconnect = false;
            config.allownetworking = SwfObjectConfig.NetworkAccess.internal;
        }
        Element altHolder = result.getOwnerDocument().createElement("div");
        String altContentId = ALT_CONTENT_PREFIX + this.idGenerator.incrementAndGet();
        altHolder.setAttribute("id", altContentId);
        result.appendChild(altHolder);
        NodeList alternateContent = tag.getChildNodes();
        if (alternateContent.getLength() > 0) {
            processor.processChildNodes(altHolder, tag);
        }
        String swfObjectCall = this.buildSwfObjectCall(config, altContentId);
        Element script = result.getOwnerDocument().createElement("script");
        script.setAttribute("type", "text/javascript");
        result.appendChild(script);
        if (config.play == SwfObjectConfig.Play.immediate) {
            script.setTextContent(swfObjectCall);
        } else {
            script.setTextContent("function " + altContentId + "(){ " + swfObjectCall + " }");
            altHolder.setAttribute("onclick", altContentId + "()");
        }
        SanitizingGadgetRewriter.bypassSanitization(altHolder, false);
        SanitizingGadgetRewriter.bypassSanitization(script, false);
        this.ensureSwfobject(result.getOwnerDocument(), processor);
    }

    String buildSwfObjectCall(SwfObjectConfig config, String altContentId) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("swfobject.embedSWF(");
            JsonSerializer.appendString((Appendable)builder, (CharSequence)config.swf.toString());
            builder.append(",\"");
            builder.append(altContentId);
            builder.append("\",");
            JsonSerializer.appendString((Appendable)builder, (CharSequence)config.width);
            builder.append(',');
            JsonSerializer.appendString((Appendable)builder, (CharSequence)config.height);
            builder.append(",\"").append(this.flashMinVersion).append("\",");
            builder.append("null,null,");
            JsonSerializer.appendMap((Appendable)builder, config.getParams());
            builder.append(',');
            JsonSerializer.appendMap((Appendable)builder, config.getAttributes());
            builder.append(");");
            return builder.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    SwfObjectConfig getSwfConfig(Element tag, TemplateProcessor processor) {
        Map<String, String> params = this.getAllAttributesLowerCase(tag, processor);
        return (SwfObjectConfig)this.beanConverter.convertToObject((Object)new JSONObject(params), SwfObjectConfig.class);
    }

    Map<String, String> getAllAttributesLowerCase(Element tag, TemplateProcessor processor) {
        HashMap result = Maps.newHashMap();
        for (int i = 0; i < tag.getAttributes().getLength(); ++i) {
            Node attr = tag.getAttributes().item(i);
            String attrName = attr.getNodeName().toLowerCase();
            result.put(attrName, processor.evaluate(attr.getNodeValue(), String.class, null));
        }
        return result;
    }

    void ensureSwfobject(Document doc, TemplateProcessor processor) {
        Element head = (Element)DomUtil.getFirstNamedChildNode((Node)doc.getDocumentElement(), (String)"head");
        NodeList childNodes = head.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getUserData(SWFOBJECT) == null) continue;
            return;
        }
        Element swfobject = doc.createElement("script");
        swfobject.setAttribute("type", "text/javascript");
        List<FeatureResource> resources = this.featureRegistry.getFeatureResources(processor.getTemplateContext().getGadget().getContext(), (Collection<String>)ImmutableSet.of((Object)SWFOBJECT), null);
        for (FeatureResource resource : resources) {
            swfobject.setTextContent(resource.getContent());
        }
        swfobject.setUserData(SWFOBJECT, SWFOBJECT, null);
        head.appendChild(swfobject);
        SanitizingGadgetRewriter.bypassSanitization(swfobject, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SwfObjectConfig {
        String id;
        Uri swf;
        String width = "100px";
        String height = "100px";
        String name;
        String clazz;
        Boolean menu;
        Play play = Play.immediate;
        Scale scale;
        WMode wmode;
        Boolean devicefont;
        Boolean swliveconnect;
        ScriptAccess allowscriptaccess;
        Boolean loop;
        Quality quality;
        Align align;
        SAlign salign;
        String bgcolor;
        Boolean seamlesstabbing;
        Boolean allowfullscreen;
        NetworkAccess allownetworking;
        String flashvars;

        public void setId(String id) {
            this.id = id;
        }

        public void setSwf(Uri swf) {
            this.swf = swf;
        }

        public void setWidth(String width) {
            this.width = width;
        }

        public void setHeight(String height) {
            this.height = height;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setClass(String clazz) {
            this.clazz = clazz;
        }

        public void setPlay(Play play) {
            this.play = play;
        }

        public void setMenu(Boolean menu) {
            this.menu = menu;
        }

        public void setScale(Scale scale) {
            this.scale = scale;
        }

        public void setWmode(WMode wmode) {
            this.wmode = wmode;
        }

        public void setDevicefont(Boolean devicefont) {
            this.devicefont = devicefont;
        }

        public void setSwliveconnect(Boolean swliveconnect) {
            this.swliveconnect = swliveconnect;
        }

        public void setAllowscriptaccess(ScriptAccess allowscriptaccess) {
            this.allowscriptaccess = allowscriptaccess;
        }

        public void setLoop(Boolean loop) {
            this.loop = loop;
        }

        public void setQuality(Quality quality) {
            this.quality = quality;
        }

        public void setAlign(Align align) {
            this.align = align;
        }

        public void setSalign(SAlign salign) {
            this.salign = salign;
        }

        public void setBgcolor(String bgcolor) {
            this.bgcolor = bgcolor;
        }

        public void setSeamlesstabbing(Boolean seamlesstabbing) {
            this.seamlesstabbing = seamlesstabbing;
        }

        public void setAllowfullscreen(Boolean allowfullscreen) {
            this.allowfullscreen = allowfullscreen;
        }

        public void setAllownetworking(NetworkAccess allownetworking) {
            this.allownetworking = allownetworking;
        }

        public void setFlashvars(String flashvars) {
            this.flashvars = flashvars;
        }

        public Map<String, Object> getParams() {
            LinkedHashMap swfobjectParams = Maps.newLinkedHashMap();
            if (this.loop != null) {
                swfobjectParams.put("loop", this.loop);
            }
            if (this.menu != null) {
                swfobjectParams.put("menu", this.menu);
            }
            if (this.quality != null) {
                swfobjectParams.put("quality", this.quality);
            }
            if (this.scale != null) {
                swfobjectParams.put("scale", this.scale);
            }
            if (this.salign != null) {
                swfobjectParams.put("salign", this.salign);
            }
            if (this.wmode != null) {
                swfobjectParams.put("wmode", this.wmode);
            }
            if (this.bgcolor != null) {
                swfobjectParams.put("bgcolor", this.bgcolor);
            }
            if (this.swliveconnect != null) {
                swfobjectParams.put("swliveconnect", this.swliveconnect);
            }
            if (this.flashvars != null) {
                swfobjectParams.put("flashvars", this.flashvars);
            }
            if (this.devicefont != null) {
                swfobjectParams.put("devicefont", this.devicefont);
            }
            if (this.allowscriptaccess != null) {
                swfobjectParams.put("allowscriptaccess", this.allowscriptaccess);
            }
            if (this.seamlesstabbing != null) {
                swfobjectParams.put("seamlesstabbing", this.seamlesstabbing);
            }
            if (this.allowfullscreen != null) {
                swfobjectParams.put("allowfullscreen", this.allowfullscreen);
            }
            if (this.allownetworking != null) {
                swfobjectParams.put("allownetworking", this.allownetworking);
            }
            return swfobjectParams;
        }

        public Map<String, Object> getAttributes() {
            LinkedHashMap swfObjectAttrs = Maps.newLinkedHashMap();
            if (this.id != null) {
                swfObjectAttrs.put("id", this.id);
            }
            if (this.name != null) {
                swfObjectAttrs.put("name", this.name);
            }
            if (this.clazz != null) {
                swfObjectAttrs.put("styleclass", this.clazz);
            }
            if (this.align != null) {
                swfObjectAttrs.put("align", this.align.toString());
            }
            return swfObjectAttrs;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum NetworkAccess {
            all,
            internal,
            none;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SAlign {
            tl,
            tr,
            bl,
            br,
            l,
            t,
            r,
            b;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Align {
            middle,
            left,
            right,
            top,
            bottom;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Quality {
            best,
            high,
            medium,
            autohigh,
            autolow,
            low;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ScriptAccess {
            always,
            samedomain,
            never;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum WMode {
            window,
            opaque,
            transparent,
            direct,
            gpu;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Scale {
            showall,
            noborder,
            exactfit,
            noscale;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Play {
            immediate,
            onclick;

        }
    }
}

