/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.util.CajaTestCase;
import com.google.caja.util.SparseBitSet;
import java.util.BitSet;
import java.util.Random;

public class SparseBitSetTest
extends CajaTestCase {
    public final void testAgainstRegularImplementation() {
        Random rnd = new Random(SEED);
        int run = 10;
        while (--run >= 0) {
            BitSet bs = new BitSet();
            int i = 4096;
            while (--i >= 0) {
                bs.set(4096 + rnd.nextInt(12288));
            }
            int[] members = new int[bs.cardinality()];
            int i2 = -1;
            for (int k = 0; k < members.length; ++k) {
                members[k] = i2 = bs.nextSetBit(i2 + 1);
            }
            SparseBitSet sbs = SparseBitSet.withMembers(members);
            for (int i3 = 0; i3 < 20480; ++i3) {
                if (bs.get(i3) == sbs.contains(i3)) continue;
                SparseBitSetTest.fail((String)("sbs=" + sbs + ", bs=" + bs + ", difference at bit " + i3));
            }
        }
    }

    public final void testEmptySparseBitSet() {
        SparseBitSet sbs = SparseBitSet.withRanges(new int[0]);
        for (int i = -1000; i < 1000; ++i) {
            SparseBitSetTest.assertFalse((boolean)sbs.contains(i));
        }
        SparseBitSetTest.assertEquals((String)"[]", (String)sbs.toString());
    }

    public final void testSparseBitSetFactories() {
        SparseBitSet bsbs = SparseBitSet.withMembers(0, 1, 4, 9);
        SparseBitSetTest.assertEquals((String)bsbs.toString(), (String)"[0x0-0x1 0x4 0x9]", (String)bsbs.toString());
        SparseBitSet ssbs = SparseBitSet.withMembers(0, 1, 4, 9);
        SparseBitSetTest.assertEquals((String)"[0x0-0x1 0x4 0x9]", (String)ssbs.toString());
        SparseBitSet csbs = SparseBitSet.withMembers('\u0000', '\u0001', '\u0004', '\t');
        SparseBitSetTest.assertEquals((String)"[0x0-0x1 0x4 0x9]", (String)csbs.toString());
        SparseBitSet isbs = SparseBitSet.withMembers(0, 1, 4, 9);
        SparseBitSetTest.assertEquals((String)"[0x0-0x1 0x4 0x9]", (String)isbs.toString());
        SparseBitSet esbs = SparseBitSet.withMembers(new int[0]);
        SparseBitSetTest.assertEquals((Object)bsbs, (Object)ssbs);
        SparseBitSetTest.assertEquals((Object)bsbs, (Object)csbs);
        SparseBitSetTest.assertEquals((Object)bsbs, (Object)isbs);
        SparseBitSetTest.assertFalse((boolean)bsbs.equals(esbs));
        SparseBitSetTest.assertFalse((boolean)bsbs.equals(null));
        SparseBitSetTest.assertFalse((boolean)bsbs.equals(new Object()));
        SparseBitSetTest.assertEquals((int)bsbs.hashCode(), (int)ssbs.hashCode());
        SparseBitSetTest.assertEquals((int)bsbs.hashCode(), (int)csbs.hashCode());
        SparseBitSetTest.assertEquals((int)bsbs.hashCode(), (int)isbs.hashCode());
        SparseBitSetTest.assertFalse((bsbs.hashCode() == esbs.hashCode() ? 1 : 0) != 0);
    }

    public final void testRangeConstructor() {
        try {
            SparseBitSet.withRanges(1);
            SparseBitSetTest.fail((String)"Mismatched ranges");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            SparseBitSet.withRanges(1, 4, 4, 5);
            SparseBitSetTest.fail((String)"Discontiguous ranges");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            SparseBitSet.withRanges(4, 5, 1, 3);
            SparseBitSetTest.fail((String)"Misordered ranges");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            SparseBitSet.withRanges(0, 0);
            SparseBitSetTest.fail((String)"Empty range");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public final void testDupeMembers() {
        SparseBitSet sbs1 = SparseBitSet.withMembers(0, 1, 4, 9);
        SparseBitSetTest.assertEquals((String)sbs1.toString(), (String)"[0x0-0x1 0x4 0x9]", (String)sbs1.toString());
        SparseBitSet sbs2 = SparseBitSet.withMembers(9, 1, 4, 1, 0);
        SparseBitSetTest.assertEquals((String)sbs2.toString(), (String)"[0x0-0x1 0x4 0x9]", (String)sbs2.toString());
        SparseBitSetTest.assertEquals((Object)sbs1, (Object)sbs2);
        SparseBitSetTest.assertEquals((int)sbs1.hashCode(), (int)sbs2.hashCode());
        for (int i = -10; i < 20; ++i) {
            SparseBitSetTest.assertEquals((String)("" + i), (boolean)sbs1.contains(i), (boolean)sbs2.contains(i));
        }
    }

    public final void testUnion() {
        SparseBitSet a = SparseBitSet.withRanges(3, 12, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 33, 36, 39, 40, 41, 42, 43);
        SparseBitSet b = SparseBitSet.withRanges(1, 4, 6, 9, 11, 14, 15, 18, 26, 27, 28, 29, 33, 36);
        SparseBitSet empty = SparseBitSet.withMembers(new int[0]);
        SparseBitSetTest.assertEquals((Object)empty, (Object)empty.union(empty));
        SparseBitSetTest.assertEquals((Object)a, (Object)a.union(empty));
        SparseBitSetTest.assertEquals((Object)b, (Object)empty.union(b));
        SparseBitSet aUb = a.union(b);
        SparseBitSetTest.assertEquals((String)"[0x1-0xd 0xf-0x12 0x14 0x16 0x18 0x1a 0x1c 0x1e-0x26 0x28 0x2a]", (String)aUb.toString());
        SparseBitSetTest.assertEquals((Object)aUb, (Object)b.union(a));
        SparseBitSetTest.assertEquals((String)"[0x3-0xb 0x12 0x14 0x16 0x18 0x1a 0x1c 0x1e-0x20 0x24-0x26 0x28 0x2a]", (String)a.toString());
        SparseBitSetTest.assertEquals((String)"[0x1-0x3 0x6-0x8 0xb-0xd 0xf-0x11 0x1a 0x1c 0x21-0x23]", (String)b.toString());
    }
}

