/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.util.ContentUrlHandler;
import com.google.caja.util.Maps;
import com.google.caja.util.Strings;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Map;

class SetupUrlHandlers {
    SetupUrlHandlers() {
    }

    public static void init() {
    }

    static {
        URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){
            private Map<String, URLStreamHandler> handlers = Maps.newHashMap();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public URLStreamHandler createURLStreamHandler(String protocol) {
                URLStreamHandler handler;
                protocol = Strings.toLowerCase(protocol);
                Map<String, URLStreamHandler> map = this.handlers;
                synchronized (map) {
                    handler = this.handlers.get(protocol);
                    if (handler == null) {
                        handler = this.createHandler(protocol);
                    }
                }
                return handler;
            }

            private URLStreamHandler createHandler(String protocol) {
                if ("content".equals(protocol = Strings.toLowerCase(protocol))) {
                    return new ContentUrlHandler();
                }
                if (!"http".equals(protocol) && !"https".equals(protocol)) {
                    try {
                        String clname = "sun.net.www.protocol." + protocol + ".Handler";
                        return (URLStreamHandler)Class.forName(clname).newInstance();
                    }
                    catch (Exception e) {
                        System.err.println("No URL Handler for protocol " + protocol);
                    }
                }
                return null;
            }
        });
    }
}

