/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.config;

import com.google.caja.config.ImportResolver;
import com.google.caja.config.JSONWhiteListLoader;
import com.google.caja.config.WhiteList;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.Charsets;
import com.google.caja.util.Pair;
import com.google.caja.util.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import org.json.simple.JSONObject;

public class ConfigUtil {
    public static final ImportResolver RESOURCE_RESOLVER = new ImportResolver(){

        @Override
        public Pair<Reader, FilePosition> resolve(URI uri, URI base, FilePosition uriPos) throws IOException {
            InputStream in;
            if (uri == null) {
                throw new NullPointerException();
            }
            if (!uri.isAbsolute()) {
                if (base == null) {
                    throw new IllegalArgumentException("Missing base URI");
                }
                String scheme = base.getScheme();
                if (!Strings.equalsIgnoreCase("resource", scheme) || !base.isAbsolute()) {
                    throw new IllegalArgumentException("base URI: " + base);
                }
                uri = base.resolve(uri);
            }
            if (!uri.isAbsolute()) {
                throw new IllegalArgumentException("URI not absolute: " + uri);
            }
            String scheme = Strings.toLowerCase(uri.getScheme());
            if ("content".equals(scheme)) {
                String content = uri.getSchemeSpecificPart();
                if (content == null) {
                    throw new IllegalArgumentException("URI missing content: " + uri);
                }
                return Pair.pair(new StringReader(content), FilePosition.startOfFile(new InputSource(uri)));
            }
            if ("resource".equals(scheme)) {
                String path = uri.getPath();
                if (path == null) {
                    throw new IllegalArgumentException("URI missing path: " + uri);
                }
                in = ConfigUtil.class.getResourceAsStream(path);
                if (in == null) {
                    throw new FileNotFoundException(uri.toString());
                }
            } else {
                throw new IllegalArgumentException("URI: " + uri);
            }
            return Pair.pair(new InputStreamReader(in, Charsets.UTF_8.name()), FilePosition.startOfFile(new InputSource(uri)));
        }
    };

    public static WhiteList loadWhiteListFromJson(Reader in, FilePosition src, ImportResolver resolver, MessageQueue mq) throws IOException, ParseException {
        return new JSONWhiteListLoader(src, resolver, mq).loadFrom(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WhiteList loadWhiteListFromJson(URI whitelistUri, ImportResolver resolver, MessageQueue mq) throws IOException, ParseException {
        Pair<Reader, FilePosition> wl = resolver.resolve(whitelistUri, null, null);
        try {
            WhiteList whiteList = new JSONWhiteListLoader((FilePosition)wl.b, resolver, mq).loadFrom((Reader)wl.a);
            return whiteList;
        }
        finally {
            ((Reader)wl.a).close();
        }
    }

    public static WhiteList loadWhiteListFromJson(JSONObject value, FilePosition src, ImportResolver resolver, MessageQueue mq) throws IOException, ParseException {
        return new JSONWhiteListLoader(src, resolver, mq).loadFrom(value);
    }

    private ConfigUtil() {
    }
}

