/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceBinding
extends ModelGroupBinding {
    private List<ParticleBinding> choices = Collections.emptyList();

    public ChoiceBinding(SchemaBinding schema) {
        super(schema);
    }

    @Override
    public ElementBinding getArrayItem() {
        return null;
    }

    @Override
    public void addParticle(ParticleBinding particle) {
        switch (this.choices.size()) {
            case 0: {
                this.choices = Collections.singletonList(particle);
                break;
            }
            case 1: {
                this.choices = new ArrayList<ParticleBinding>(this.choices);
            }
            default: {
                this.choices.add(particle);
            }
        }
        super.addParticle(particle);
    }

    @Override
    public Collection<ParticleBinding> getParticles() {
        return Collections.unmodifiableCollection(this.choices);
    }

    @Override
    public ModelGroupBinding.Cursor newCursor(ParticleBinding particle) {
        return new ModelGroupBinding.Cursor(particle){
            private ParticleBinding currentParticle;
            private ElementBinding element;
            private boolean wildcardContent;

            @Override
            public ParticleBinding getCurrentParticle() {
                if (this.currentParticle == null) {
                    throw new JBossXBRuntimeException("The cursor has not been positioned yet! startElement should be called.");
                }
                return this.currentParticle;
            }

            @Override
            public ElementBinding getElement() {
                if (this.currentParticle == null) {
                    throw new JBossXBRuntimeException("The cursor has not been positioned yet! startElement should be called.");
                }
                return this.element;
            }

            @Override
            public boolean isPositioned() {
                return this.currentParticle != null;
            }

            @Override
            public void endElement(QName qName) {
                if (this.element == null || !this.element.getQName().equals(qName)) {
                    throw new JBossXBRuntimeException("Failed to process endElement for " + qName + " since the current element is " + (this.element == null ? "null" : this.element.getQName().toString()));
                }
                if (this.trace) {
                    ChoiceBinding.this.log.trace((Object)("endElement " + qName + " in " + this.getModelGroup()));
                }
            }

            @Override
            public boolean isWildcardContent() {
                return this.wildcardContent;
            }

            @Override
            protected List<ModelGroupBinding.Cursor> startElement(QName qName, Attributes atts, Set<ModelGroupBinding.Cursor> passedGroups, List<ModelGroupBinding.Cursor> groupStack, boolean required) {
                if (this.trace) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("startElement ").append(qName).append(" in ").append(ChoiceBinding.this.toString());
                    ChoiceBinding.this.log.trace((Object)sb.toString());
                }
                if (this.currentParticle != null) {
                    boolean repeated = false;
                    if (this.currentParticle.getMaxOccursUnbounded() || this.occurence < this.currentParticle.getMinOccurs() || this.occurence < this.currentParticle.getMaxOccurs()) {
                        TermBinding item = this.currentParticle.getTerm();
                        if (item.isElement()) {
                            ElementBinding element = (ElementBinding)item;
                            repeated = qName.equals(element.getQName());
                        } else if (item.isModelGroup()) {
                            ModelGroupBinding modelGroup = (ModelGroupBinding)item;
                            if (!passedGroups.contains(modelGroup)) {
                                switch (passedGroups.size()) {
                                    case 0: {
                                        passedGroups = Collections.singleton(this);
                                        break;
                                    }
                                    case 1: {
                                        passedGroups = new HashSet<ModelGroupBinding.Cursor>(passedGroups);
                                    }
                                    default: {
                                        passedGroups.add(this);
                                    }
                                }
                                int groupStackSize = groupStack.size();
                                boolean isRequired = this.occurence == 0 ? false : this.currentParticle.isRequired(this.occurence);
                                groupStack = modelGroup.newCursor(this.currentParticle).startElement(qName, atts, passedGroups, groupStack, isRequired);
                                repeated = groupStackSize != groupStack.size();
                            }
                        } else if (item.isWildcard()) {
                            WildcardBinding wildcard = (WildcardBinding)item;
                            this.element = wildcard.getElement(qName, atts);
                            boolean bl = repeated = this.element != null;
                        }
                    }
                    if (repeated) {
                        ++this.occurence;
                        groupStack = this.addItem(groupStack, this);
                        if (this.trace) {
                            ChoiceBinding.this.log.trace((Object)("repeated " + qName + " in " + this.getModelGroup() + ", occurence=" + this.occurence + ", term=" + this.currentParticle.getTerm()));
                        }
                    } else {
                        this.wildcardContent = false;
                        this.currentParticle = null;
                        this.element = null;
                        this.occurence = 0;
                    }
                    return groupStack;
                }
                for (int i = 0; i < ChoiceBinding.this.choices.size(); ++i) {
                    boolean found = false;
                    ParticleBinding particle = (ParticleBinding)ChoiceBinding.this.choices.get(i);
                    TermBinding item = particle.getTerm();
                    if (item.isElement()) {
                        ElementBinding element = (ElementBinding)item;
                        if (qName.equals(element.getQName())) {
                            found = true;
                            this.element = element;
                        }
                    } else if (item.isModelGroup()) {
                        ModelGroupBinding modelGroup = (ModelGroupBinding)item;
                        if (!passedGroups.contains(modelGroup)) {
                            switch (passedGroups.size()) {
                                case 0: {
                                    passedGroups = Collections.singleton(this);
                                    break;
                                }
                                case 1: {
                                    passedGroups = new HashSet<ModelGroupBinding.Cursor>(passedGroups);
                                }
                                default: {
                                    passedGroups.add(this);
                                }
                            }
                            int groupStackSize = groupStack.size();
                            boolean isRequired = this.occurence == 0 ? false : particle.isRequired(this.occurence);
                            groupStack = modelGroup.newCursor(particle).startElement(qName, atts, passedGroups, groupStack, isRequired);
                            found = groupStackSize != groupStack.size();
                        }
                    } else if (item.isWildcard()) {
                        WildcardBinding wildcard = (WildcardBinding)item;
                        this.element = wildcard.getElement(qName, atts);
                        if (this.element != null) {
                            found = true;
                            this.wildcardContent = true;
                        }
                    }
                    if (!found) continue;
                    this.occurence = 1;
                    this.currentParticle = particle;
                    groupStack = this.addItem(groupStack, this);
                    if (!this.trace) break;
                    ChoiceBinding.this.log.trace((Object)("found " + qName + " in " + this.getModelGroup() + ", term=" + this.currentParticle.getTerm()));
                    break;
                }
                return groupStack;
            }

            @Override
            protected ElementBinding getElement(QName qName, Attributes atts, Set<ModelGroupBinding.Cursor> passedGroups, boolean ignoreWildcards) {
                return this.getElement(ChoiceBinding.this.choices, qName, atts, passedGroups, ignoreWildcards);
            }
        };
    }

    @Override
    protected boolean mayStartWith(QName qName, Set<ModelGroupBinding> set) {
        boolean result = false;
        for (int i = 0; i < this.choices.size(); ++i) {
            ParticleBinding particle = this.choices.get(i);
            TermBinding item = particle.getTerm();
            if (item instanceof ElementBinding) {
                ElementBinding element = (ElementBinding)item;
                if (!qName.equals(element.getQName())) continue;
                result = true;
                break;
            }
            if (item instanceof ModelGroupBinding) {
                ModelGroupBinding modelGroup = (ModelGroupBinding)item;
                if (set.contains(modelGroup)) continue;
                switch (set.size()) {
                    case 0: {
                        set = Collections.singleton(this);
                        break;
                    }
                    case 1: {
                        set = new HashSet<ModelGroupBinding>(set);
                    }
                    default: {
                        set.add(this);
                    }
                }
                result = modelGroup.mayStartWith(qName, set);
                if (!result) continue;
                break;
            }
            throw new JBossXBRuntimeException("Unexpected item type in model group: " + item);
        }
        return result;
    }

    @Override
    public String getGroupType() {
        return "choice";
    }
}

