/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.future;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.exoplatform.services.cache.future.Loader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FutureCache<K, V, C> {
    private final Loader<K, V, C> loader;
    private final ConcurrentMap<K, FutureTask<V>> futureEntries;
    private static final Log log = ExoLogger.getLogger((String)"exo.kernel.component.cache.FutureCache");

    public FutureCache(Loader<K, V, C> loader) {
        this.loader = loader;
        this.futureEntries = new ConcurrentHashMap<K, FutureTask<V>>();
    }

    protected abstract V get(K var1);

    protected abstract void put(K var1, V var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(final C context, final K key) {
        V value = this.get(key);
        if (value == null) {
            FutureTask future = new FutureTask(new Callable<V>(){

                @Override
                public V call() throws Exception {
                    Object value = FutureCache.this.loader.retrieve(context, key);
                    if (value != null) {
                        FutureCache.this.put(key, value);
                        return value;
                    }
                    return null;
                }
            });
            boolean inserted = true;
            try {
                FutureTask phantom = this.futureEntries.putIfAbsent(key, future);
                if (phantom != null) {
                    future = phantom;
                    inserted = false;
                } else {
                    future.run();
                }
                value = future.get();
            }
            catch (ExecutionException e) {
                log.error((Object)("Computing of resource " + key + " threw an exception"), e.getCause());
            }
            catch (Exception e) {
                log.error((Object)("Retrieval of resource " + key + " threw an exception"), (Throwable)e);
            }
            finally {
                if (inserted) {
                    this.futureEntries.remove(key, future);
                }
            }
        }
        return value;
    }
}

