/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.awt.print.PrinterJob;
import java.io.File;
import javax.print.PrintService;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PrintPDF {
    private static final String PASSWORD = "-password";
    private static final String SILENT = "-silentPrint";
    private static final String PRINTER_NAME = "-printerName";

    private PrintPDF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String password = "";
        String pdfFile = null;
        boolean silentPrint = false;
        String printerName = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(PRINTER_NAME)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                printerName = args[i];
                continue;
            }
            if (args[i].equals(SILENT)) {
                silentPrint = true;
                continue;
            }
            pdfFile = args[i];
        }
        if (pdfFile == null) {
            PrintPDF.usage();
        }
        PDDocument document = null;
        try {
            document = PDDocument.load(pdfFile);
            if (document.isEncrypted()) {
                document.decrypt(password);
            }
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setJobName(new File(pdfFile).getName());
            if (printerName != null) {
                PrintService[] printService = PrinterJob.lookupPrintServices();
                boolean printerFound = false;
                for (int i = 0; !printerFound && i < printService.length; ++i) {
                    if (printService[i].getName().indexOf(printerName) == -1) continue;
                    printJob.setPrintService(printService[i]);
                    printerFound = true;
                }
            }
            if (silentPrint) {
                document.silentPrint(printJob);
            } else {
                document.print(printJob);
            }
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java -jar pdfbox-app-x.y.z.jar PrintPDF [OPTIONS] <PDF file>\n  -password  <password>        Password to decrypt document\n  -silentPrint                 Print without prompting for printer info\n");
        System.exit(1);
    }
}

