/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.cas.RecordNotFoundException;
import org.exoplatform.services.jcr.impl.storage.value.cas.ValueContentAddressStorage;
import org.exoplatform.services.jcr.impl.storage.value.fs.CASableIOSupport;
import org.exoplatform.services.jcr.impl.storage.value.fs.SimpleFileIOChannel;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.CASableDeleteValues;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.CASableWriteValue;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CASableSimpleFileIOChannel
extends SimpleFileIOChannel {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.CASableSimpleFileIOChannel");
    private final CASableIOSupport cas;
    private final ValueContentAddressStorage vcas;

    public CASableSimpleFileIOChannel(File rootDir, FileCleaner cleaner, String storageId, ValueDataResourceHolder resources, ValueContentAddressStorage vcas, String digestAlgo) {
        super(rootDir, cleaner, storageId, resources);
        this.vcas = vcas;
        this.cas = new CASableIOSupport(this, digestAlgo);
    }

    public void write(String propertyId, ValueData value) throws IOException {
        CASableWriteValue o = new CASableWriteValue(value, this.resources, this.cleaner, this.tempDir, propertyId, this.vcas, this.cas);
        o.execute();
        this.changes.add(o);
    }

    public void delete(String propertyId) throws IOException {
        File[] files;
        try {
            files = this.getFiles(propertyId);
        }
        catch (RecordNotFoundException e) {
            files = new File[]{};
        }
        CASableDeleteValues o = new CASableDeleteValues(files, this.resources, this.cleaner, this.tempDir, propertyId, this.vcas);
        o.execute();
        this.changes.add(o);
    }

    protected File getFile(String propertyId, int orderNumber) throws IOException {
        return super.getFile(this.vcas.getIdentifier(propertyId, orderNumber), 0);
    }

    protected File[] getFiles(String propertyId) throws IOException {
        List<String> hids = this.vcas.getIdentifiers(propertyId, true);
        File[] files = new File[hids.size()];
        for (int i = 0; i < hids.size(); ++i) {
            files[i] = super.getFile(hids.get(i), 0);
        }
        return files;
    }
}

