/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl.tika;

import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.parser.Parser;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.document.DocumentReader;
import org.exoplatform.services.document.HandlerNotFoundException;
import org.exoplatform.services.document.impl.DocumentReaderServiceImpl;
import org.exoplatform.services.document.impl.tika.TikaDocumentReader;

public class TikaDocumentReaderServiceImpl
extends DocumentReaderServiceImpl {
    public static final String TIKA_CONFIG_PATH = "tika-configuration";
    private final TikaConfig conf;

    public TikaDocumentReaderServiceImpl(ConfigurationManager configManager, InitParams params) throws Exception {
        super(params);
        if (params != null && params.getValueParam(TIKA_CONFIG_PATH) != null) {
            final InputStream is = configManager.getInputStream(params.getValueParam(TIKA_CONFIG_PATH).getValue());
            this.conf = (TikaConfig)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<TikaConfig>(){

                @Override
                public TikaConfig run() throws Exception {
                    return new TikaConfig(is);
                }
            });
        } else {
            this.conf = TikaConfig.getDefaultConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentReader getDocumentReader(String mimeType) throws HandlerNotFoundException {
        DocumentReader reader = (DocumentReader)this.readers_.get(mimeType = mimeType.toLowerCase());
        if (reader != null) {
            return reader;
        }
        Parser tikaParser = this.conf.getParser(mimeType);
        if (tikaParser != null) {
            TikaDocumentReaderServiceImpl tikaDocumentReaderServiceImpl = this;
            synchronized (tikaDocumentReaderServiceImpl) {
                reader = (DocumentReader)this.readers_.get(mimeType);
                if (reader != null) {
                    return reader;
                }
                reader = new TikaDocumentReader(tikaParser, mimeType);
                HashMap<String, DocumentReader> tmpReaders = new HashMap<String, DocumentReader>(this.readers_);
                tmpReaders.put(mimeType, reader);
                this.readers_ = tmpReaders;
                return reader;
            }
        }
        throw new HandlerNotFoundException("No appropriate properties extractor for " + mimeType);
    }
}

