/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class MySQLMultiDbJDBCConnection
extends MultiDbJDBCConnection {
    protected String PATTERN_ESCAPE_STRING = "\\\\";

    public MySQLMultiDbJDBCConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dbConnection, readOnly, containerName, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_ITEM_BY_NAME = "select * from JCR_MITEM where PARENT_ID=? and NAME=? and I_INDEX=? order by I_CLASS";
        this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ = this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ.replace("from JCR_MITEM I, JCR_MVALUE V", "from JCR_MITEM I force index (JCR_IDX_MITEM_PARENT_NAME), JCR_MVALUE V force index (JCR_IDX_MVALUE_PROPERTY)");
        this.FIND_NODES_AND_PROPERTIES = this.FIND_NODES_AND_PROPERTIES.replace("from JCR_MITEM I", "from JCR_MITEM I force index (PRIMARY)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addNodeRecord(NodeData data) throws SQLException {
        if (data.getParentIdentifier() != null) {
            ResultSet item = this.findItemByIdentifier(data.getParentIdentifier());
            try {
                if (!item.next()) {
                    throw new SQLException("Parent is not found. Behaviour of " + this.JCR_FK_ITEM_PARENT);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    item.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                item.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
        }
        return super.addNodeRecord(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addPropertyRecord(PropertyData data) throws SQLException {
        if (data.getParentIdentifier() != null) {
            ResultSet item = this.findItemByIdentifier(data.getParentIdentifier());
            try {
                if (!item.next()) {
                    throw new SQLException("Parent is not found. Behaviour of " + this.JCR_FK_ITEM_PARENT);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    item.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e));
                }
                throw throwable;
            }
            try {
                item.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
        }
        return super.addPropertyRecord(data);
    }

    protected String getLikeExpressionEscape() {
        return this.PATTERN_ESCAPE_STRING;
    }
}

