/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.util.Callback;
import java.io.Flushable;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Concatenator
implements TokenConsumer {
    private final Appendable out;
    private final Callback<IOException> ioExceptionHandler;
    private boolean closed;

    public Concatenator(Appendable out, Callback<IOException> ioExceptionHandler) {
        this.out = out;
        this.ioExceptionHandler = ioExceptionHandler;
    }

    public Concatenator(StringBuilder out) {
        this(out, null);
    }

    @Override
    public void mark(FilePosition pos) {
    }

    @Override
    public void consume(String text) {
        this.append(text);
    }

    public void append(CharSequence text) {
        if (this.closed) {
            return;
        }
        try {
            this.out.append(text);
        }
        catch (IOException ex) {
            this.closed = true;
            this.ioExceptionHandler.handle(ex);
        }
    }

    public void append(CharSequence text, int offset, int length) {
        if (this.closed) {
            return;
        }
        try {
            this.out.append(text, offset, length);
        }
        catch (IOException ex) {
            this.closed = true;
            this.ioExceptionHandler.handle(ex);
        }
    }

    @Override
    public void noMoreTokens() {
        block3: {
            if (this.out instanceof Flushable) {
                try {
                    ((Flushable)((Object)this.out)).flush();
                }
                catch (IOException ex) {
                    if (this.closed) break block3;
                    this.closed = true;
                    this.ioExceptionHandler.handle(ex);
                }
            }
        }
    }
}

