/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.idm.ExtGroup;
import org.exoplatform.services.organization.idm.IntegrationCache;
import org.exoplatform.services.organization.idm.MembershipDAOImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.PicketLinkIDMServiceImpl;
import org.exoplatform.services.organization.idm.Tools;
import org.gatein.common.logging.LogLevel;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.impl.api.SimpleAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupDAOImpl
implements GroupHandler {
    private static Logger log = LoggerFactory.getLogger(GroupDAOImpl.class);
    public static final String GROUP_LABEL = "label";
    public static final String GROUP_DESCRIPTION = "description";
    private PicketLinkIDMService service_;
    private List<GroupEventListener> listeners_;
    private PicketLinkIDMOrganizationServiceImpl orgService;
    private static final String CYCLIC_ID = "org.gatein.portal.identity.LOOPED_GROUP_ID";

    public GroupDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service) {
        this.service_ = service;
        this.orgService = orgService;
        this.listeners_ = new ArrayList<GroupEventListener>();
    }

    public void addGroupEventListener(GroupEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.add(listener);
    }

    public void removeGroupEventListener(GroupEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.remove(listener);
    }

    public final Group createGroupInstance() {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "createGroupInstance", null);
        }
        return new ExtGroup();
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "createGroup", new Object[]{"broadcast", broadcast});
        }
        this.addChild(null, group, broadcast);
    }

    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "addChild", new Object[]{"parent", parent, "child", child, "broadcast", broadcast});
        }
        org.picketlink.idm.api.Group parentGroup = null;
        String childPLGroupName = this.getPLIDMGroupName(child.getGroupName());
        if (parent != null) {
            String parentPLGroupName = this.getPLIDMGroupName(parent.getGroupName());
            try {
                parentGroup = this.getIdentitySession().getPersistenceManager().findGroup(parentPLGroupName, this.orgService.getConfiguration().getGroupType(parent.getParentId()));
            }
            catch (Exception e) {
                log.info((Object)("Cannot obtain group: " + parentPLGroupName), (Throwable)e);
            }
            ((ExtGroup)child).setId(parent.getId() + "/" + child.getGroupName());
        } else {
            ((ExtGroup)child).setId("/" + child.getGroupName());
        }
        if (broadcast) {
            this.preSave(child, true);
        }
        if (parentGroup != null) {
            ((ExtGroup)child).setParentId(parent.getId());
        }
        org.picketlink.idm.api.Group childGroup = this.persistGroup(child);
        try {
            if (parentGroup != null) {
                this.getIdentitySession().getRelationshipManager().associateGroups(parentGroup, childGroup);
            } else {
                this.getIdentitySession().getRelationshipManager().associateGroups(this.getRootGroup(), childGroup);
            }
        }
        catch (Exception e) {
            log.info((Object)"Cannot associate groups: ", (Throwable)e);
        }
        if (broadcast) {
            this.postSave(child, true);
        }
    }

    public void saveGroup(Group group, boolean broadcast) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "saveGroup", new Object[]{"group", group, "broadcast", broadcast});
        }
        if (broadcast) {
            this.preSave(group, false);
        }
        this.persistGroup(group);
        if (broadcast) {
            this.postSave(group, false);
        }
    }

    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "removeGroup", new Object[]{"group", group, "broadcast", broadcast});
        }
        if (broadcast) {
            this.preDelete(group);
        }
        org.picketlink.idm.api.Group jbidGroup = null;
        String plGroupName = this.getPLIDMGroupName(group.getGroupName());
        try {
            this.orgService.flush();
            jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(plGroupName, this.orgService.getConfiguration().getGroupType(group.getParentId()));
        }
        catch (Exception e) {
            log.info((Object)("Cannot obtain group: " + plGroupName + "; "), (Throwable)e);
        }
        if (jbidGroup == null) {
            return group;
        }
        try {
            this.orgService.flush();
            Collection oneLevelChilds = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, true, false);
            Collection allChilds = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, true, true);
            this.getIdentitySession().getRelationshipManager().disassociateGroups(jbidGroup, oneLevelChilds);
            for (org.picketlink.idm.api.Group child : allChilds) {
                this.getIdentitySession().getPersistenceManager().removeGroup(child, true);
            }
        }
        catch (Exception e) {
            log.info((Object)("Cannot clear group relationships: " + plGroupName + "; "), (Throwable)e);
        }
        try {
            this.getIdentitySession().getPersistenceManager().removeGroup(jbidGroup, true);
        }
        catch (Exception e) {
            log.info((Object)("Cannot remove group: " + plGroupName + "; "), (Throwable)e);
        }
        if (broadcast) {
            this.postDelete(group);
        }
        return group;
    }

    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "findGroupsByMembership", new Object[]{"userName", membershipType});
        }
        Collection allRoles = new HashSet();
        try {
            this.orgService.flush();
            allRoles = this.getIdentitySession().getRoleManager().findRoles(userName, membershipType);
        }
        catch (Exception e) {
            log.info((Object)"Identity operation error: ", (Throwable)e);
        }
        HashSet<Group> exoGroups = new HashSet<Group>();
        MembershipDAOImpl mmm = (MembershipDAOImpl)this.orgService.getMembershipHandler();
        for (Role role : allRoles) {
            if (!mmm.isCreateMembership(role.getRoleType().getName())) continue;
            exoGroups.add(this.convertGroup(role.getGroup()));
        }
        if (mmm.isAssociationMapped() && mmm.getAssociationMapping().equals(membershipType)) {
            Collection groups = new HashSet();
            try {
                this.orgService.flush();
                groups = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(userName, null);
            }
            catch (Exception e) {
                log.info((Object)"Identity operation error: ", (Throwable)e);
            }
            for (org.picketlink.idm.api.Group group : groups) {
                exoGroups.add(this.convertGroup(group));
            }
        }
        LinkedList result = new LinkedList(exoGroups);
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "findGroupByMembership", result);
        }
        return result;
    }

    public Group findGroupById(String groupId) throws Exception {
        org.picketlink.idm.api.Group jbidGroup;
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "findGroupById", new Object[]{"groupId", groupId});
        }
        if ((jbidGroup = this.orgService.getJBIDMGroup(groupId)) == null) {
            if (log.isTraceEnabled()) {
                Tools.logMethodOut(log, LogLevel.TRACE, "findGroupById", null);
            }
            return null;
        }
        Group result = this.convertGroup(jbidGroup);
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "findGroupById", result);
        }
        return result;
    }

    public Collection findGroups(Group parent) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "findGroups", new Object[]{"parent", parent});
        }
        org.picketlink.idm.api.Group jbidGroup = null;
        if (parent == null) {
            jbidGroup = this.getRootGroup();
        } else {
            try {
                String plGroupName = this.getPLIDMGroupName(parent.getGroupName());
                jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(plGroupName, this.orgService.getConfiguration().getGroupType(parent.getParentId()));
            }
            catch (Exception e) {
                log.info((Object)"Identity operation error: ", (Throwable)e);
            }
        }
        if (jbidGroup == null) {
            return Collections.emptyList();
        }
        String parentId = parent == null ? null : parent.getParentId();
        HashSet plGroups = new HashSet();
        try {
            this.orgService.flush();
            plGroups.addAll(this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, true, false));
        }
        catch (Exception e) {
            log.info((Object)"Identity operation error: ", (Throwable)e);
        }
        if (this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
            String id = parent != null ? parent.getId() : "/";
            for (String type : this.orgService.getConfiguration().getTypes(id)) {
                try {
                    plGroups.addAll(this.getIdentitySession().getPersistenceManager().findGroup(type));
                }
                catch (Exception e) {
                    log.info((Object)"Identity operation error: ", (Throwable)e);
                }
            }
        }
        HashSet<Group> exoGroups = new HashSet<Group>();
        org.picketlink.idm.api.Group root = this.getRootGroup();
        for (org.picketlink.idm.api.Group group : plGroups) {
            if (group.equals(root)) continue;
            Group g = this.convertGroup(group);
            if (this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
                String id = g.getParentId();
                if (!(parent == null && id == null || parent != null && id != null && id.equals(parent.getId())) && (parent != null || id == null || !id.equals("/"))) continue;
                exoGroups.add(g);
                continue;
            }
            exoGroups.add(g);
        }
        LinkedList results = new LinkedList(exoGroups);
        if (this.orgService.getConfiguration().isSortGroups()) {
            Collections.sort(results);
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "findGroups", results);
        }
        return results;
    }

    public Collection findGroupsOfUser(String user) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "findGroupsOfUser", new Object[]{"user", user});
        }
        if (user == null) {
            if (log.isTraceEnabled()) {
                Tools.logMethodOut(log, LogLevel.TRACE, "findGroupsOfUser", Collections.emptyList());
            }
            return Collections.emptyList();
        }
        Collection allGroups = new HashSet();
        try {
            this.orgService.flush();
            allGroups = this.getIdentitySession().getRelationshipManager().findRelatedGroups(user, null, null);
        }
        catch (Exception e) {
            log.info((Object)"Identity operation error: ", (Throwable)e);
        }
        LinkedList<Group> exoGroups = new LinkedList<Group>();
        for (org.picketlink.idm.api.Group group : allGroups) {
            exoGroups.add(this.convertGroup(group));
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "findGroupsOfUser", exoGroups);
        }
        return exoGroups;
    }

    public Collection getAllGroups() throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "getAllGroups", null);
        }
        HashSet plGroups = new HashSet();
        try {
            this.orgService.flush();
            plGroups.addAll(this.getIdentitySession().getRelationshipManager().findAssociatedGroups(this.getRootGroup(), null, true, true));
        }
        catch (Exception e) {
            log.info((Object)"Identity operation error: ", (Throwable)e);
        }
        if (this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
            for (String type : this.orgService.getConfiguration().getAllTypes()) {
                try {
                    plGroups.addAll(this.getIdentitySession().getPersistenceManager().findGroup(type));
                }
                catch (Exception e) {
                    log.info((Object)"Identity operation error: ", (Throwable)e);
                }
            }
        }
        HashSet<Group> exoGroups = new HashSet<Group>();
        org.picketlink.idm.api.Group root = this.getRootGroup();
        for (org.picketlink.idm.api.Group group : plGroups) {
            if (group.equals(root)) continue;
            exoGroups.add(this.convertGroup(group));
        }
        LinkedList result = new LinkedList(exoGroups);
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "getAllGroups", result);
        }
        return result;
    }

    private void preSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preSave(group, isNew);
        }
    }

    private void postSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postSave(group, isNew);
        }
    }

    private void preDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preDelete(group);
        }
    }

    private void postDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postDelete(group);
        }
    }

    protected Group convertGroup(org.picketlink.idm.api.Group jbidGroup) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "convertGroup", new Object[]{"jbidGroup", jbidGroup});
        }
        Map attrs = new HashMap();
        try {
            this.orgService.flush();
            attrs = this.getIdentitySession().getAttributesManager().getAttributes((IdentityType)jbidGroup);
        }
        catch (Exception e) {
            log.info((Object)"Identity operation error: ", (Throwable)e);
        }
        String gtnGroupName = this.getGtnGroupName(jbidGroup.getName());
        ExtGroup exoGroup = new ExtGroup(gtnGroupName);
        if (attrs.containsKey(GROUP_DESCRIPTION) && ((Attribute)attrs.get(GROUP_DESCRIPTION)).getValue() != null) {
            exoGroup.setDescription(((Attribute)attrs.get(GROUP_DESCRIPTION)).getValue().toString());
        }
        if (attrs.containsKey(GROUP_LABEL) && ((Attribute)attrs.get(GROUP_LABEL)).getValue() != null) {
            exoGroup.setLabel(((Attribute)attrs.get(GROUP_LABEL)).getValue().toString());
        } else {
            exoGroup.setLabel(gtnGroupName);
        }
        String id = this.getGroupId(jbidGroup, null);
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "getGroupId", id);
        }
        exoGroup.setId(id);
        if (id.length() == gtnGroupName.length() + 1) {
            exoGroup.setParentId(null);
        } else if (!id.equals("") && !id.equals("/")) {
            exoGroup.setParentId(id.substring(0, id.lastIndexOf("/")));
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "convertGroup", exoGroup);
        }
        return exoGroup;
    }

    private String getGroupId(org.picketlink.idm.api.Group jbidGroup, List<org.picketlink.idm.api.Group> processed) throws Exception {
        String cachedId;
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "getGroupId", new Object[]{"jbidGroup", jbidGroup, "processed", processed});
        }
        if (this.getIntegrationCache() != null && (cachedId = this.getIntegrationCache().getGtnGroupId(this.getCacheNS(), jbidGroup.getKey())) != null) {
            return cachedId;
        }
        if (jbidGroup.equals(this.getRootGroup())) {
            String calculatedId = "";
            if (this.getIntegrationCache() != null) {
                this.getIntegrationCache().putGtnGroupId(this.getCacheNS(), jbidGroup.getKey(), calculatedId);
            }
            return calculatedId;
        }
        if (processed == null) {
            processed = new LinkedList<org.picketlink.idm.api.Group>();
        }
        Collection parents = new HashSet();
        String gtnGroupName = this.getGtnGroupName(jbidGroup.getName());
        try {
            this.orgService.flush();
            parents = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, false, false);
        }
        catch (Exception e) {
            log.info((Object)"Identity operation error: ", (Throwable)e);
        }
        if (parents.size() > 0 && processed.contains(parents.iterator().next())) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Detected looped relationship between groups!!!");
            }
            processed.remove(processed.size() - 1);
            return CYCLIC_ID;
        }
        if (parents.size() == 0 || parents.size() > 1) {
            if (parents.size() > 1) {
                log.info((Object)("PLIDM Group has more than one parent: " + jbidGroup.getName() + "; Will try to use parent path " + "defined by type mappings or just place it under root /"));
            }
            String calculatedId = this.obtainMappedId(jbidGroup, gtnGroupName);
            if (this.getIntegrationCache() != null) {
                this.getIntegrationCache().putGtnGroupId(this.getCacheNS(), jbidGroup.getKey(), calculatedId);
            }
            return calculatedId;
        }
        processed.add(jbidGroup);
        String parentGroupId = this.getGroupId((org.picketlink.idm.api.Group)parents.iterator().next(), processed);
        if (parentGroupId.equals(CYCLIC_ID)) {
            if (processed.size() > 0) {
                processed.remove(processed.size() - 1);
                return parentGroupId;
            }
            String calculatedId = this.obtainMappedId(jbidGroup, gtnGroupName);
            if (this.getIntegrationCache() != null) {
                this.getIntegrationCache().putGtnGroupId(this.getCacheNS(), jbidGroup.getKey(), calculatedId);
            }
            return calculatedId;
        }
        String calculatedId = parentGroupId + "/" + gtnGroupName;
        if (this.getIntegrationCache() != null) {
            this.getIntegrationCache().putGtnGroupId(this.getCacheNS(), jbidGroup.getKey(), calculatedId);
        }
        return calculatedId;
    }

    private String obtainMappedId(org.picketlink.idm.api.Group jbidGroup, String gtnGroupName) {
        String id = this.orgService.getConfiguration().getParentId(jbidGroup.getGroupType());
        if (id != null && this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
            if (id.endsWith("/*")) {
                id = id.substring(0, id.length() - 2);
            }
            return id + "/" + gtnGroupName;
        }
        return "/" + gtnGroupName;
    }

    private org.picketlink.idm.api.Group persistGroup(Group exoGroup) throws Exception {
        org.picketlink.idm.api.Group jbidGroup = null;
        String plGroupName = this.getPLIDMGroupName(exoGroup.getGroupName());
        try {
            jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(plGroupName, this.orgService.getConfiguration().getGroupType(exoGroup.getParentId()));
        }
        catch (Exception e) {
            log.info((Object)"Identity operation error: ", (Throwable)e);
        }
        if (jbidGroup == null) {
            try {
                jbidGroup = this.getIdentitySession().getPersistenceManager().createGroup(plGroupName, this.orgService.getConfiguration().getGroupType(exoGroup.getParentId()));
            }
            catch (Exception e) {
                log.info((Object)"Identity operation error: ", (Throwable)e);
            }
        }
        String description = exoGroup.getDescription();
        String label = exoGroup.getLabel();
        ArrayList<SimpleAttribute> attrsList = new ArrayList<SimpleAttribute>();
        if (description != null) {
            attrsList.add(new SimpleAttribute(GROUP_DESCRIPTION, (Object)description));
        }
        if (label != null) {
            attrsList.add(new SimpleAttribute(GROUP_LABEL, (Object)label));
        }
        if (attrsList.size() > 0) {
            Attribute[] attrs = new Attribute[attrsList.size()];
            attrs = attrsList.toArray(attrs);
            try {
                this.getIdentitySession().getAttributesManager().updateAttributes((IdentityType)jbidGroup, attrs);
            }
            catch (Exception e) {
                log.info((Object)"Identity operation error: ", (Throwable)e);
            }
        }
        return jbidGroup;
    }

    private IdentitySession getIdentitySession() throws Exception {
        return this.service_.getIdentitySession();
    }

    private IntegrationCache getIntegrationCache() {
        return ((PicketLinkIDMServiceImpl)this.service_).getIntegrationCache();
    }

    private String getCacheNS() {
        return ((PicketLinkIDMServiceImpl)this.service_).getRealmName();
    }

    protected org.picketlink.idm.api.Group getRootGroup() throws Exception {
        org.picketlink.idm.api.Group rootGroup = null;
        if (this.getIntegrationCache() != null) {
            rootGroup = this.getIntegrationCache().getRootGroup(this.getCacheNS());
        }
        if (rootGroup == null) {
            rootGroup = this.obtainRootGroup();
            if (this.getIntegrationCache() != null) {
                this.getIntegrationCache().putRootGroup(this.getCacheNS(), rootGroup);
            }
        }
        return rootGroup;
    }

    protected org.picketlink.idm.api.Group obtainRootGroup() throws Exception {
        org.picketlink.idm.api.Group rootGroup = null;
        try {
            rootGroup = this.getIdentitySession().getPersistenceManager().findGroup(this.orgService.getConfiguration().getRootGroupName(), this.orgService.getConfiguration().getGroupType("/"));
        }
        catch (Exception e) {
            log.info((Object)"Identity operation error: ", (Throwable)e);
        }
        if (rootGroup == null) {
            try {
                rootGroup = this.getIdentitySession().getPersistenceManager().createGroup(this.orgService.getConfiguration().getRootGroupName(), this.orgService.getConfiguration().getGroupType("/"));
            }
            catch (Exception e) {
                log.info((Object)"Identity operation error: ", (Throwable)e);
            }
        }
        return rootGroup;
    }

    public String getPLIDMGroupName(String gtnGroupName) {
        return this.orgService.getConfiguration().getPLIDMGroupName(gtnGroupName);
    }

    public String getGtnGroupName(String plidmGroupName) {
        return this.orgService.getConfiguration().getGtnGroupName(plidmGroupName);
    }
}

