/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.url;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.url.MimeType;
import org.exoplatform.web.url.URLContext;
import org.gatein.common.util.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortalURL<R, U extends PortalURL<R, U>> {
    private static final ParameterMap.AccessMode ACCES_MODE = ParameterMap.AccessMode.get((boolean)false, (boolean)false);
    private boolean schemeUse;
    private boolean authorityUse;
    private boolean csrfCheck;
    protected Boolean ajax;
    protected String confirm;
    protected ParameterMap queryParams;
    protected MimeType mimeType;
    private Locale locale;
    private final URLContext context;

    public PortalURL(URLContext context) throws NullPointerException {
        if (context == null) {
            throw new NullPointerException("No context");
        }
        this.authorityUse = false;
        this.schemeUse = false;
        this.context = context;
        this.ajax = null;
        this.locale = null;
        this.confirm = null;
        this.queryParams = null;
        this.mimeType = null;
    }

    public boolean getSchemeUse() {
        return this.schemeUse;
    }

    public void setSchemeUse(boolean schemeUse) {
        if (schemeUse) {
            this.authorityUse = true;
        }
        this.schemeUse = schemeUse;
    }

    public boolean getAuthorityUse() {
        return this.authorityUse;
    }

    public void setAuthorityUse(boolean authorityUse) {
        if (!authorityUse) {
            this.schemeUse = false;
        }
        this.authorityUse = authorityUse;
    }

    public final Boolean getAjax() {
        return this.ajax;
    }

    public final U setAjax(Boolean ajax) {
        this.ajax = ajax;
        return (U)this;
    }

    public final String getConfirm() {
        return this.confirm;
    }

    public final U setConfirm(String confirm) {
        this.confirm = confirm;
        return (U)this;
    }

    public abstract R getResource();

    public abstract U setResource(R var1);

    public abstract Set<QualifiedName> getParameterNames();

    public abstract String getParameterValue(QualifiedName var1);

    public final MimeType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean isCSRFCheck() {
        return this.csrfCheck;
    }

    public void setCSRFCheck(boolean csrfCheck) {
        this.csrfCheck = csrfCheck;
    }

    public void reset() {
        Map<String, String[]> params = this.getQueryParameters();
        if (params != null) {
            params.clear();
        }
    }

    public Map<String, String[]> getQueryParameters() {
        return this.queryParams;
    }

    public String getQueryParameterValue(String parameterName) throws NullPointerException {
        if (parameterName == null) {
            throw new NullPointerException("No null parameter name");
        }
        if (this.queryParams == null) {
            return null;
        }
        String[] parameterValues = (String[])this.queryParams.get((Object)parameterName);
        return parameterValues != null ? parameterValues[0] : null;
    }

    public final void setQueryParameterValue(String parameterName, String parameterValue) throws NullPointerException {
        if (parameterName == null) {
            throw new NullPointerException("No null parameter name");
        }
        if (parameterValue == null) {
            if (this.queryParams != null) {
                this.queryParams.remove((Object)parameterName);
            }
        } else {
            if (this.queryParams == null) {
                this.queryParams = new ParameterMap(ACCES_MODE);
            }
            this.queryParams.setValue(parameterName, parameterValue);
        }
    }

    public final String[] getQueryParameterValues(String parameterName) throws NullPointerException {
        if (parameterName == null) {
            throw new NullPointerException("No null parameter name");
        }
        return this.queryParams != null ? this.queryParams.getValues(parameterName) : null;
    }

    public final void setQueryParameterValues(String parameterName, String[] parameterValues) throws NullPointerException {
        if (parameterName == null) {
            throw new NullPointerException("No null parameter name");
        }
        if (parameterValues == null) {
            if (this.queryParams != null) {
                this.queryParams.remove((Object)parameterName);
            }
        } else {
            if (this.queryParams == null) {
                this.queryParams = new ParameterMap(ACCES_MODE);
            }
            this.queryParams.setValues(parameterName, parameterValues);
        }
    }

    public final String toString() {
        PortalURL _this = this;
        return this.context.render(_this);
    }
}

