/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.backup.BackupChain;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupConfigurationException;
import org.exoplatform.services.jcr.ext.backup.BackupJob;
import org.exoplatform.services.jcr.ext.backup.BackupJobListener;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.impl.AbstractFullBackupJob;
import org.exoplatform.services.jcr.ext.backup.impl.AbstractIncrementalBackupJob;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupChainImpl
implements BackupChain {
    private final BackupConfig config;
    private List<BackupJob> jobs;
    private AbstractFullBackupJob fullBackup;
    private AbstractIncrementalBackupJob incrementalBackup;
    private final BackupChainLog chainLog;
    private final String backupId;
    private int state;
    private PeriodConroller periodConroller;
    private Timer timer;
    private final Calendar timeStamp;
    private Set<BackupJobListener> listeners = new LinkedHashSet<BackupJobListener>();

    public BackupChainImpl(BackupConfig config, File logDirectory, RepositoryService repositoryService, String fullBackupType, String incrementalBackupType, String backupId, File rootDir, Calendar startTime) throws BackupOperationException, BackupConfigurationException {
        this.config = config;
        this.jobs = new ArrayList<BackupJob>();
        this.timeStamp = startTime;
        this.chainLog = new BackupChainLog(logDirectory, config, fullBackupType, incrementalBackupType, backupId, repositoryService.getConfig(), rootDir);
        this.backupId = backupId;
        ManageableRepository repository = null;
        try {
            repository = repositoryService.getRepository(config.getRepository());
        }
        catch (RepositoryConfigurationException e) {
            throw new BackupOperationException("Can not get repository \"" + config.getRepository() + "\"", e);
        }
        catch (RepositoryException e) {
            throw new BackupOperationException("Can not get repository \"" + config.getRepository() + "\"", e);
        }
        try {
            this.fullBackup = (AbstractFullBackupJob)Class.forName(fullBackupType).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new BackupConfigurationException("FullBackupType error, " + e, e);
        }
        catch (InstantiationException e) {
            throw new BackupConfigurationException("FullBackupType error, " + e, e);
        }
        catch (IllegalAccessException e) {
            throw new BackupConfigurationException("FullBackupType error, " + e, e);
        }
        this.fullBackup.init(repository, config.getWorkspace(), config, this.timeStamp);
        if (config.getBackupType() == 1) {
            try {
                this.incrementalBackup = (AbstractIncrementalBackupJob)Class.forName(incrementalBackupType).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new BackupConfigurationException("IncrementalBackupType error, " + e, e);
            }
            catch (InstantiationException e) {
                throw new BackupConfigurationException("IncrementalBackupType error, " + e, e);
            }
            catch (IllegalAccessException e) {
                throw new BackupConfigurationException("IncrementalBackupType error, " + e, e);
            }
            this.incrementalBackup.init(repository, config.getWorkspace(), config, this.timeStamp);
            this.periodConroller = new PeriodConroller(config.getIncrementalJobPeriod() * 1000L);
        }
        this.state = 0;
        this.timer = new Timer("BackupChain_" + this.getBackupConfig().getRepository() + "@" + this.getBackupConfig().getWorkspace() + "_PeriodTimer_" + new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date()), true);
    }

    private void addJobListeners(BackupJob job) {
        for (BackupJobListener jl : this.listeners) {
            job.addListener(jl);
        }
    }

    private void removeJobListeners(BackupJob job) {
        for (BackupJobListener jl : this.listeners) {
            job.removeListener(jl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(BackupJobListener listener) {
        if (listener != null) {
            Collection<Object> collection = this.jobs;
            synchronized (collection) {
                for (BackupJob job : this.jobs) {
                    job.addListener(listener);
                }
            }
            collection = this.listeners;
            synchronized (collection) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(BackupJobListener listener) {
        if (listener != null) {
            Collection<Object> collection;
            try {
                collection = this.jobs;
                synchronized (collection) {
                    for (BackupJob job : this.jobs) {
                        job.removeListener(listener);
                    }
                }
            }
            finally {
                collection = this.listeners;
                synchronized (collection) {
                    this.listeners.remove(listener);
                }
            }
        }
    }

    @Override
    public List<BackupJob> getBackupJobs() {
        return this.jobs;
    }

    @Override
    public final synchronized void startBackup() {
        this.addJobListeners(this.fullBackup);
        Thread fexecutor = new Thread((Runnable)this.fullBackup, this.config.getRepository() + "@" + this.config.getWorkspace() + "-" + this.fullBackup.getId());
        fexecutor.start();
        this.state |= 1;
        this.chainLog.addJobEntry(this.fullBackup);
        this.jobs.add(this.fullBackup);
        if (this.incrementalBackup != null) {
            this.addJobListeners(this.incrementalBackup);
            Thread iexecutor = new Thread((Runnable)this.incrementalBackup, this.config.getRepository() + "@" + this.config.getWorkspace() + "-" + this.incrementalBackup.getId());
            iexecutor.start();
            this.state |= 2;
            this.chainLog.addJobEntry(this.incrementalBackup);
            this.jobs.add(this.incrementalBackup);
            if (this.config.getIncrementalJobPeriod() > 0L) {
                this.periodConroller.start();
            }
        }
    }

    @Override
    public final synchronized void stopBackup() {
        if (!this.chainLog.isFinilized()) {
            this.fullBackup.stop();
            this.chainLog.addJobEntry(this.fullBackup);
            this.removeJobListeners(this.fullBackup);
            if (this.incrementalBackup != null) {
                if (this.config.getIncrementalJobPeriod() > 0L) {
                    this.periodConroller.stop();
                }
                this.incrementalBackup.stop();
                this.chainLog.addJobEntry(this.incrementalBackup);
                this.removeJobListeners(this.incrementalBackup);
            }
            this.state |= 4;
            this.chainLog.endLog();
        }
    }

    public void restartIncrementalBackup() {
        this.incrementalBackup.suspend();
        this.incrementalBackup.resume();
        this.chainLog.addJobEntry(this.incrementalBackup);
    }

    @Override
    public BackupConfig getBackupConfig() {
        return this.config;
    }

    @Override
    public int getFullBackupState() {
        return this.fullBackup.getState();
    }

    @Override
    public int getIncrementalBackupState() {
        if (this.incrementalBackup == null) {
            throw new IllegalStateException("The incremental bacup was not configured. Only full backup.");
        }
        return this.incrementalBackup.getState();
    }

    @Override
    public String getLogFilePath() {
        return this.chainLog.getLogFilePath();
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public boolean isFinished() {
        return (this.state & 4) == 4;
    }

    @Override
    public String getBackupId() {
        return this.backupId;
    }

    @Override
    public Calendar getStartedTime() {
        return this.timeStamp;
    }

    private class PeriodConroller
    extends TimerTask {
        protected Log log = ExoLogger.getLogger("exo.jcr.component.ext.PeriodConroller");
        protected Long period;
        private boolean isFirst = false;

        public PeriodConroller(long period) {
            this.period = period;
        }

        public void run() {
            if (BackupChainImpl.this.incrementalBackup.getState() == 4) {
                this.stop();
            } else if (!this.isFirst) {
                this.isFirst = true;
            } else {
                Thread starter = new Thread("IncrementalBackup Starter"){

                    public void run() {
                        BackupChainImpl.this.restartIncrementalBackup();
                        if (PeriodConroller.this.log.isDebugEnabled()) {
                            PeriodConroller.this.log.debug("Restart incrementalBackup :" + new Date().toString());
                        }
                    }
                };
                starter.start();
            }
        }

        public void start() {
            BackupChainImpl.this.timer.schedule((TimerTask)this, new Date(), (long)this.period);
        }

        public boolean stop() {
            this.log.info("Stop period controller");
            return this.cancel();
        }
    }
}

