/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rights.Grantee;

public final class HsqlNameManager {
    public static final String DEFAULT_CATALOG_NAME = "PUBLIC";
    private static final HsqlNameManager staticManager = new HsqlNameManager(null);
    private static final HsqlName[] autoColumnNames;
    private static final String[] autoNoNameColumnNames;
    private int serialNumber = 1;
    private int sysNumber = 10000;
    private HsqlName catalogName = new HsqlName(this, "PUBLIC", 1, false);

    public HsqlNameManager(Database database) {
    }

    public HsqlName getCatalogName() {
        return this.catalogName;
    }

    public static HsqlName newSystemObjectName(String string, int n) {
        return new HsqlName(staticManager, string, n, false);
    }

    public static HsqlName newInfoSchemaColumnName(String string, HsqlName hsqlName) {
        HsqlName hsqlName2 = new HsqlName(staticManager, string, false, 9);
        hsqlName2.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        hsqlName2.parent = hsqlName;
        return hsqlName2;
    }

    public static HsqlName newInfoSchemaTableName(String string) {
        HsqlName hsqlName = new HsqlName(staticManager, string, 3, false);
        hsqlName.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        return hsqlName;
    }

    public static HsqlName newInfoSchemaObjectName(String string, boolean bl, int n) {
        HsqlName hsqlName = new HsqlName(staticManager, string, n, bl);
        hsqlName.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        return hsqlName;
    }

    public HsqlName newHsqlName(HsqlName hsqlName, String string, int n) {
        HsqlName hsqlName2 = new HsqlName(this, string, n, false);
        hsqlName2.schema = hsqlName;
        return hsqlName2;
    }

    public HsqlName newHsqlName(String string, boolean bl, int n) {
        return new HsqlName(this, string, bl, n);
    }

    public HsqlName newHsqlName(HsqlName hsqlName, String string, boolean bl, int n) {
        HsqlName hsqlName2 = new HsqlName(this, string, bl, n);
        hsqlName2.schema = hsqlName;
        return hsqlName2;
    }

    public HsqlName newHsqlName(HsqlName hsqlName, String string, boolean bl, int n, HsqlName hsqlName2) {
        HsqlName hsqlName3 = new HsqlName(this, string, bl, n);
        hsqlName3.schema = hsqlName;
        hsqlName3.parent = hsqlName2;
        return hsqlName3;
    }

    public HsqlName newColumnSchemaHsqlName(HsqlName hsqlName, SimpleName simpleName) {
        return this.newColumnHsqlName(hsqlName, simpleName.name, simpleName.isNameQuoted);
    }

    public HsqlName newColumnHsqlName(HsqlName hsqlName, String string, boolean bl) {
        HsqlName hsqlName2 = new HsqlName(this, string, bl, 9);
        hsqlName2.schema = hsqlName.schema;
        hsqlName2.parent = hsqlName;
        return hsqlName2;
    }

    public HsqlName getSubqueryTableName() {
        HsqlName hsqlName = new HsqlName(this, "SYSTEM_SUBQUERY", false, 3);
        hsqlName.schema = SqlInvariants.SYSTEM_SCHEMA_HSQLNAME;
        return hsqlName;
    }

    public HsqlName newAutoName(String string, HsqlName hsqlName, HsqlName hsqlName2, int n) {
        HsqlName hsqlName3 = this.newAutoName(string, null, hsqlName, hsqlName2, n);
        return hsqlName3;
    }

    public HsqlName newSpecificRoutineName(HsqlName hsqlName) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(hsqlName.name).append('_').append(++this.sysNumber);
        HsqlName hsqlName2 = new HsqlName(this, stringBuffer.toString(), 24, hsqlName.isNameQuoted);
        hsqlName2.parent = hsqlName;
        hsqlName2.schema = hsqlName.schema;
        return hsqlName2;
    }

    public static HsqlName getAutoColumnName(int n) {
        if (n < autoColumnNames.length) {
            return autoColumnNames[n];
        }
        return new HsqlName(staticManager, "C_" + (n + 1), 0, false);
    }

    public static String getAutoColumnNameString(int n) {
        if (n < autoColumnNames.length) {
            return HsqlNameManager.autoColumnNames[n].name;
        }
        return "C" + (n + 1);
    }

    public static String getAutoNoNameColumnString(int n) {
        if (n < autoColumnNames.length) {
            return autoNoNameColumnNames[n];
        }
        return String.valueOf(n);
    }

    public static String getAutoSavepointNameString(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer("S");
        stringBuffer.append(l).append('_').append(n);
        return stringBuffer.toString();
    }

    public HsqlName newAutoName(String string, String string2, HsqlName hsqlName, HsqlName hsqlName2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            if (string.length() != 0) {
                stringBuffer.append("SYS_");
                stringBuffer.append(string);
                stringBuffer.append('_');
                if (string2 != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append('_');
                }
                stringBuffer.append(++this.sysNumber);
            }
        } else {
            stringBuffer.append(string2);
        }
        HsqlName hsqlName3 = new HsqlName(this, stringBuffer.toString(), n, false);
        hsqlName3.schema = hsqlName;
        hsqlName3.parent = hsqlName2;
        return hsqlName3;
    }

    void resetNumbering() {
        this.sysNumber = 0;
        this.serialNumber = 0;
    }

    public static SimpleName getSimpleName(String string, boolean bl) {
        return new SimpleName(string, bl);
    }

    static {
        HsqlNameManager.staticManager.serialNumber = Integer.MIN_VALUE;
        autoColumnNames = new HsqlName[32];
        autoNoNameColumnNames = new String[32];
        for (int i = 0; i < autoColumnNames.length; ++i) {
            HsqlNameManager.autoColumnNames[i] = new HsqlName(staticManager, "C" + (i + 1), 0, false);
            HsqlNameManager.autoNoNameColumnNames[i] = String.valueOf(i);
        }
    }

    public static final class HsqlName
    extends SimpleName {
        static HsqlName[] emptyArray = new HsqlName[0];
        HsqlNameManager manager;
        public String statementName;
        public String comment;
        public HsqlName schema;
        public HsqlName parent;
        public Grantee owner;
        public final int type;
        private final int hashCode;
        static final String[] sysPrefixes = new String[]{"SYS_IDX_", "SYS_PK_", "SYS_REF_", "SYS_CT_", "SYS_FK_"};

        private HsqlName(HsqlNameManager hsqlNameManager, int n) {
            this.manager = hsqlNameManager;
            this.type = n;
            this.hashCode = this.manager.serialNumber++;
        }

        private HsqlName(HsqlNameManager hsqlNameManager, String string, boolean bl, int n) {
            this(hsqlNameManager, n);
            this.rename(string, bl);
        }

        private HsqlName(HsqlNameManager hsqlNameManager, String string, int n, boolean bl) {
            this(hsqlNameManager, n);
            this.name = this.statementName = string;
            this.isNameQuoted = bl;
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(string, '\"', true);
            }
        }

        @Override
        public String getStatementName() {
            return this.statementName;
        }

        public String getSchemaQualifiedStatementName() {
            if (this.type == 9) {
                if (this.parent == null || "SYSTEM_SUBQUERY".equals(this.parent.name)) {
                    return this.statementName;
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (this.schema != null) {
                    stringBuffer.append(this.schema.getStatementName());
                    stringBuffer.append('.');
                }
                stringBuffer.append(this.parent.getStatementName());
                stringBuffer.append('.');
                stringBuffer.append(this.statementName);
                return stringBuffer.toString();
            }
            if (this.schema == null) {
                return this.statementName;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this.schema != null) {
                stringBuffer.append(this.schema.getStatementName());
                stringBuffer.append('.');
            }
            stringBuffer.append(this.statementName);
            return stringBuffer.toString();
        }

        public void rename(HsqlName hsqlName) {
            this.rename(hsqlName.name, hsqlName.isNameQuoted);
        }

        public void rename(String string, boolean bl) {
            if (string.length() > 128) {
                throw Error.error(5501, string);
            }
            this.name = string;
            this.statementName = string;
            this.isNameQuoted = bl;
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(string, '\"', true);
            }
            if (string.startsWith("SYS_")) {
                int n = string.lastIndexOf(95) + 1;
                try {
                    int n2 = Integer.parseInt(string.substring(n));
                    if (n2 > this.manager.sysNumber) {
                        this.manager.sysNumber = n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        void rename(String string, String string2, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append('_');
            stringBuffer.append(string2);
            this.rename(stringBuffer.toString(), bl);
        }

        public void setSchemaIfNull(HsqlName hsqlName) {
            if (this.schema == null) {
                this.schema = hsqlName;
            }
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof HsqlName) {
                return this.hashCode == ((HsqlName)object).hashCode;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        static int sysPrefixLength(String string) {
            for (int i = 0; i < sysPrefixes.length; ++i) {
                if (!string.startsWith(sysPrefixes[i])) continue;
                return sysPrefixes[i].length();
            }
            return 0;
        }

        static boolean isReservedName(String string) {
            return HsqlName.sysPrefixLength(string) > 0;
        }

        boolean isReservedName() {
            return HsqlName.isReservedName(this.name);
        }

        public String toString() {
            return this.getClass().getName() + super.hashCode() + "[this.hashCode()=" + this.hashCode + ", name=" + this.name + ", name.hashCode()=" + this.name.hashCode() + ", isNameQuoted=" + this.isNameQuoted + "]";
        }

        public int compareTo(Object object) {
            return this.hashCode - object.hashCode();
        }

        static boolean isRegularIdentifier(String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c >= 'A' && c <= 'Z' || c == '_' && i > 0 || c >= '0' && c <= '9') continue;
                return false;
            }
            return !Tokens.isKeyword(string);
        }
    }

    public static class SimpleName {
        public String name;
        public boolean isNameQuoted;

        private SimpleName() {
        }

        private SimpleName(String string, boolean bl) {
            this.name = string;
            this.isNameQuoted = bl;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof SimpleName) {
                return ((SimpleName)object).isNameQuoted == this.isNameQuoted && ((SimpleName)object).name.equals(this.name);
            }
            return false;
        }

        public String getStatementName() {
            return this.isNameQuoted ? StringConverter.toQuotedString(this.name, '\"', true) : this.name;
        }
    }
}

