/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.command.handler;

import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.command.Command;

public class UploadHandler
extends Command {
    private String action;
    private String[] uploadId;

    public void setAction(String action) {
        this.action = action;
    }

    public void setUploadId(String[] uploadId) {
        this.uploadId = uploadId;
    }

    public void execute(WebAppController controller, HttpServletRequest req, HttpServletResponse res) throws Exception {
        res.setHeader("Cache-Control", "no-cache");
        PortalContainer container = PortalContainer.getInstance();
        UploadService service = (UploadService)container.getComponentInstanceOfType(UploadService.class);
        if (this.action == null || this.action.length() < 1) {
            return;
        }
        UploadServiceAction uploadActionService = UploadServiceAction.valueOf(this.action.toUpperCase());
        if (uploadActionService == UploadServiceAction.PROGRESS) {
            PrintWriter writer = res.getWriter();
            if (this.uploadId == null) {
                return;
            }
            StringBuilder value = new StringBuilder();
            value.append("{\n  upload : {");
            for (int i = 0; i < this.uploadId.length; ++i) {
                UploadResource upResource = service.getUploadResource(this.uploadId[i]);
                if (upResource == null) continue;
                double percent = 100.0;
                if (upResource.getStatus() == 0) {
                    percent = upResource.getUploadedSize() * 100.0 / upResource.getEstimatedSize();
                }
                value.append("\n    \"").append(this.uploadId[i]).append("\": {");
                value.append("\n      \"percent\":").append('\"').append((int)percent).append("\",");
                value.append("\n      \"fileName\":").append('\"').append(this.encodeName(upResource.getFileName())).append("\"");
                value.append("\n    }");
                if (i >= this.uploadId.length - 1) continue;
                value.append(',');
            }
            value.append("\n  }\n}");
            ((Writer)writer).append(value);
        } else if (uploadActionService == UploadServiceAction.UPLOAD) {
            service.createUploadResource(req);
        } else if (uploadActionService == UploadServiceAction.DELETE) {
            service.removeUpload(this.uploadId[0]);
        } else if (uploadActionService == UploadServiceAction.ABORT) {
            service.removeUpload(this.uploadId[0]);
        }
    }

    public String encodeName(String name) throws Exception {
        String[] arr = name.split(" ");
        String str = "";
        for (int i = 0; i < arr.length; ++i) {
            str = str + " " + URLEncoder.encode(arr[i], "UTF-8");
        }
        return str;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum UploadServiceAction {
        PROGRESS,
        UPLOAD,
        DELETE,
        ABORT;

    }
}

