/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.organization;

import java.util.ArrayList;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="system:/groovy/webui/form/UIVTabInputSet.gtmpl")
public class UIUserProfileInputSet
extends UIFormInputSet {
    private String user_;
    public static String MALE = "male";
    public static String FEMALE = "female";

    public UIUserProfileInputSet(String name) throws Exception {
        super(name);
        this.setComponentConfig(UIUserProfileInputSet.class, null);
        UIFormInputSet personalInputSet = new UIFormInputSet("Profile");
        this.addInput(personalInputSet, UserProfile.PERSONAL_INFO_KEYS);
        this.addUIFormInput(personalInputSet);
        UIFormInputSet homeInputSet = new UIFormInputSet("HomeInfo");
        this.addInput(homeInputSet, UserProfile.HOME_INFO_KEYS);
        homeInputSet.setRendered(false);
        this.addUIFormInput(homeInputSet);
        UIFormInputSet businessInputSet = new UIFormInputSet("BusinessInfo");
        this.addInput(businessInputSet, UserProfile.BUSINESE_INFO_KEYS);
        businessInputSet.setRendered(false);
        this.addUIFormInput(businessInputSet);
    }

    public void reset() {
        for (UIComponent uiChild : this.getChildren()) {
            if (!(uiChild instanceof UIFormInputSet) && !(uiChild instanceof UIFormInput)) continue;
            ((UIFormInputSet)uiChild).reset();
        }
    }

    private void addInput(UIFormInputSet set, String[] keys) {
        for (String key : keys) {
            if (key.equalsIgnoreCase("user.gender")) {
                ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
                ls.add(new SelectItemOption(MALE, (Object)MALE));
                ls.add(new SelectItemOption(FEMALE, (Object)FEMALE));
                UIFormSelectBox genderSelectBox = new UIFormSelectBox(key, key, ls);
                set.addUIFormInput((UIFormInput)genderSelectBox);
                continue;
            }
            if (key.equalsIgnoreCase("user.language")) {
                ArrayList<SelectItemOption> lang = new ArrayList<SelectItemOption>();
                LocaleConfigService localeService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
                for (LocaleConfig config : localeService.getLocalConfigs()) {
                    if (config.getLanguage().equals("en")) {
                        lang.add(0, new SelectItemOption(config.getLocale().getDisplayLanguage(), (Object)config.getLanguage()));
                        continue;
                    }
                    lang.add(new SelectItemOption(config.getLocale().getDisplayLanguage(), (Object)config.getLanguage()));
                }
                UIFormSelectBox langSelectBox = new UIFormSelectBox(key, key, lang);
                set.addUIFormInput((UIFormInput)langSelectBox);
                continue;
            }
            set.addUIFormInput((UIFormInput)new UIFormStringInput(key, null, null));
        }
    }

    public void setUserProfile(String user) throws Exception {
        this.user_ = user;
        if (user == null) {
            return;
        }
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        UserProfile userProfile = service.getUserProfileHandler().findUserProfileByName(user);
        if (userProfile == null) {
            userProfile = service.getUserProfileHandler().createUserProfileInstance();
            userProfile.setUserName(user);
        }
        if (userProfile.getUserInfoMap() == null) {
            return;
        }
        for (UIComponent set : this.getChildren()) {
            UIFormInputSet inputSet = (UIFormInputSet)set;
            for (UIComponent uiComp : inputSet.getChildren()) {
                UIFormStringInput uiInput = (UIFormStringInput)uiComp;
                uiInput.setValue((Object)userProfile.getAttribute(uiInput.getName()));
            }
        }
    }

    public void save(OrganizationService service, String user, boolean isnewUser) throws Exception {
        this.user_ = user;
        UserProfileHandler hanlder = service.getUserProfileHandler();
        UserProfile userProfile = hanlder.findUserProfileByName(this.user_);
        if (userProfile == null) {
            userProfile = hanlder.createUserProfileInstance();
            userProfile.setUserName(this.user_);
        }
        for (UIComponent set : this.getChildren()) {
            UIFormInputSet inputSet = (UIFormInputSet)set;
            for (UIComponent uiComp : inputSet.getChildren()) {
                UIFormStringInput uiInput = (UIFormStringInput)uiComp;
                userProfile.getUserInfoMap().put(uiInput.getName(), uiInput.getValue());
            }
        }
        hanlder.saveUserProfile(userProfile, true);
        Object[] args = new Object[]{"UserProfile", this.user_};
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIApplication uiApp = context.getUIApplication();
        if (isnewUser) {
            uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.successful.create.user", args));
            return;
        }
        uiApp.addMessage(new ApplicationMessage("UIUserProfileInputSet.msg.sucsesful.update.userprofile", args));
    }
}

