/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.command.handler;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Gadgets;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.command.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateGadgetContainerHandler
extends Command {
    public void execute(WebAppController controller, HttpServletRequest req, HttpServletResponse res) throws Exception {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            UserPortalConfigService configService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
            String ownerType = "user";
            String ownerId = req.getRemoteUser();
            String gadgetsId = ownerType + "::" + ownerId;
            Gadgets gadgets = configService.getGadgets(gadgetsId);
            if (gadgets == null) {
                gadgets = new Gadgets();
                gadgets.setOwnerType(ownerType);
                gadgets.setOwnerId(ownerId);
                gadgets.setChildren(new ArrayList());
                configService.create(gadgets);
            }
            this.deleteContainer(gadgets, req);
            this.saveContainer(gadgets, req);
            configService.update(gadgets);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private void deleteContainer(Gadgets gadgets, HttpServletRequest req) {
        ArrayList existingContainers = gadgets.getChildren();
        String[] deleteContainers = req.getParameterValues("deleted");
        if (deleteContainers == null) {
            return;
        }
        for (String deletedItem : deleteContainers) {
            Container foundContainer = this.getContainer(existingContainers, deletedItem);
            if (foundContainer == null) continue;
            existingContainers.remove(foundContainer);
        }
    }

    private void saveContainer(Gadgets gadgets, HttpServletRequest req) {
        ArrayList existingContainers = gadgets.getChildren();
        String[] cIds = req.getParameterValues("id");
        String[] cNames = req.getParameterValues("name");
        String[] cDesc = req.getParameterValues("desc");
        if (cIds == null) {
            return;
        }
        for (int i = 0; i < cIds.length; ++i) {
            Container foundContainer = this.getContainer(existingContainers, cIds[i]);
            if (foundContainer != null) {
                foundContainer.setName(cNames[i]);
                foundContainer.setDescription(cDesc[i]);
                continue;
            }
            Container newContainer = this.createContainer(cIds[i], cNames[i], cDesc[i]);
            existingContainers.add(newContainer);
        }
    }

    private Container getContainer(List<Container> list, String id) {
        for (Container ele : list) {
            if (!ele.getId().equals(id)) continue;
            return ele;
        }
        return null;
    }

    private Container createContainer(String id, String name, String desc) {
        Container container = new Container();
        container.setId(id);
        container.setName(name);
        container.setDescription(desc);
        return container;
    }
}

