/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.organization;

import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PasswordStringLengthValidator;
import org.exoplatform.webui.form.validator.ResourceValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

public class UIAccountInputSet
extends UIFormInputWithActions {
    static final String USERNAME = "username";
    static final String PASSWORD1X = "password";
    static final String PASSWORD2X = "Confirmpassword";

    public UIAccountInputSet(String name) throws Exception {
        super(name);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(USERNAME, "userName", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(ResourceValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^[\\p{L}][\\p{L}._\\- \\d]+$", "ResourceValidator.msg.Invalid-char"}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PASSWORD1X, PASSWORD1X, null).setType((short)1).addValidator(MandatoryValidator.class, new Object[0]).addValidator(PasswordStringLengthValidator.class, new Object[]{6, 30}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PASSWORD2X, PASSWORD1X, null).setType((short)1).addValidator(MandatoryValidator.class, new Object[0]).addValidator(PasswordStringLengthValidator.class, new Object[]{6, 30}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("firstName", "firstName", null).addValidator(StringLengthValidator.class, new Object[]{3, 45}).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^[\\p{L}][\\p{ASCII}]+$", "FirstCharacterNameValidator.msg"}).addValidator(ExpressionValidator.class, new Object[]{"^[\\p{L}][\\p{L}._\\- \\d]+$", "ResourceValidator.msg.Invalid-char"}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("lastName", "lastName", null).addValidator(StringLengthValidator.class, new Object[]{3, 45}).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^[\\p{L}][\\p{ASCII}]+$", "FirstCharacterNameValidator.msg"}).addValidator(ExpressionValidator.class, new Object[]{"^[\\p{L}][\\p{L}._\\- \\d]+$", "ResourceValidator.msg.Invalid-char"}));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("email", "email", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(EmailAddressValidator.class, new Object[0]));
    }

    public String getUserName() {
        return (String)this.getUIStringInput(USERNAME).getValue();
    }

    public String getPropertyPrefix() {
        return "UIAccountForm";
    }

    public void setValue(User user) throws Exception {
        if (user == null) {
            return;
        }
        this.invokeGetBindingField(user);
        this.getUIStringInput(USERNAME).setEditable(false);
    }

    public boolean save(OrganizationService service, boolean newUser) throws Exception {
        String pass2x;
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIApplication uiApp = context.getUIApplication();
        String pass1x = (String)this.getUIStringInput(PASSWORD1X).getValue();
        if (!pass1x.equals(pass2x = (String)this.getUIStringInput(PASSWORD2X).getValue())) {
            uiApp.addMessage(new ApplicationMessage("UIAccountForm.msg.password-is-not-match", null));
            return false;
        }
        String username = (String)this.getUIStringInput(USERNAME).getValue();
        if (newUser) {
            User user = service.getUserHandler().createUserInstance(username);
            this.invokeSetBindingField(user);
            if (service.getUserHandler().findUserByName(user.getUserName()) != null) {
                Object[] args = new Object[]{user.getUserName()};
                uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.user-exist", args));
                return false;
            }
            Query query = new Query();
            query.setEmail((String)this.getUIStringInput("email").getValue());
            if (service.getUserHandler().findUsers(query).getAll().size() > 0) {
                Object[] args = new Object[]{user.getUserName()};
                uiApp.addMessage(new ApplicationMessage("UIAccountInputSet.msg.email-exist", args));
                return false;
            }
            service.getUserHandler().createUser(user, true);
            this.reset();
            return true;
        }
        User user = service.getUserHandler().findUserByName(username);
        this.invokeSetBindingField(user);
        service.getUserHandler().saveUser(user, true);
        return true;
    }
}

