/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.command.handler;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.command.Command;

public class DownloadHandler
extends Command {
    private String resourceId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WebAppController controller, HttpServletRequest req, HttpServletResponse res) throws Exception {
        res.setHeader("Cache-Control", "private max-age=600, s-maxage=120");
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        DownloadService dservice = (DownloadService)container.getComponentInstanceOfType(DownloadService.class);
        DownloadResource dresource = dservice.getDownloadResource(this.resourceId);
        if (dresource == null) {
            res.setContentType("text/plain");
            res.getWriter().write("NO DOWNDLOAD RESOURCE CONTENT  OR YOU DO NOT HAVE THE RIGHT TO ACCESS THE CONTENT");
            return;
        }
        String userAgent = req.getHeader("User-Agent");
        if (dresource.getDownloadName() != null) {
            if (userAgent != null && userAgent.contains("MSIE")) {
                res.setHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(dresource.getDownloadName(), "UTF-8") + "\"");
            } else {
                res.setHeader("Content-Disposition", "attachment; filename*=utf-8''" + URLEncoder.encode(dresource.getDownloadName(), "UTF-8") + "");
            }
        }
        res.setContentType(dresource.getResourceMimeType());
        InputStream is = dresource.getInputStream();
        try {
            DownloadHandler.optimalRead(is, (OutputStream)res.getOutputStream());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            is.close();
        }
    }

    public String getResourceId() {
        return this.resourceId;
    }

    private static void optimalRead(InputStream is, OutputStream os) throws Exception {
        int bufferLength = 1024;
        int readLength = 0;
        while (readLength > -1) {
            byte[] chunk = new byte[bufferLength];
            readLength = is.read(chunk);
            if (readLength <= 0) continue;
            os.write(chunk, 0, readLength);
        }
    }
}

