/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.OutputStream;
import org.exoplatform.commons.utils.IOFailureFlow;
import org.exoplatform.commons.utils.Printer;
import org.exoplatform.commons.utils.TextEncoder;
import org.exoplatform.commons.utils.UndeclaredIOException;

public class OutputStreamPrinter
extends Printer {
    private final IOFailureFlow failureFlow;
    private final boolean ignoreOnFailure;
    private final OutputStream out;
    private final TextEncoder encoder;
    private boolean failed;

    public OutputStreamPrinter(TextEncoder encoder, OutputStream out) throws IllegalArgumentException {
        this(encoder, out, IOFailureFlow.RETHROW, false);
    }

    public OutputStreamPrinter(TextEncoder encoder, OutputStream out, IOFailureFlow failureFlow, boolean ignoreOnFailure) throws IllegalArgumentException {
        if (encoder == null) {
            throw new IllegalArgumentException("No null encoder accepted");
        }
        if (out == null) {
            throw new IllegalArgumentException("No null output stream accepted");
        }
        if (failureFlow == null) {
            throw new IllegalArgumentException("No null control flow mode accepted");
        }
        this.encoder = encoder;
        this.out = out;
        this.failureFlow = failureFlow;
        this.failed = false;
        this.ignoreOnFailure = ignoreOnFailure;
    }

    public IOFailureFlow getFailureFlow() {
        return this.failureFlow;
    }

    public boolean getIgnoreOnFailure() {
        return this.ignoreOnFailure;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void write(int c) throws IOException {
        if (!this.failed) {
            try {
                this.encoder.encode((char)c, this.out);
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    public void write(char[] cbuf) throws IOException {
        if (!this.failed) {
            try {
                this.encoder.encode(cbuf, 0, cbuf.length, this.out);
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    public void write(String str) throws IOException {
        if (!this.failed) {
            try {
                this.encoder.encode(str, 0, str.length(), this.out);
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    public void write(String str, int off, int len) throws IOException {
        if (!this.failed) {
            try {
                this.encoder.encode(str, off, len, this.out);
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.failed) {
            try {
                this.encoder.encode(cbuf, off, len, this.out);
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    public void flush() throws IOException {
        if (!this.failed) {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    public void close() throws IOException {
        try {
            this.out.close();
        }
        catch (IOException e) {
            this.handle(e);
        }
    }

    private void handle(IOException e) throws IOException {
        if (this.ignoreOnFailure) {
            this.failed = true;
        }
        switch (this.failureFlow) {
            case IGNORE: {
                break;
            }
            case THROW_UNDECLARED: {
                throw new UndeclaredIOException(e);
            }
            case RETHROW: {
                throw e;
            }
        }
    }
}

