/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.filter;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import org.exoplatform.container.component.ExecutionContext;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.ResourceOutput;
import org.exoplatform.services.portletcontainer.plugins.pc.aop.RenderExecutionContext;
import org.exoplatform.services.portletcontainer.plugins.pc.aop.ResourceExecutionContext;
import org.exoplatform.services.portletcontainer.plugins.pc.filter.PortletFilterWrapper;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletResponseImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers.CustomResponseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletFilterChainImpl
implements FilterChain {
    private final Collection<PortletFilterWrapper> filters;
    private Iterator<PortletFilterWrapper> iterator;
    private boolean goodFinished;
    private ExecutionContext context;
    private Object result;

    public PortletFilterChainImpl(Collection<PortletFilterWrapper> filters) {
        this.filters = filters;
        this.goodFinished = false;
    }

    public final Iterator<PortletFilterWrapper> getFiltersIterator() {
        return this.filters.iterator();
    }

    public final void restart(ExecutionContext context) {
        this.iterator = this.filters.iterator();
        this.goodFinished = false;
        this.context = context;
    }

    public Iterator<PortletFilterWrapper> getIterator() {
        return this.iterator;
    }

    public final void doFilter(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        if (this.iterator.hasNext()) {
            ActionFilter portletFilter = this.iterator.next();
            portletFilter.doFilter(request, response, (FilterChain)this);
        } else {
            try {
                this.result = this.context.executeNextUnit();
            }
            catch (Throwable t) {
                this.result = t;
            }
            this.goodFinished = true;
        }
    }

    public final void doFilter(EventRequest request, EventResponse response) throws IOException, PortletException {
        if (this.iterator.hasNext()) {
            EventFilter portletFilter = this.iterator.next();
            portletFilter.doFilter(request, response, (FilterChain)this);
        } else {
            try {
                this.result = this.context.executeNextUnit();
            }
            catch (Throwable t) {
                this.result = t;
            }
            this.goodFinished = true;
        }
    }

    public final void doFilter(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        if (this.iterator.hasNext()) {
            RenderFilter portletFilter = this.iterator.next();
            portletFilter.doFilter(request, response, (FilterChain)this);
            PortletResponseImp rimpl = (PortletResponseImp)((RenderExecutionContext)this.context).getResponse();
            CustomResponseWrapper responseWrapper = (CustomResponseWrapper)rimpl.getResponse();
            responseWrapper.flushBuffer();
            RenderOutput routput = (RenderOutput)rimpl.getOutput();
            routput.setContentType(responseWrapper.getContentType());
            routput.setContent(responseWrapper.getPortletContent());
            routput.setCacheHit(false);
        } else {
            try {
                this.result = this.context.executeNextUnit();
            }
            catch (Throwable t) {
                this.result = t;
            }
            this.goodFinished = true;
        }
    }

    public final void doFilter(ResourceRequest request, ResourceResponse response) throws IOException, PortletException {
        if (this.iterator.hasNext()) {
            ResourceFilter portletFilter = this.iterator.next();
            portletFilter.doFilter(request, response, (FilterChain)this);
            PortletResponseImp rimpl = (PortletResponseImp)((ResourceExecutionContext)this.context).getResponse();
            CustomResponseWrapper responseWrapper = (CustomResponseWrapper)rimpl.getResponse();
            responseWrapper.flushBuffer();
            ResourceOutput routput = (ResourceOutput)rimpl.getOutput();
            routput.setContentType(responseWrapper.getContentType());
            routput.setContent(responseWrapper.getPortletContent());
            routput.setCacheHit(false);
        } else {
            try {
                this.result = this.context.executeNextUnit();
            }
            catch (Throwable t) {
                this.result = t;
            }
            this.goodFinished = true;
        }
    }

    public Object getResult() throws Throwable {
        if (this.result instanceof Throwable) {
            throw (Throwable)this.result;
        }
        return this.result;
    }

    public boolean isGoodFinished() {
        return this.goodFinished;
    }
}

