/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.tags;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.BaseURL;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ResourceURLImp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XURLTag
extends BodyTagSupport {
    protected WindowState windowState;
    protected PortletMode portletMode;
    protected String var;
    protected boolean secure;
    private HashMap<String, String[]> parameters = null;
    private Map<String, String[]> renderParameters = null;
    private HashMap<String, String[]> properties = new HashMap();
    protected boolean copyCurrentRenderParameters = false;
    protected boolean escapeXml = true;
    protected String resourceID;
    protected String resourceCacheability;

    public final void addParameter(String key, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        if ((value == null || value.equals("")) && this.renderParameters.get(key) != null) {
            this.renderParameters.remove(key);
        }
        if (this.parameters.get(key) == null) {
            if (value != null && !value.equals("")) {
                this.parameters.put(key, new String[]{value});
            }
        } else if (value == null || value.equals("")) {
            this.parameters.remove(key);
        } else {
            String[] oldValue = this.parameters.get(key);
            String[] newValue = new String[oldValue.length + 1];
            int i = 0;
            for (String v : oldValue) {
                newValue[i++] = v;
            }
            newValue[i] = value;
            this.parameters.put(key, newValue);
        }
    }

    protected void addParameters(String key, String[] values) {
        if (this.parameters.get(key) == null) {
            if (values != null) {
                this.parameters.put(key, values);
            }
        } else {
            String[] oldValue = this.parameters.get(key);
            String[] newValue = new String[oldValue.length + values.length];
            int i = 0;
            for (String v : oldValue) {
                newValue[i++] = v;
            }
            for (String v : values) {
                newValue[i++] = v;
            }
            this.parameters.put(key, newValue);
        }
    }

    public final void addProperty(String key, String value) {
        this.properties.put(key, new String[]{value});
    }

    public final void setProperties(BaseURL url, Map<String, String[]> map) {
        if (map == null) {
            return;
        }
        if (map.containsKey(null)) {
            return;
        }
        Set<String> keys = map.keySet();
        for (String name : keys) {
            String[] saVal;
            String[] value = map.get(name);
            if (value instanceof String) {
                url.addProperty(name, (String)value);
                continue;
            }
            if (!(value instanceof String[])) continue;
            for (String sVal : saVal = value) {
                url.addProperty(name, sVal);
            }
        }
    }

    public final void setWindowState(String windowState) {
        this.windowState = WindowState.MAXIMIZED.toString().equalsIgnoreCase(windowState) ? WindowState.MAXIMIZED : (WindowState.MINIMIZED.toString().equalsIgnoreCase(windowState) ? WindowState.MINIMIZED : (WindowState.NORMAL.toString().equalsIgnoreCase(windowState) ? WindowState.NORMAL : new WindowState(windowState)));
    }

    public final void setPortletMode(String portletMode) {
        this.portletMode = PortletMode.EDIT.toString().equalsIgnoreCase(portletMode) ? PortletMode.EDIT : (PortletMode.HELP.toString().equalsIgnoreCase(portletMode) ? PortletMode.HELP : (PortletMode.VIEW.toString().equalsIgnoreCase(portletMode) ? PortletMode.VIEW : new PortletMode(portletMode)));
    }

    public final void setVar(String var) {
        this.var = var;
    }

    public final void setSecure(String secure) {
        this.secure = secure.equals("true");
    }

    public final void setCopyCurrentRenderParameters(boolean copyCurrentRenderParameters) {
        this.copyCurrentRenderParameters = copyCurrentRenderParameters;
    }

    public final void setEscapeXml(boolean escapeXml) {
        this.escapeXml = escapeXml;
    }

    public final void setId(String resourceID) {
        this.resourceID = resourceID;
    }

    public final void setCacheability(String resourceCacheability) {
        if (resourceCacheability != null) {
            this.resourceCacheability = ResourceURLImp.isSupportedCacheLevel(resourceCacheability) ? resourceCacheability : "cacheLevelPage";
        }
    }

    public final int doStartTag() throws JspException {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        ServletRequest request = this.pageContext.getRequest();
        PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
        this.renderParameters = new HashMap<String, String[]>(portletRequest.getParameterMap());
        return 2;
    }

    public int doEndTag() throws JspException {
        BaseURL baseURL = this.getPortletURL();
        if (this.copyCurrentRenderParameters) {
            if (this.parameters == null) {
                this.parameters = new HashMap();
            }
            for (String name : this.renderParameters.keySet()) {
                this.addParameters(name, this.renderParameters.get(name));
            }
        }
        baseURL.setParameters(this.parameters);
        this.setProperties(baseURL, this.properties);
        try {
            block17: {
                try {
                    baseURL.setSecure(this.secure);
                    if (baseURL instanceof PortletURL) {
                        PortletURL portletURL = (PortletURL)baseURL;
                        if (this.portletMode != null) {
                            portletURL.setPortletMode(this.portletMode);
                        }
                        if (this.windowState != null) {
                            portletURL.setWindowState(this.windowState);
                        }
                    } else if (baseURL instanceof ResourceURL) {
                        ResourceURL resourceURL = (ResourceURL)baseURL;
                        resourceURL.setResourceID(this.resourceID);
                        resourceURL.setCacheability(this.resourceCacheability);
                    }
                    if (this.var == null || "".equals(this.var)) {
                        try {
                            this.pageContext.getOut().print(this.URLToString(baseURL));
                            break block17;
                        }
                        catch (IOException e1) {
                            throw new JspException((Throwable)e1);
                        }
                    }
                    this.pageContext.setAttribute(this.var, (Object)this.URLToString(baseURL));
                }
                catch (PortletModeException e) {
                    throw new JspException((Throwable)e);
                }
                catch (WindowStateException e) {
                    throw new JspException((Throwable)e);
                }
                catch (PortletSecurityException e) {
                    throw new JspException((Throwable)e);
                }
            }
            Object var5_8 = null;
            this.cleanUp();
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.cleanUp();
            throw throwable;
        }
        return 6;
    }

    private void cleanUp() {
        this.parameters = null;
        this.properties = null;
        this.windowState = null;
        this.portletMode = null;
        this.var = null;
        this.secure = false;
        this.copyCurrentRenderParameters = false;
        this.escapeXml = true;
        this.resourceID = null;
        this.resourceCacheability = null;
    }

    public final String URLToString(BaseURL baseURL) {
        String url = baseURL.toString();
        if (this.escapeXml) {
            return this.encodeChars(url);
        }
        return url;
    }

    private final String encodeChars(String s) {
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&#034;").replace("'", "&#039;");
    }

    public abstract BaseURL getPortletURL();
}

