/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.PortletContainerConf;
import org.exoplatform.services.portletcontainer.pci.EventOutput;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletContainerDispatcher;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletResponseImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ResponseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateAwareResponseImp
extends PortletResponseImp
implements StateAwareResponse {
    Log log = null;
    private final String[] jaxb8_5_2List = new String[]{"java.lang.String", "java.math.BigInteger", "java.math.BigDecimal", "java.util.Calendar", "java.util.Date", "javax.xml.namespace.QName", "java.net.URI", "javax.xml.datatype.XMLGregorianCalendar", "javax.xml.datatype.Duration", "java.awt.Image", "javax.activation.DataHandler", "javax.xml.transform.Source", "java.util.UUID"};

    public StateAwareResponseImp(ResponseContext resCtx) {
        super(resCtx);
        this.log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    }

    public final void setWindowState(WindowState windowState) throws WindowStateException {
        if (this.isSendRedirectAlreadyOccured()) {
            throw new IllegalStateException("sendRedirect was already called");
        }
        if (windowState == null) {
            throw new WindowStateException("The portlet mode is null", windowState);
        }
        if (windowState == WindowState.NORMAL || windowState == WindowState.MINIMIZED || windowState == WindowState.MAXIMIZED) {
            ((EventOutput)this.getOutput()).setNextState(windowState);
            this.setRedirectionPossible(false);
            return;
        }
        ExoContainer manager = this.getCont();
        Enumeration e = ((PortletContainerConf)manager.getComponentInstanceOfType(PortletContainerConf.class)).getSupportedWindowStates();
        while (e.hasMoreElements()) {
            WindowState state = (WindowState)e.nextElement();
            if (!state.toString().equals(windowState.toString())) continue;
            ((EventOutput)this.getOutput()).setNextState(windowState);
            this.setRedirectionPossible(false);
            return;
        }
        throw new WindowStateException("The window state " + windowState.toString() + " is not supported by the portlet container", windowState);
    }

    public final void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (this.isSendRedirectAlreadyOccured()) {
            throw new IllegalStateException("sendRedirect was already called");
        }
        if (portletMode == null) {
            throw new PortletModeException("The portlet mode is null", portletMode);
        }
        if (portletMode == PortletMode.VIEW) {
            ((EventOutput)this.getOutput()).setNextMode(portletMode);
            this.setRedirectionPossible(false);
            return;
        }
        List l = this.getPortletDatas().getSupports();
        for (Supports supports : l) {
            if (!this.getInput().getMarkup().equals(supports.getMimeType())) continue;
            List modeList = supports.getPortletMode();
            for (String modeString : modeList) {
                if ((modeString = modeString.toLowerCase()) == null || !modeString.equals(portletMode.toString())) continue;
                ((EventOutput)this.getOutput()).setNextMode(portletMode);
                this.setRedirectionPossible(false);
                return;
            }
        }
        throw new PortletModeException("The mode " + portletMode.toString() + " is not supported by that portlet", portletMode);
    }

    public final void setRenderParameters(Map<String, String[]> map) {
        if (map == null) {
            throw new IllegalArgumentException("the map given is null");
        }
        if (map.containsKey(null)) {
            throw new IllegalArgumentException("the map given contains a null key");
        }
        Set<String> keys = map.keySet();
        for (String string : keys) {
            if (string instanceof String) continue;
            throw new IllegalArgumentException("the map contains a non String key");
        }
        Collection<String[]> values = map.values();
        for (String[] name : values) {
            if (name instanceof String[]) continue;
            throw new IllegalArgumentException("the map contains a non String[] value");
        }
        if (this.isSendRedirectAlreadyOccured()) {
            throw new IllegalStateException("sendRedirect was already called");
        }
        this.setRedirectionPossible(false);
        ((EventOutput)this.getOutput()).setRenderParameters(map);
    }

    public final void setRenderParameter(String s, String s1) {
        if (s == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        if (s1 == null) {
            throw new IllegalArgumentException("the value given is null");
        }
        if (this.isSendRedirectAlreadyOccured()) {
            throw new IllegalStateException("sendRedirect was already called");
        }
        this.setRedirectionPossible(false);
        ((EventOutput)this.getOutput()).setRenderParameter(s, s1);
    }

    public final void setRenderParameter(String s, String[] strings) {
        if (s == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        if (strings == null) {
            throw new IllegalArgumentException("the value given is null");
        }
        if (this.isSendRedirectAlreadyOccured()) {
            throw new IllegalStateException("sendRedirect was already called");
        }
        this.setRedirectionPossible(false);
        ((EventOutput)this.getOutput()).setRenderParameters(s, strings);
    }

    public final PortletMode getPortletMode() {
        return this.getInput().getPortletMode();
    }

    public final Map getRenderParameterMap() {
        return null;
    }

    public final WindowState getWindowState() {
        return this.getInput().getWindowState();
    }

    protected boolean validateByJAXB8_5_2List(Object payload) {
        return Arrays.asList(this.jaxb8_5_2List).contains(payload.getClass().getName());
    }

    protected boolean validateWithJAXB(QName name, Serializable payload) {
        if (payload == null) {
            return true;
        }
        if (this.validateByJAXB8_5_2List(payload)) {
            return true;
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{payload.getClass()});
            jaxbContext.createMarshaller().marshal((Object)payload, (OutputStream)new NullOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.info((Object)e.getMessage());
            return false;
        }
        List eds = this.getPortletDatas().getApplication().getEventDefinition();
        return PortletContainerDispatcher.isEventPayloadTypeMatches(eds, payload, name);
    }

    public final void setEvent(QName name, Serializable value) {
        if (name == null || !this.validateWithJAXB(name, value)) {
            throw new IllegalArgumentException("setEvent(): can't get binding of " + value == null ? null : value.getClass().getName());
        }
        ((EventOutput)this.getOutput()).setEvent(name, value);
    }

    public final void setEvent(String name, Serializable value) {
        if (name == null) {
            throw new IllegalArgumentException("setEvent(): can't get binding of " + value == null ? null : value.getClass().getName());
        }
        QName qName = new QName(this.getPortletDatas().getApplication().getDefaultNamespace(), name);
        this.setEvent(qName, value);
    }

    public final void removePublicRenderParameter(String param) {
        this.setRedirectionPossible(false);
        this.getOutput().removePublicRenderParameter(param);
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public final void write(int b) {
        }
    }
}

