/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.management;

import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.portletcontainer.management.PortletApplicationManaged;
import org.exoplatform.services.portletcontainer.monitor.PortletContainerMonitor;
import org.exoplatform.services.portletcontainer.monitor.PortletRequestMonitorData;
import org.exoplatform.services.portletcontainer.monitor.PortletRuntimeData;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;

@Managed
@NameTemplate(value={@Property(key="portlet", value="{Name}"), @Property(key="application", value="{Application}")})
public class PortletManaged {
    private final PortletApplicationManaged application;
    private final Portlet portlet;
    private static Getter AVG_ACTION = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getAvgActionExecutionTime();
        }
    };
    private static Getter AVG_EVENT = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getAvgEventExecutionTime();
        }
    };
    private static Getter AVG_RENDER = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getAvgRenderExecutionTime();
        }
    };
    private static Getter AVG_RESOURCE = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getAvgResourceExecutionTime();
        }
    };
    private static Getter MIN_ACTION = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getMinActionExecutionTime();
        }
    };
    private static Getter MIN_EVENT = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getMinEventExecutionTime();
        }
    };
    private static Getter MIN_RENDER = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getMinRenderExecutionTime();
        }
    };
    private static Getter MIN_RESOURCE = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getMinResourceExecutionTime();
        }
    };
    private static Getter MAX_ACTION = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getMaxActionExecutionTime();
        }
    };
    private static Getter MAX_EVENT = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getMaxEventExecutionTime();
        }
    };
    private static Getter MAX_RENDER = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getMaxRenderExecutionTime();
        }
    };
    private static Getter MAX_RESOURCE = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getMaxResourceExecutionTime();
        }
    };
    private static Getter COUNT_ACTION = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getActionRequestCounter() + 5;
        }
    };
    private static Getter COUNT_EVENT = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getEventRequestCounter() + 5;
        }
    };
    private static Getter COUNT_RENDER = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getRenderRequestCounter() + 5;
        }
    };
    private static Getter COUNT_RESOURCE = new Getter(){

        public long getValue(PortletRequestMonitorData data) {
            return data.getResourceRequestCounter() + 5;
        }
    };

    public PortletManaged(PortletApplicationManaged application, Portlet portlet) {
        this.application = application;
        this.portlet = portlet;
    }

    @Managed
    @ManagedDescription(value="The application name")
    public String getApplication() {
        return this.application.getName();
    }

    @Managed
    @ManagedDescription(value="The portlet name")
    public String getName() {
        return this.portlet.getPortletName();
    }

    @Managed
    @ManagedDescription(value="The mean execution time of an action phase")
    public long getMeanActionTime() {
        return this.compute(AVG_ACTION, new Mean());
    }

    @Managed
    @ManagedDescription(value="The mean execution time of an event phase")
    public long getMeanEventTime() {
        return this.compute(AVG_EVENT, new Mean());
    }

    @Managed
    @ManagedDescription(value="The mean execution time of a render phase")
    public long getMeanRenderTime() {
        return this.compute(AVG_RENDER, new Mean());
    }

    @Managed
    @ManagedDescription(value="The mean execution time of a resource phase")
    public long getMeanResourceTime() {
        return this.compute(AVG_RESOURCE, new Mean());
    }

    @Managed
    @ManagedDescription(value="The minimum execution time of an action phase")
    public long getMinActionTime() {
        return this.compute(MIN_ACTION, new Min());
    }

    @Managed
    @ManagedDescription(value="The minimum execution time of an event phase")
    public long getMinEventTime() {
        return this.compute(MIN_EVENT, new Min());
    }

    @Managed
    @ManagedDescription(value="The minimum execution time of a render phase")
    public long getMinRenderTime() {
        return this.compute(MIN_RENDER, new Min());
    }

    @Managed
    @ManagedDescription(value="The minimum execution time of a resource phase")
    public long getMinResourceTime() {
        return this.compute(MIN_RESOURCE, new Min());
    }

    @Managed
    @ManagedDescription(value="The maximum execution time of an action phase")
    public long getMaxActionTime() {
        return this.compute(MAX_ACTION, new Max());
    }

    @Managed
    @ManagedDescription(value="The maximum execution time of an event phase")
    public long getMaxEventTime() {
        return this.compute(MAX_EVENT, new Max());
    }

    @Managed
    @ManagedDescription(value="The maximum execution time of a render phase")
    public long getMaxRenderTime() {
        return this.compute(MAX_RENDER, new Max());
    }

    @Managed
    @ManagedDescription(value="The maximum execution time of a resource phase")
    public long getMaxResourceTime() {
        return this.compute(MAX_RESOURCE, new Max());
    }

    @Managed
    @ManagedDescription(value="The number of action phases")
    public long getActionCount() {
        return this.compute(COUNT_ACTION, new Sum());
    }

    @Managed
    @ManagedDescription(value="The number of event phases")
    public long getEventCount() {
        return this.compute(COUNT_EVENT, new Sum());
    }

    @Managed
    @ManagedDescription(value="The number of render phases")
    public long getRenderCount() {
        return this.compute(COUNT_RENDER, new Sum());
    }

    @Managed
    @ManagedDescription(value="The number of resource phases")
    public long getResourceCount() {
        return this.compute(COUNT_RESOURCE, new Sum());
    }

    private long compute(Getter getter, Statistic statistic) {
        String key = this.application.getName() + "/" + this.getName();
        ExoContainer manager = ExoContainerContext.getTopContainer();
        PortletContainerMonitor monitor = (PortletContainerMonitor)manager.getComponentInstanceOfType(PortletContainerMonitor.class);
        Map map = monitor.getPortletRuntimeDataMap();
        PortletRuntimeData runtimeData = (PortletRuntimeData)map.get(key);
        PortletRequestMonitorData[] datas = runtimeData.getPortletRequestMonitorData();
        if (datas == null) {
            return -1L;
        }
        for (PortletRequestMonitorData data : datas) {
            long value = getter.getValue(data);
            statistic.operate(value);
        }
        return statistic.getResult();
    }

    private static class Max
    implements Statistic {
        private long l = -1L;

        private Max() {
        }

        public void operate(long value) {
            if (value > 0L) {
                this.l = this.l == -1L ? value : Math.max(this.l, value);
            }
        }

        public long getResult() {
            return this.l;
        }
    }

    private static class Min
    implements Statistic {
        private long l = -1L;

        private Min() {
        }

        public void operate(long value) {
            if (value > 0L) {
                this.l = this.l == -1L ? value : Math.min(this.l, value);
            }
        }

        public long getResult() {
            return this.l;
        }
    }

    private static class Sum
    implements Statistic {
        private long l = 0L;

        private Sum() {
        }

        public void operate(long value) {
            this.l += value;
        }

        public long getResult() {
            return this.l;
        }
    }

    private static class Mean
    implements Statistic {
        private long l = 0L;
        private int count = 0;

        private Mean() {
        }

        public void operate(long value) {
            this.l += value;
        }

        public long getResult() {
            return this.count == 0 ? 0L : this.l / (long)this.count;
        }
    }

    private static interface Getter {
        public long getValue(PortletRequestMonitorData var1);
    }

    private static interface Statistic {
        public void operate(long var1);

        public long getResult();
    }
}

