/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.MimeResponseImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ResponseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderResponseImp
extends MimeResponseImp
implements RenderResponse {
    private final Collection<String> supportedContents;

    public RenderResponseImp(ResponseContext resCtx) {
        super(resCtx);
        this.supportedContents = resCtx.getSupportedContents();
    }

    public final void setTitle(String s) {
        ((RenderOutput)this.getOutput()).setTitle(s);
    }

    public final void setNextPossiblePortletModes(Collection<PortletMode> portletModes) {
        ((RenderOutput)this.getOutput()).setNextPossiblePortletModes(portletModes);
    }

    @Override
    public void setContentType(String contentType) {
        if (contentType != null) {
            contentType = StringUtils.split((String)contentType, (char)';')[0];
        }
        if (!this.isContentTypeSupported(contentType)) {
            throw new IllegalArgumentException("the content type : " + contentType + " is not supported.");
        }
        super.setContentType(contentType);
    }

    private boolean isContentTypeSupported(String contentTypeToTest) {
        Collection<String> c = this.getResponseContentTypes();
        for (String element : c) {
            if (!element.equals(contentTypeToTest)) continue;
            return true;
        }
        return false;
    }

    private Collection<String> getResponseContentTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getResponseContentType());
        for (String element : this.supportedContents) {
            List l = this.getPortletDatas().getSupports();
            block1: for (int i = 0; i < l.size(); ++i) {
                Supports supportsType = (Supports)l.get(i);
                String mimeType = supportsType.getMimeType();
                if (!element.equals(mimeType) || element.equals(this.getInput().getMarkup())) continue;
                List portletModes = supportsType.getPortletMode();
                for (String portletMode : portletModes) {
                    if (!portletMode.equals(this.getInput().getPortletMode().toString())) continue;
                    result.add(mimeType);
                    continue block1;
                }
            }
        }
        return result;
    }

    private String getResponseContentType() {
        List l = this.getPortletDatas().getSupports();
        for (int i = 0; i < l.size(); ++i) {
            Supports supportsType = (Supports)l.get(i);
            String mimeType = supportsType.getMimeType();
            if (!mimeType.equals(this.getInput().getMarkup())) continue;
            List portletModes = supportsType.getPortletMode();
            for (String portletMode : portletModes) {
                if (!portletMode.equals(this.getInput().getPortletMode().toString())) continue;
                return mimeType;
            }
        }
        return "text/html";
    }
}

