/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc;

import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.database.DBObjectPageList;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.database.ObjectQuery;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.resources.ExoResourceBundle;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Query;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.ResourceBundleDescription;
import org.exoplatform.services.resources.impl.BaseResourceBundleService;
import org.hibernate.Session;

public class ResourceBundleServiceImpl
extends BaseResourceBundleService {
    private final HibernateService hService;

    public ResourceBundleServiceImpl(HibernateService service, LocaleConfigService localeService, CacheService cService, InitParams params) throws Exception {
        this.log_ = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
        this.cache_ = cService.getCacheInstance(((Object)((Object)this)).getClass().getName());
        this.localeService_ = localeService;
        this.hService = service;
        this.initParams(params);
    }

    public final ResourceBundleData getResourceBundleData(String name) throws Exception {
        return (ResourceBundleData)this.hService.findOne(ResourceBundleData.class, (Serializable)((Object)name));
    }

    public final ResourceBundleData removeResourceBundleData(String id) throws Exception {
        ResourceBundleData data = (ResourceBundleData)this.hService.remove(ResourceBundleData.class, (Serializable)((Object)id));
        this.cache_.remove((Serializable)((Object)data.getId()));
        return data;
    }

    public final PageList findResourceDescriptions(Query q) throws Exception {
        String name = q.getName();
        if (name == null || name.length() == 0) {
            name = "%";
        }
        ObjectQuery oq = new ObjectQuery(ResourceBundleDescription.class);
        oq.addLIKE("name", name);
        oq.addLIKE("language", q.getLanguage());
        oq.setDescOrderBy("name");
        return new DBObjectPageList(this.hService, oq);
    }

    public final void saveResourceBundle(ResourceBundleData data) throws Exception {
        this.hService.save((Object)data);
        this.cache_.remove((Serializable)((Object)data.getId()));
    }

    protected final ResourceBundle getResourceBundleFromDb(String id, ResourceBundle parent, Locale locale) throws Exception {
        Session session = this.hService.openSession();
        ResourceBundleData data = (ResourceBundleData)session.get(ResourceBundleData.class, (Serializable)((Object)id));
        if (data != null) {
            ExoResourceBundle res = new ExoResourceBundle(data.getData(), parent);
            MapResourceBundle mres = new MapResourceBundle((ResourceBundle)res, locale);
            return mres;
        }
        return null;
    }
}

