/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.xml.namespace.QName;
import org.exoplatform.services.portletcontainer.pci.model.CustomPortletMode;
import org.exoplatform.services.portletcontainer.pci.model.CustomWindowState;
import org.exoplatform.services.portletcontainer.pci.model.InitParam;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.SecurityConstraint;
import org.exoplatform.services.portletcontainer.pci.model.UserAttribute;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletContextImpl;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.bundle.ResourceBundleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletConfigImp
implements PortletConfig {
    private final Portlet hPortletDatas;
    private final Map<String, InitParam> params = new HashMap<String, InitParam>();
    private final PortletContextImpl portletContext;
    private final List<SecurityConstraint> securityContraints;
    private final List<UserAttribute> userAttributes;
    private final List<CustomPortletMode> customPortletModes;
    private final List<CustomWindowState> customWindowStates;
    private final String defaultNamespace;

    public PortletConfigImp(Portlet portletDatas, PortletContext portletContext, List<SecurityConstraint> securityContraints, List<UserAttribute> userAttributes, List<CustomPortletMode> customPortletModes, List<CustomWindowState> customWindowStates, String defaultNamespace) {
        this.hPortletDatas = portletDatas;
        this.defaultNamespace = defaultNamespace;
        this.portletContext = (PortletContextImpl)portletContext;
        this.securityContraints = securityContraints;
        this.userAttributes = userAttributes;
        this.customPortletModes = customPortletModes;
        this.customWindowStates = customWindowStates;
        List l = this.hPortletDatas.getInitParam();
        for (InitParam initParam : l) {
            this.params.put(initParam.getName(), initParam);
        }
    }

    public final String getPortletName() {
        return this.hPortletDatas.getPortletName();
    }

    public final PortletContext getPortletContext() {
        return this.portletContext;
    }

    public final ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundleManager manager = (ResourceBundleManager)this.portletContext.getContainer().getComponentInstanceOfType(ResourceBundleManager.class);
        return manager.lookupBundle(this.hPortletDatas, locale);
    }

    public final String getInitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("You cannot have null as a paramter");
        }
        InitParam initParam = this.params.get(name);
        if (initParam != null) {
            return initParam.getValue();
        }
        return null;
    }

    public final Enumeration getInitParameterNames() {
        return new Vector<String>(this.params.keySet()).elements();
    }

    public final Portlet getPortletDatas() {
        return this.hPortletDatas;
    }

    public final boolean needsSecurityContraints(String portletName) {
        for (SecurityConstraint securityConstraint : this.securityContraints) {
            List l = securityConstraint.getPortletCollection().getPortletName();
            for (String portlet : l) {
                if (!portlet.equals(portletName)) continue;
                return true;
            }
        }
        return false;
    }

    public final String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public final Enumeration getPublicRenderParameterNames() {
        return this.notNullEnumeration(this.hPortletDatas.getSupportedPublicRenderParameter());
    }

    public final Enumeration<QName> getPublishingEventQNames() {
        return this.notNullEnumeration(this.hPortletDatas.getSupportedPublishingEvent());
    }

    public final Enumeration<QName> getProcessingEventQNames() {
        return this.notNullEnumeration(this.hPortletDatas.getSupportedProcessingEvent());
    }

    public final Enumeration<Locale> getSupportedLocales() {
        return this.notNullEnumeration(this.hPortletDatas.getSupportedLocale());
    }

    protected final Enumeration notNullEnumeration(List list) {
        if (list == null) {
            list = new ArrayList();
        }
        return Collections.enumeration(list);
    }

    public final Map<String, String[]> getContainerRuntimeOptions() {
        Map a = this.hPortletDatas.getContainerRuntimeOption();
        Map b = this.hPortletDatas.getApplication().getContainerRuntimeOption();
        b.putAll(a);
        return b;
    }
}

