/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PreferencesValidator;
import javax.portlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationsHolder;
import org.exoplatform.services.portletcontainer.plugins.pc.monitor.PortletContainerMonitorImpl;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletConfigImp;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.Startable;
import org.picocontainer.defaults.DefaultPicoContainer;

public class PortletApplicationProxy
implements Startable {
    private static final int WAITING_TIME_BEFORE_DESTROY = 50;
    PortletApplicationsHolder holder;
    private String portletAppName;
    private final Map<String, PortletConfig> configs;
    private final PortletContainerMonitorImpl monitor;
    private final Log log;
    private final MutablePicoContainer pico;

    public PortletApplicationProxy(ExoContainerContext context, PortletApplicationsHolder holder, PortletContainerMonitorImpl monitor) {
        this.holder = holder;
        this.monitor = monitor;
        this.configs = new HashMap<String, PortletConfig>();
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
        this.pico = new DefaultPicoContainer((PicoContainer)context.getContainer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final javax.portlet.Portlet getPortlet(PortletContext portletContext, String portletName) throws PortletException {
        this.log.debug((Object)"getPortlet() in PortletApplicationProxy entered");
        PortletContainerMonitorImpl portletContainerMonitorImpl = this.monitor;
        synchronized (portletContainerMonitorImpl) {
            if (!this.monitor.isInitialized(this.portletAppName, portletName)) {
                this.log.debug((Object)"init monitor");
                this.init(this.monitor, portletName, portletContext);
            }
        }
        return (javax.portlet.Portlet)this.pico.getComponentInstance((Object)(this.portletAppName + "_portlet_" + portletName));
    }

    private void init(PortletContainerMonitorImpl monitor1, String portletName, PortletContext portletContext) throws PortletException {
        long accessTime = System.currentTimeMillis();
        if (!monitor1.isInitialisationAllowed(this.portletAppName, portletName, accessTime)) {
            throw new UnavailableException("Portlet initialization not possible");
        }
        Portlet portletDatas = this.holder.getPortletMetaData(this.portletAppName, portletName);
        PortletApp portletApp = this.holder.getPortletApplication(this.portletAppName);
        PortletConfigImp config = new PortletConfigImp(portletDatas, portletContext, portletApp.getSecurityConstraint(), portletApp.getUserAttribute(), portletApp.getCustomPortletMode(), portletApp.getCustomWindowState(), portletApp.getDefaultNamespace());
        try {
            if (this.pico.getComponentInstance((Object)(this.portletAppName + "_portlet_" + portletDatas.getPortletName())) == null) {
                this.log.debug((Object)("First registration of portlet : " + this.portletAppName + "/" + portletName));
                this.registerPortlet(portletDatas.getPortletName());
            }
            ((javax.portlet.Portlet)this.pico.getComponentInstance((Object)(this.portletAppName + "_portlet_" + portletDatas.getPortletName()))).init((PortletConfig)config);
            this.configs.put(portletDatas.getPortletName(), config);
            Integer expirationStr = portletDatas.getCaching();
            int expiration = 0;
            if (expirationStr != null) {
                expiration = expirationStr;
            }
            monitor1.init(this.portletAppName, portletName, expiration);
            monitor1.setInitializationTime(this.portletAppName, portletName, accessTime);
        }
        catch (Throwable t) {
            this.log.error((Object)("exception while initializing portlet : " + portletName), t);
            monitor1.setLastInitFailureAccessTime(this.portletAppName, portletName, accessTime);
            this.releasePortlet(portletName);
            if (t instanceof UnavailableException) {
                UnavailableException e = (UnavailableException)t;
                if (!e.isPermanent()) {
                    monitor1.setUnavailabilityPeriod(this.portletAppName, portletName, e.getUnavailableSeconds());
                }
                throw e;
            }
            throw new PortletException("exception while initializing portlet", t);
        }
    }

    public final PortletConfig getPortletConfig(String portletName) {
        return this.configs.get(portletName);
    }

    private void registerPortlet(String key) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            this.pico.registerComponentImplementation((Object)(this.portletAppName + "_portlet_" + key), cl.loadClass(this.getPortletClassName(key)));
        }
        catch (Exception e) {
            this.log.error((Object)("Can not register portlet : " + key), (Throwable)e);
        }
    }

    private String getPortletClassName(String portletName) {
        PortletApp portletApp = this.holder.getPortletApplication(this.portletAppName);
        List portletMetaDataList = portletApp.getPortlet();
        for (Portlet portlet : portletMetaDataList) {
            if (!portlet.getPortletName().equals(portletName)) continue;
            return portlet.getPortletClass();
        }
        return null;
    }

    private void releasePortlet(String portletName) {
        try {
            this.pico.unregisterComponent((Object)(this.portletAppName + "_portlet_" + portletName));
        }
        catch (Exception e) {
            this.log.error((Object)("Can not release portlet : " + portletName), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void destroy(String portletName) {
        try {
            try {
                boolean everLoaded = false;
                PortletContainerMonitorImpl portletContainerMonitorImpl = this.monitor;
                // MONITORENTER : portletContainerMonitorImpl
                everLoaded = this.monitor.isInitialized(this.portletAppName, portletName);
                this.log.debug((Object)("Was the portlet : " + this.portletAppName + "/" + portletName + " ever loaded : " + everLoaded));
                this.monitor.destroy(this.portletAppName, portletName);
                // MONITOREXIT : portletContainerMonitorImpl
                if (!everLoaded) {
                    Object var6_5 = null;
                    this.releasePortlet(portletName);
                    return;
                }
                if (this.pico.getComponentInstance((Object)(this.portletAppName + "_portlet_" + portletName)) == null) {
                    this.log.debug((Object)"The portlet is already destroyed or in broken state");
                    Object var6_6 = null;
                    this.releasePortlet(portletName);
                    return;
                }
                this.log.debug((Object)"Wait 50 seconds before destroying the portlet");
                Thread.sleep(50L);
                ((javax.portlet.Portlet)this.pico.getComponentInstance((Object)(this.portletAppName + "_portlet_" + portletName))).destroy();
            }
            catch (Throwable t) {
                this.log.error((Object)"If the portlet object throws a RuntimeException within the execution of the destroy method the portlet container must consider the portlet object successfully destroyed.", t);
                Object var6_8 = null;
                this.releasePortlet(portletName);
                return;
            }
            Object var6_7 = null;
            this.releasePortlet(portletName);
            return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.releasePortlet(portletName);
            throw throwable;
        }
    }

    public final void loadAndRegisterPortletClasses() {
        String[] portletNames = this.getPortletNames();
        this.initMonitor(portletNames);
        this.loadAndRegisterClassesByKey(portletNames);
    }

    private String[] getPortletNames() {
        PortletApp portletApp = this.holder.getPortletApplication(this.portletAppName);
        List portletMetaDataList = portletApp.getPortlet();
        String[] portletNames = new String[portletMetaDataList.size()];
        int i = 0;
        for (Portlet portlet : portletMetaDataList) {
            portletNames[i] = portlet.getPortletName();
            ++i;
        }
        return portletNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMonitor(String[] portletNames) {
        PortletContainerMonitorImpl portletContainerMonitorImpl = this.monitor;
        synchronized (portletContainerMonitorImpl) {
            this.monitor.registerPortletApp(this.portletAppName);
        }
        for (String portletName : portletNames) {
            this.registerPortletToMonitor(portletName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerPortletToMonitor(String portletName) {
        PortletContainerMonitorImpl portletContainerMonitorImpl = this.monitor;
        synchronized (portletContainerMonitorImpl) {
            this.monitor.register(this.portletAppName, portletName);
        }
    }

    private void loadAndRegisterClassesByKey(String[] keys) {
        for (String key : keys) {
            this.registerPortlet(key);
        }
    }

    public final PreferencesValidator getValidator(String validatorClass, String portletName) {
        return (PreferencesValidator)this.pico.getComponentInstance((Object)(this.portletAppName + "_" + portletName + "_validator_" + validatorClass));
    }

    public final void loadAndRegisterValidatorClasses() {
        String[] classNames = this.getValidatorClassNames();
        String[] portletNames = this.getValidatorsPortletsNames();
        if (classNames == null || portletNames == null) {
            return;
        }
        this.loadAndRegisterClasses(classNames, portletNames);
    }

    public final String[] getValidatorClassNames() {
        PortletApp portletApp = this.holder.getPortletApplication(this.portletAppName);
        List portletMetaDataList = portletApp.getPortlet();
        if (portletMetaDataList.size() == 0) {
            return null;
        }
        String[] validatorNames = new String[portletMetaDataList.size()];
        int i = 0;
        for (Portlet portlet : portletMetaDataList) {
            ExoPortletPreferences preferences = portlet.getPortletPreferences();
            if (preferences != null) {
                validatorNames[i] = preferences.getPreferencesValidator();
            }
            ++i;
        }
        return validatorNames;
    }

    public final String[] getValidatorsPortletsNames() {
        PortletApp portletApp = this.holder.getPortletApplication(this.portletAppName);
        List portletMetaDataList = portletApp.getPortlet();
        if (portletMetaDataList.size() == 0) {
            return null;
        }
        String[] validatorNames = new String[portletMetaDataList.size()];
        int i = 0;
        for (Portlet portlet : portletMetaDataList) {
            ExoPortletPreferences preferences = portlet.getPortletPreferences();
            if (preferences != null) {
                validatorNames[i] = portlet.getPortletName();
            }
            ++i;
        }
        return validatorNames;
    }

    private void loadAndRegisterClasses(String[] classNames, String[] portletNames) {
        for (int i = 0; i < classNames.length; ++i) {
            String className = classNames[i];
            String portletName = portletNames[i];
            if (className == null) continue;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                this.pico.registerComponentImplementation((Object)(this.portletAppName + "_" + portletName + "_validator_" + className), cl.loadClass(className));
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("Can not load and register class : " + className), (Throwable)e);
            }
        }
    }

    public final void load() {
        this.loadAndRegisterPortletClasses();
        this.loadAndRegisterValidatorClasses();
    }

    public final void setApplicationName(String servletContextName) {
        this.portletAppName = servletContextName;
    }

    public final void start() {
    }

    public final void stop() {
    }
}

