/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.pci.model.SecurityConstraint;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.pci.model.UserDataConstraint;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletDataImp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletApplicationsHolder {
    protected ExoContainer container;
    private final Map<String, PortletApplicationHelper> portletApps;
    private final Log log;

    public PortletApplicationsHolder(ExoContainerContext context) {
        this.container = context.getContainer();
        this.portletApps = new HashMap<String, PortletApplicationHelper>();
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
    }

    public void start() {
    }

    public void stop() {
    }

    public final PortletApp getPortletApplication(String portletAppName) {
        PortletApplicationHelper helper = this.portletApps.get(portletAppName);
        if (helper == null) {
            this.log.debug((Object)("Portlet application : " + portletAppName + " does not exist"));
            return null;
        }
        return helper.getPortletApp();
    }

    public final List<PortletApp> getPortletAppList() {
        ArrayList<PortletApp> result = new ArrayList<PortletApp>();
        for (String string : this.portletApps.keySet()) {
            PortletApplicationHelper helper = this.portletApps.get(string);
            if (helper == null) continue;
            result.add(helper.getPortletApp());
        }
        return result;
    }

    public final Collection<String> getRoles(String portletAppName) {
        this.log.debug((Object)"getRoles() entered");
        PortletApplicationHelper helper = this.portletApps.get(portletAppName);
        return helper.getRoles();
    }

    public final Collection<String> getPortletAppNames() {
        return Collections.unmodifiableSet(this.portletApps.keySet());
    }

    public final Map<String, PortletData> getAllPortletMetaData() {
        this.log.debug((Object)"getAllPortletMetaData() entered");
        HashMap<String, PortletData> all = new HashMap<String, PortletData>();
        Set<String> applicationsKeys = this.portletApps.keySet();
        for (String key : applicationsKeys) {
            PortletApplicationHelper helper = this.portletApps.get(key);
            PortletApp portletApp = helper.getPortletApp();
            List securityContraints = portletApp.getSecurityConstraint();
            List portlets = portletApp.getPortlet();
            UserDataConstraint userDataConstraintType = null;
            for (int i = 0; i < portlets.size(); ++i) {
                Portlet portlet = (Portlet)portlets.get(i);
                block2: for (SecurityConstraint securityConstraint : securityContraints) {
                    List portletNames = securityConstraint.getPortletCollection().getPortletName();
                    for (String portletName : portletNames) {
                        if (!portletName.equals(portlet.getPortletName())) continue;
                        userDataConstraintType = securityConstraint.getUserDataConstraint();
                        continue block2;
                    }
                }
                all.put(key + "/" + portlet.getPortletName(), new PortletDataImp(this.container, portlet, userDataConstraintType, portletApp.getUserAttribute(), true));
            }
        }
        return all;
    }

    public final Collection<PortletMode> getPortletModes(String portletAppName, String portletName, String markup) {
        this.log.debug((Object)"getPortletModes() entered");
        ArrayList<PortletMode> modes = new ArrayList<PortletMode>();
        List portlets = this.getPortletApplication(portletAppName).getPortlet();
        for (Portlet portlet : portlets) {
            if (!portlet.getPortletName().equals(portletName)) continue;
            List l = portlet.getSupports();
            for (Supports supports : l) {
                String mimeType = supports.getMimeType();
                if (!mimeType.equals(markup)) continue;
                List modesR = supports.getPortletMode();
                for (String s : modesR) {
                    modes.add(new PortletMode(s));
                }
            }
            return modes;
        }
        return modes;
    }

    public final boolean isModeSuported(String portletAppName, String portletName, String markup, PortletMode mode) {
        this.log.debug((Object)"isModeSuported() entered");
        if (PortletMode.VIEW.toString().equalsIgnoreCase(mode.toString())) {
            return true;
        }
        Collection<PortletMode> modesSupported = this.getPortletModes(portletAppName, portletName, markup);
        for (PortletMode portletMode : modesSupported) {
            if (!portletMode.toString().equalsIgnoreCase(mode.toString())) continue;
            return true;
        }
        return false;
    }

    public final Collection<WindowState> getWindowStates(String portletAppName, String portletName, String markup) {
        this.log.debug((Object)"getWindowStates() entered");
        ArrayList<WindowState> states = new ArrayList<WindowState>();
        List portlets = this.getPortletApplication(portletAppName).getPortlet();
        for (Portlet portlet : portlets) {
            if (!portlet.getPortletName().equals(portletName)) continue;
            List l = portlet.getSupports();
            for (Supports supports : l) {
                String mimeType = supports.getMimeType();
                if (!mimeType.equals(markup)) continue;
                List statesR = supports.getWindowState();
                for (String s : statesR) {
                    states.add(new WindowState(s));
                }
            }
            return states;
        }
        return states;
    }

    public final boolean isStateSupported(String portletAppName, String portletName, String markup, WindowState state) {
        this.log.debug((Object)"isStateSupported() entered");
        if (WindowState.MINIMIZED.toString().equalsIgnoreCase(state.toString())) {
            return true;
        }
        if (WindowState.NORMAL.toString().equalsIgnoreCase(state.toString())) {
            return true;
        }
        if (WindowState.MAXIMIZED.toString().equalsIgnoreCase(state.toString())) {
            return true;
        }
        Collection<WindowState> statesSupported = this.getWindowStates(portletAppName, portletName, markup);
        for (WindowState windowState : statesSupported) {
            if (!windowState.toString().equalsIgnoreCase(state.toString())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerPortletApplication(String portletAppName, PortletApp portletApp, Collection<String> roles) {
        PortletApplicationHelper helper = new PortletApplicationHelper(portletAppName, portletApp, roles);
        Map<String, PortletApplicationHelper> map = this.portletApps;
        synchronized (map) {
            this.portletApps.put(portletAppName, helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePortletApplication(String portletAppName) {
        Map<String, PortletApplicationHelper> map = this.portletApps;
        synchronized (map) {
            this.portletApps.remove(portletAppName);
        }
    }

    public final Portlet getPortletMetaData(String portletApplication, String portlet) {
        this.log.debug((Object)"getPortletMetaData() entered");
        PortletApp portletApp = this.getPortletApplication(portletApplication);
        if (portletApp == null) {
            return null;
        }
        List l = portletApp.getPortlet();
        for (Portlet portlet1 : l) {
            if (!portlet1.getPortletName().equals(portlet)) continue;
            return portlet1;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PortletApplicationHelper {
        private final PortletApp portletApp;
        private final Collection<String> roles;
        private final String portletAppName;

        public PortletApplicationHelper(String portletAppName, PortletApp portletApp, Collection<String> roles) {
            this.portletAppName = portletAppName;
            this.portletApp = portletApp;
            this.roles = roles;
        }

        public PortletApp getPortletApp() {
            return this.portletApp;
        }

        public Collection<String> getRoles() {
            return this.roles;
        }

        public String getPortletAppName() {
            return this.portletAppName;
        }
    }
}

