/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.io.Serializable;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import org.exoplatform.services.portletcontainer.helper.EventUtil;
import org.exoplatform.services.portletcontainer.pci.EventImpl;
import org.exoplatform.services.portletcontainer.pci.EventInput;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletRequestImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.RequestContext;

public class EventRequestImp
extends PortletRequestImp
implements EventRequest {
    public EventRequestImp(RequestContext reqCtx) {
        super(reqCtx);
    }

    public Event getEvent() {
        Event event = ((EventInput)this.getInput()).getEvent();
        Serializable payload = event.getValue();
        if (payload == null || this.isCurrentClassLoader(payload)) {
            return event;
        }
        Serializable newPayload = this.getSerializeDeserialize(payload);
        EventImpl newEvent = new EventImpl(event.getQName(), newPayload);
        return newEvent;
    }

    public String getLifecyclePhase() {
        return "EVENT_PHASE";
    }

    private boolean isCurrentClassLoader(Serializable payload) {
        boolean doNotSerialize = true;
        String fqn = payload.getClass().getCanonicalName();
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(fqn);
            doNotSerialize = clazz.isInstance(payload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doNotSerialize;
    }

    private Serializable getSerializeDeserialize(Serializable payload) {
        Serializable newPayload = null;
        try {
            byte[] bytes = EventUtil.serialize((Object[])new Object[]{payload});
            newPayload = (Serializable)EventUtil.deserializeInContextClassloader((byte[])bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newPayload;
    }
}

