/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.aop;

import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.exoplatform.services.portletcontainer.PortletContainerConf;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.plugins.pc.aop.ActionExecutionContext;
import org.exoplatform.services.portletcontainer.plugins.pc.aop.BaseCommandUnit;
import org.exoplatform.services.portletcontainer.plugins.pc.aop.EventExecutionContext;
import org.exoplatform.services.portletcontainer.plugins.pc.aop.RenderExecutionContext;
import org.exoplatform.services.portletcontainer.plugins.pc.aop.ResourceExecutionContext;
import org.exoplatform.services.portletcontainer.plugins.pc.monitor.PortletContainerMonitorImpl;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ActionRequestImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.EventRequestImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortalContextImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletRequestImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletResponseImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.RenderRequestImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.RenderResponseImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ResourceRequestImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ResourceResponseImp;

public class PortletCacheCommand
extends BaseCommandUnit {
    private static final int MILLISECONDS = 1000;
    private final PortletContainerConf conf;
    private final PortletContainerMonitorImpl portletMonitor;

    public PortletCacheCommand(PortletContainerConf conf, PortletContainerMonitorImpl monitor) {
        this.conf = conf;
        this.portletMonitor = monitor;
    }

    protected final Object render(RenderExecutionContext rcontext) throws Throwable {
        if (!this.conf.isCacheEnable()) {
            return rcontext.executeNextUnit();
        }
        this.log.debug((Object)"--> render method, call cache interceptor");
        RenderRequestImp req = (RenderRequestImp)rcontext.getRequest();
        RenderResponseImp res = (RenderResponseImp)rcontext.getResponse();
        if (req.getPortletDatas().getCaching() == null) {
            return rcontext.executeNextUnit();
        }
        String portletAppName = req.getPortletWindowInternal().getWindowID().getPortletApplicationName();
        String portletName = req.getPortletWindowInternal().getWindowID().getPortletName();
        PortletMode mode = req.getPortletMode();
        WindowState window = req.getWindowState();
        boolean isCacheGlobal = this.resolveCache(req.getPortletDatas().getGlobalCache(), this.portletMonitor.getCacheScope(portletAppName, portletName));
        this.log.debug((Object)("Is cache global: " + isCacheGlobal));
        String key = this.generateKey(req, isCacheGlobal, "");
        if (key != null && this.portletMonitor.needsCacheInvalidation(portletAppName, portletName, key, mode, window, isCacheGlobal)) {
            this.portletMonitor.removeCachedData(portletAppName, portletName, key, isCacheGlobal);
        }
        int expirationPeriod = this.portletMonitor.getCacheExpirationPeriod(portletAppName, portletName);
        long lastUpdateTime = 0L;
        if (key != null) {
            lastUpdateTime = this.portletMonitor.getPortletLastCacheUpdateTime(portletAppName, portletName, key, isCacheGlobal);
        }
        long currentAccessTime = System.currentTimeMillis();
        if (expirationPeriod == 0) {
            this.log.debug((Object)"Expiration period 0 before proceed");
            rcontext.executeNextUnit();
            this.log.debug((Object)"Expiration period 0 after proceed");
        } else if (expirationPeriod == -1) {
            if (key != null && this.portletMonitor.isDataCached(portletAppName, portletName, key, isCacheGlobal)) {
                this.log.debug((Object)"Use cache : Expiration period -1 data already cached");
                this.useCache(portletAppName, portletName, key, res, isCacheGlobal);
            } else {
                this.log.debug((Object)"Expiration period -1 data first cached, before proceed");
                rcontext.executeNextUnit();
                key = this.generateKey(req, isCacheGlobal, "");
                this.log.debug((Object)"Expiration period -1 data first cached, after proceed");
                this.updateCache(portletAppName, portletName, key, res, mode, window, isCacheGlobal);
            }
        } else if (currentAccessTime - lastUpdateTime > (long)(expirationPeriod * 1000)) {
            this.log.debug((Object)"Expiration period currentAccessTime - lastCacheUpdateTime > expirationPeriod * 1000 before proceed");
            if (key != null && req.getPortletDatas().getApplication().getVer2()) {
                ((PortalContextImp)req.getPortalContext()).addProperty("portlet.ETag", this.portletMonitor.getCachedETag(portletAppName, portletName, key, isCacheGlobal));
            }
            rcontext.executeNextUnit();
            key = this.generateKey(req, isCacheGlobal, "");
            this.log.debug((Object)"Expiration period currentAccessTime - lastCacheUpdateTime > expirationPeriod * 1000 after proceed");
            if (res.getOutput().getProperties().get("portlet.use-cached-content") != null) {
                this.useCache(portletAppName, portletName, key, res, isCacheGlobal);
            } else {
                this.updateCache(portletAppName, portletName, key, res, mode, window, isCacheGlobal);
            }
            this.updateCacheParams(portletAppName, portletName, key, res, isCacheGlobal);
        } else if (0L < currentAccessTime - lastUpdateTime && currentAccessTime - lastUpdateTime < (long)(expirationPeriod * 1000)) {
            this.log.debug((Object)"Use cache : currentAccessTime - lastCacheUpdateTime < expirationPeriod * 1000");
            if (key != null) {
                this.useCache(portletAppName, portletName, key, res, isCacheGlobal);
            }
        }
        return null;
    }

    private String generateKey(PortletRequestImp req, boolean isCacheGlobal, String modifier) {
        if (modifier == null) {
            modifier = "";
        }
        String uniqueId = "";
        if (isCacheGlobal) {
            uniqueId = String.valueOf((req.getInput().getInternalWindowID().getPortletApplicationName() + req.getInput().getInternalWindowID().getPortletName()).hashCode());
            return req.getInput().getInternalWindowID().getOwner() + uniqueId + modifier;
        }
        if (req.getSession(false) == null) {
            return null;
        }
        uniqueId = req.getInput().getInternalWindowID().getUniqueID();
        return req.getSession().getId() + req.getRemoteUser() + req.getInput().getInternalWindowID().getOwner() + uniqueId + modifier;
    }

    protected final Object serveResource(ResourceExecutionContext rcontext) throws Throwable {
        this.log.debug((Object)"--> serveResource method, call cache interceptor");
        if (!this.conf.isCacheEnable()) {
            return rcontext.executeNextUnit();
        }
        this.log.debug((Object)"--> render method, call cache interceptor");
        ResourceRequestImp req = (ResourceRequestImp)rcontext.getRequest();
        ResourceResponseImp res = (ResourceResponseImp)rcontext.getResponse();
        if (req.getPortletDatas().getCaching() == null) {
            return rcontext.executeNextUnit();
        }
        String portletAppName = req.getPortletWindowInternal().getWindowID().getPortletApplicationName();
        String portletName = req.getPortletWindowInternal().getWindowID().getPortletName();
        String uniqueId = req.getPortletWindowInternal().getWindowID().getUniqueID();
        String resourceUID = null;
        if (req.getInput().getPropertyParams() != null && req.getInput().getPropertyParams().containsKey("javax.portlet.shared")) {
            resourceUID = (String)req.getInput().getPropertyParams().get("javax.portlet.shared");
        }
        boolean isCacheGlobal = this.resolveCache(req.getPortletDatas().getGlobalCache(), this.portletMonitor.getCacheScope(portletAppName, portletName));
        this.log.debug((Object)("Is cache global: " + isCacheGlobal));
        String key = null;
        int expirationPeriod = -1;
        if (resourceUID != null) {
            key = resourceUID;
        } else {
            key = isCacheGlobal ? req.getInput().getInternalWindowID().getOwner() + uniqueId : this.generateKey(req, isCacheGlobal, "r");
            expirationPeriod = this.portletMonitor.getCacheExpirationPeriod(portletAppName, portletName);
        }
        long lastUpdateTime = 0L;
        if (key != null) {
            lastUpdateTime = this.portletMonitor.getPortletLastCacheUpdateTime(portletAppName, portletName, key, isCacheGlobal);
        }
        long currentAccessTime = System.currentTimeMillis();
        if (expirationPeriod == 0) {
            this.log.debug((Object)"Expiration period 0 before proceed");
            rcontext.executeNextUnit();
            this.log.debug((Object)"Expiration period 0 after proceed");
        } else if (expirationPeriod == -1) {
            if (key != null && this.portletMonitor.isDataCached(portletAppName, portletName, key, isCacheGlobal)) {
                this.log.debug((Object)"Use cache : Expiration period -1 data already cached");
                this.useRCache(portletAppName, portletName, key, res, isCacheGlobal);
            } else {
                this.log.debug((Object)"Expiration period -1 data first cached, before proceed");
                rcontext.executeNextUnit();
                key = this.generateKey(req, isCacheGlobal, "r");
                this.log.debug((Object)"Expiration period -1 data first cached, after proceed");
                this.updateRCache(portletAppName, portletName, key, res, isCacheGlobal);
            }
        } else if (currentAccessTime - lastUpdateTime > (long)(expirationPeriod * 1000)) {
            this.log.debug((Object)"Expiration period currentAccessTime - lastCacheUpdateTime > expirationPeriod * 1000 before proceed");
            if (key != null && req.getPortletDatas().getApplication().getVer2()) {
                ((PortalContextImp)req.getPortalContext()).addProperty("portlet.ETag", this.portletMonitor.getCachedETag(portletAppName, portletName, key, isCacheGlobal));
            }
            rcontext.executeNextUnit();
            key = this.generateKey(req, isCacheGlobal, "r");
            this.log.debug((Object)"Expiration period currentAccessTime - lastCacheUpdateTime > expirationPeriod * 1000 after proceed");
            if (res.getOutput().getProperties().get("portlet.use-cached-content") != null) {
                this.useRCache(portletAppName, portletName, key, res, isCacheGlobal);
            } else {
                this.updateRCache(portletAppName, portletName, key, res, isCacheGlobal);
            }
            this.updateCacheParams(portletAppName, portletName, key, res, isCacheGlobal);
        } else if (0L < currentAccessTime - lastUpdateTime && currentAccessTime - lastUpdateTime < (long)(expirationPeriod * 1000)) {
            this.log.debug((Object)"Use cache : currentAccessTime - lastCacheUpdateTime < expirationPeriod * 1000");
            if (key != null) {
                this.useRCache(portletAppName, portletName, key, res, isCacheGlobal);
            }
        }
        return null;
    }

    protected final Object processAction(ActionExecutionContext acontext) throws Throwable {
        if (!this.conf.isCacheEnable()) {
            return acontext.executeNextUnit();
        }
        this.log.debug((Object)"--> processAction method, call cache interceptor");
        ActionRequestImp req = (ActionRequestImp)acontext.getRequest();
        if (req.getPortletDatas().getCaching() == null) {
            return acontext.executeNextUnit();
        }
        String portletAppName = req.getPortletWindowInternal().getWindowID().getPortletApplicationName();
        String portletName = req.getPortletWindowInternal().getWindowID().getPortletName();
        boolean isCacheGlobal = this.resolveCache(req.getPortletDatas().getGlobalCache(), this.portletMonitor.getCacheScope(portletAppName, portletName));
        this.log.debug((Object)("Is cache global: " + isCacheGlobal));
        String uniqueID = req.getPortletWindowInternal().getWindowID().getUniqueID();
        String key = this.generateKey(req, isCacheGlobal, "");
        if (key != null) {
            this.portletMonitor.removeCachedData(portletAppName, portletName, key, isCacheGlobal);
        }
        if ((key = this.generateKey(req, isCacheGlobal, "r")) != null) {
            this.portletMonitor.removeCachedData(portletAppName, portletName, key, isCacheGlobal);
        }
        return acontext.executeNextUnit();
    }

    protected final Object processEvent(EventExecutionContext econtext) throws Throwable {
        if (!this.conf.isCacheEnable()) {
            return econtext.executeNextUnit();
        }
        this.log.debug((Object)"--> processEvent method, call cache interceptor");
        EventRequestImp req = (EventRequestImp)econtext.getRequest();
        if (req.getPortletDatas().getCaching() == null) {
            return econtext.executeNextUnit();
        }
        String portletAppName = req.getPortletWindowInternal().getWindowID().getPortletApplicationName();
        String portletName = req.getPortletWindowInternal().getWindowID().getPortletName();
        boolean isCacheGlobal = this.resolveCache(req.getPortletDatas().getGlobalCache(), this.portletMonitor.getCacheScope(portletAppName, portletName));
        this.log.debug((Object)("Is cache global: " + isCacheGlobal));
        String uniqueID = req.getPortletWindowInternal().getWindowID().getUniqueID();
        String key = this.generateKey(req, isCacheGlobal, "");
        if (key != null) {
            this.portletMonitor.removeCachedData(portletAppName, portletName, key, isCacheGlobal);
        }
        if ((key = this.generateKey(req, isCacheGlobal, "r")) != null) {
            this.portletMonitor.removeCachedData(portletAppName, portletName, key, isCacheGlobal);
        }
        return econtext.executeNextUnit();
    }

    private void useCache(String portletAppName, String portletName, String key, PortletResponseImp response, boolean isCacheGlobal) {
        ((RenderOutput)response.getOutput()).setContent(this.portletMonitor.getCachedContent(portletAppName, portletName, key, isCacheGlobal));
        ((RenderOutput)response.getOutput()).setTitle(this.portletMonitor.getCachedTitle(portletAppName, portletName, key, isCacheGlobal));
        this.portletMonitor.setPortletLastAccessTime(portletAppName, portletName, key, System.currentTimeMillis(), isCacheGlobal);
    }

    private void useRCache(String portletAppName, String portletName, String key, PortletResponseImp response, boolean isCacheGlobal) {
        ((RenderOutput)response.getOutput()).setContent(this.portletMonitor.getCachedContent(portletAppName, portletName, key, isCacheGlobal));
        this.portletMonitor.setPortletLastAccessTime(portletAppName, portletName, key, System.currentTimeMillis(), isCacheGlobal);
    }

    private void updateCacheParams(String portletAppName, String portletName, String key, PortletResponseImp response, boolean isCacheGlobal) {
        String s = (String)response.getOutput().getProperties().get("portlet.ETag");
        if (s != null) {
            this.portletMonitor.setCachedETag(portletAppName, portletName, key, s, isCacheGlobal);
        }
        if ((s = (String)response.getOutput().getProperties().get("portlet.expiration-cache")) != null) {
            try {
                int i = Integer.parseInt(s);
                this.portletMonitor.setCacheExpirationPeriod(portletAppName, portletName, i);
            }
            catch (Exception e) {
                this.log.debug((Object)("Invalid value of EXPIRATION_CACHE property returned by " + portletAppName + "/" + portletName + "[" + s + "]"));
            }
        }
        if ((s = (String)response.getOutput().getProperties().get("portlet.cache-scope")) != null) {
            this.portletMonitor.setCacheScope(portletAppName, portletName, s);
        }
    }

    private void updateCache(String portletAppName, String portletName, String key, PortletResponseImp response, PortletMode mode, WindowState window, boolean isCacheGlobal) {
        this.log.debug((Object)"Update cache");
        this.portletMonitor.setCachedTitle(portletAppName, portletName, key, ((RenderOutput)response.getOutput()).getTitle(), isCacheGlobal);
        this.portletMonitor.setCachedContent(portletAppName, portletName, key, ((RenderOutput)response.getOutput()).getBinContent(), isCacheGlobal);
        this.portletMonitor.setCachedMode(portletAppName, portletName, key, mode, isCacheGlobal);
        this.portletMonitor.setCachedWindowState(portletAppName, portletName, key, window, isCacheGlobal);
        this.portletMonitor.setPortletLastAccessTime(portletAppName, portletName, key, System.currentTimeMillis(), isCacheGlobal);
        this.updateCacheParams(portletAppName, portletName, key, response, isCacheGlobal);
    }

    private void updateRCache(String portletAppName, String portletName, String key, PortletResponseImp response, boolean isCacheGlobal) {
        this.log.debug((Object)"Update cache");
        this.portletMonitor.setCachedContent(portletAppName, portletName, key, ((RenderOutput)response.getOutput()).getBinContent(), isCacheGlobal);
        this.portletMonitor.setPortletLastAccessTime(portletAppName, portletName, key, System.currentTimeMillis(), isCacheGlobal);
        this.updateCacheParams(portletAppName, portletName, key, response, isCacheGlobal);
    }

    private boolean resolveCache(String s, String s1) {
        return s != null && s.equals("true") || s1 != null && s1.equals("portlet.public-scope");
    }
}

