/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.helper.PortletWindowInternal;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.SecurityConstraint;
import org.exoplatform.services.portletcontainer.pci.model.SecurityRoleRef;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationProxy;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletContextImpl;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletRequestImp
extends HttpServletRequestWrapper
implements PortletRequest,
Map {
    private static final Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
    protected ExoContainer cont;
    protected RequestContext reqCtx;
    private Vector<String> paramNames;
    private Map<String, String[]> filteredMap;
    protected boolean encodingModified;
    protected String enc;
    private final Map<String, String[]> renderParameters;

    public PortletRequestImp(RequestContext reqCtx) {
        super(reqCtx.getHttpServletRequest());
        this.cont = ((PortletContextImpl)reqCtx.getPortletContext()).getContainer();
        this.reqCtx = reqCtx;
        this.enc = reqCtx.getHttpServletRequest().getCharacterEncoding();
        this.renderParameters = reqCtx.getInput().getRenderParameters();
    }

    public final boolean isWindowStateAllowed(WindowState windowState) {
        Enumeration e = this.reqCtx.getPortalContext().getSupportedWindowStates();
        while (e.hasMoreElements()) {
            WindowState supportedWindowState = (WindowState)e.nextElement();
            if (!supportedWindowState.toString().equalsIgnoreCase(windowState.toString())) continue;
            return true;
        }
        return false;
    }

    public final boolean isPortletModeAllowed(PortletMode portletMode) {
        Enumeration e = this.reqCtx.getPortalContext().getSupportedPortletModes();
        while (e.hasMoreElements()) {
            PortletMode supportedPortletMode = (PortletMode)e.nextElement();
            if (!supportedPortletMode.toString().equalsIgnoreCase(portletMode.toString())) continue;
            return true;
        }
        return false;
    }

    public final PortletConfig getPortletConfig() {
        ExoContainer manager = this.cont;
        String portletAppName = this.reqCtx.getPortletWindowInternal().getWindowID().getPortletApplicationName();
        PortletApplicationProxy proxy = (PortletApplicationProxy)manager.getComponentInstance((Object)(portletAppName + "_portlet_app_"));
        return proxy.getPortletConfig(this.reqCtx.getPortletWindowInternal().getWindowID().getPortletName());
    }

    public final Input getInput() {
        return this.reqCtx.getInput();
    }

    public final PortletMode getPortletMode() {
        return this.reqCtx.getInput().getPortletMode();
    }

    public final WindowState getWindowState() {
        return this.reqCtx.getInput().getWindowState();
    }

    public final PortletPreferences getPreferences() {
        return this.reqCtx.getPortletWindowInternal().getPreferences();
    }

    public final PortletSession getPortletSession() {
        return this.getPortletSession(true);
    }

    public final PortletSession getPortletSession(boolean create) {
        if (create) {
            if (this.reqCtx.getSession().isSessionValid()) {
                return this.reqCtx.getSession();
            }
            this.reqCtx.getSession().setSession(((HttpServletRequest)super.getRequest()).getSession(), this.reqCtx.getPortletWindowInternal().getWindowID().getUniqueID());
            return this.reqCtx.getSession();
        }
        HttpSession tmpSession = this.reqCtx.getSession().getSession();
        if (tmpSession == null) {
            return null;
        }
        try {
            tmpSession.getLastAccessedTime();
        }
        catch (IllegalStateException e) {
            return null;
        }
        return this.reqCtx.getSession();
    }

    public final boolean isRequestedSessionIdValid() {
        try {
            return ((HttpServletRequest)super.getRequest()).isRequestedSessionIdValid();
        }
        catch (IllegalStateException e) {
            log.error((Object)"IllegalStateExcetion sent in PortletRequestImp isRequestedSessionIdValid()", (Throwable)e);
            return false;
        }
    }

    public final String getProperty(String s) {
        String header = ((HttpServletRequest)super.getRequest()).getHeader(s);
        if (header != null) {
            return header;
        }
        return this.reqCtx.getPortalContext().getProperty(s);
    }

    public final Enumeration<String> getProperties(String s) {
        Enumeration header = ((HttpServletRequest)super.getRequest()).getHeaders(s);
        return header;
    }

    public final Enumeration<String> getPropertyNames() {
        String s;
        Enumeration headerNames = ((HttpServletRequest)super.getRequest()).getHeaderNames();
        Enumeration portalPropertyNames = this.reqCtx.getPortalContext().getPropertyNames();
        ArrayList<String> global = new ArrayList<String>();
        while (portalPropertyNames.hasMoreElements()) {
            s = (String)portalPropertyNames.nextElement();
            global.add(s);
        }
        while (headerNames.hasMoreElements()) {
            s = (String)headerNames.nextElement();
            global.add(s);
        }
        return Collections.enumeration(global);
    }

    public final PortalContext getPortalContext() {
        return this.reqCtx.getPortalContext();
    }

    public final String getResponseContentType() {
        List l = this.reqCtx.getPortletDatas().getSupports();
        String markup = this.reqCtx.getInput().getMarkup();
        String inputPortletMode = this.reqCtx.getInput().getPortletMode().toString();
        for (int i = 0; i < l.size(); ++i) {
            Supports supportsType = (Supports)l.get(i);
            String mimeType = supportsType.getMimeType();
            if (!mimeType.equals(markup)) continue;
            List portletModes = supportsType.getPortletMode();
            for (int modeIdx = 0; modeIdx < portletModes.size(); ++modeIdx) {
                String portletMode = (String)portletModes.get(modeIdx);
                if (!portletMode.equals(inputPortletMode)) continue;
                return mimeType;
            }
        }
        return "text/html";
    }

    public final Enumeration<String> getResponseContentTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getResponseContentType());
        String markup = this.reqCtx.getInput().getMarkup();
        String inputPortletMode = this.reqCtx.getInput().getPortletMode().toString();
        Iterator<String> i$ = this.reqCtx.getSupportedContents().iterator();
        while (i$.hasNext()) {
            String element;
            String supportedContent = element = i$.next();
            List l = this.reqCtx.getPortletDatas().getSupports();
            block1: for (int i = 0; i < l.size(); ++i) {
                Supports supportsType = (Supports)l.get(i);
                String mimeType = supportsType.getMimeType();
                if (!supportedContent.equals(mimeType) || supportedContent.equals(markup)) continue;
                List portletModes = supportsType.getPortletMode();
                for (String portletMode : portletModes) {
                    if (!portletMode.equals(inputPortletMode)) continue;
                    result.add(mimeType);
                    continue block1;
                }
            }
        }
        return Collections.enumeration(result);
    }

    public final boolean isUserInRole(String role) {
        List l = this.reqCtx.getPortletDatas().getSecurityRoleRef();
        for (SecurityRoleRef securityRoleRef : l) {
            if (!securityRoleRef.getRoleName().equals(role)) continue;
            String roleLink = securityRoleRef.getRoleLink();
            if (roleLink == null || "".equals(roleLink)) {
                if (this.isRoleDefinedInWebXML(role)) {
                    return super.isUserInRole(role);
                }
                return false;
            }
            if (this.isRoleDefinedInWebXML(roleLink)) {
                return super.isUserInRole(roleLink);
            }
            return false;
        }
        return false;
    }

    private boolean isRoleDefinedInWebXML(String role) {
        for (String element : this.reqCtx.getRoles()) {
            String roleDefined = element;
            if (!roleDefined.equals(role)) continue;
            return true;
        }
        return false;
    }

    public final Portlet getPortletDatas() {
        return this.reqCtx.getPortletDatas();
    }

    public final PortletWindowInternal getPortletWindowInternal() {
        return this.reqCtx.getPortletWindowInternal();
    }

    public final boolean needsSecurityContraints(String portletName) {
        for (SecurityConstraint securityConstraint : this.reqCtx.getSecurityContraints()) {
            List portletsNamesList = securityConstraint.getPortletCollection().getPortletName();
            for (String portletN : portletsNamesList) {
                if (!portletN.equals(portletName)) continue;
                return true;
            }
        }
        return false;
    }

    public final String getAuthType() {
        String type = super.getAuthType();
        if ("BASIC".equals(type)) {
            return "BASIC";
        }
        if ("DIGEST".equals(type)) {
            return "DIGEST";
        }
        if ("CLIENT_CERT".equals(type)) {
            return "CLIENT_CERT";
        }
        if ("FORM".equals(type)) {
            return "FORM";
        }
        return type;
    }

    public final Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        return super.getAttribute(name);
    }

    public final void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        if (value == null) {
            super.removeAttribute(name);
        } else {
            super.setAttribute(name, value);
        }
    }

    public final void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        super.removeAttribute(name);
    }

    public final String getContextPath() {
        return "/" + this.reqCtx.getPortletContext().getPortletContextName();
    }

    @Override
    public final int size() {
        int n = 0;
        Enumeration keys = this.getAttributeNames();
        while (keys.hasMoreElements()) {
            ++n;
        }
        return n;
    }

    @Override
    public final boolean isEmpty() {
        return !this.getAttributeNames().hasMoreElements();
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.getAttribute((String)key) != null;
    }

    @Override
    public final boolean containsValue(Object value) {
        boolean match = false;
        Enumeration keys = this.getAttributeNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object val = this.getAttribute(key);
            if (!value.equals(val)) continue;
            match = true;
            break;
        }
        return match;
    }

    public final Object get(Object key) {
        return this.getAttribute((String)key);
    }

    public final Object put(Object key, Object value) {
        Object result = null;
        if (this.containsKey(key)) {
            result = this.getAttribute((String)key);
        }
        this.setAttribute((String)key, value);
        return result;
    }

    public final Object remove(Object key) {
        Object result = null;
        if (this.containsKey(key)) {
            result = this.getAttribute((String)key);
        }
        this.removeAttribute((String)key);
        return result;
    }

    public final void putAll(Map t) {
        for (String key : t.keySet()) {
            Object value = t.get(key);
            this.put(key, value);
        }
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public final Set keySet() {
        throw new UnsupportedOperationException();
    }

    public final Collection values() {
        throw new UnsupportedOperationException();
    }

    public final Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public final Locale getLocale() {
        List locales = this.reqCtx.getInput().getLocales();
        if (locales != null && !locales.isEmpty()) {
            return (Locale)locales.iterator().next();
        }
        return super.getLocale();
    }

    public final Enumeration<Locale> getLocales() {
        List locales = this.reqCtx.getInput().getLocales();
        if (locales != null) {
            return Collections.enumeration(locales);
        }
        return super.getLocales();
    }

    public final String getWindowID() {
        return this.reqCtx.getInput().getInternalWindowID().getUniqueID();
    }

    public String getParameter(String param) {
        if (param == null || param.startsWith("portal:")) {
            throw new IllegalArgumentException("parameter must not be null");
        }
        String[] obj = this.renderParameters.get(param);
        if (obj instanceof String[]) {
            String[] tmp = obj;
            return tmp[0];
        }
        return (String)obj;
    }

    public Enumeration<String> getParameterNames() {
        if (this.paramNames == null) {
            Set<String> set = this.renderParameters.keySet();
            this.paramNames = new Vector();
            for (String key : set) {
                if (key.startsWith("portal:")) continue;
                this.paramNames.add(key);
            }
        }
        return this.paramNames.elements();
    }

    public String[] getParameterValues(String s) {
        if (s == null || s.startsWith("portal:")) {
            throw new IllegalArgumentException("parameter must not be null");
        }
        String[] o = this.renderParameters.get(s);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            String[] a = new String[]{(String)o};
            return a;
        }
        return o;
    }

    public Map<String, String[]> getParameterMap() {
        if (this.filteredMap == null) {
            Set<String> set = this.renderParameters.keySet();
            this.filteredMap = new HashMap<String, String[]>();
            for (String key : set) {
                String[] values = this.renderParameters.get(key);
                if (key.startsWith("portal:")) continue;
                this.filteredMap.put(key, values);
            }
        }
        return Collections.unmodifiableMap(this.filteredMap);
    }

    public final Map<String, String[]> getPrivateParameterMap() {
        if (!(this.getInput() instanceof RenderInput)) {
            return this.getParameterMap();
        }
        List pubNames = ((RenderInput)this.getInput()).getPublicParamNames();
        if (pubNames == null) {
            return this.getParameterMap();
        }
        HashMap<String, String[]> privateMap = new HashMap<String, String[]>();
        Map<String, String[]> allMap = this.getParameterMap();
        for (String name : allMap.keySet()) {
            if (pubNames.contains(name)) continue;
            privateMap.put(name, allMap.get(name));
        }
        return Collections.unmodifiableMap(privateMap);
    }

    public final Map<String, String[]> getPublicParameterMap() {
        if (!(this.getInput() instanceof RenderInput)) {
            return Collections.unmodifiableMap(new HashMap());
        }
        List pubNames = ((RenderInput)this.getInput()).getPublicParamNames();
        if (pubNames == null) {
            return Collections.unmodifiableMap(new HashMap());
        }
        HashMap<String, String[]> publicMap = new HashMap<String, String[]>();
        Map<String, String[]> allMap = this.getParameterMap();
        for (String name : allMap.keySet()) {
            if (!pubNames.contains(name)) continue;
            publicMap.put(name, allMap.get(name));
        }
        return Collections.unmodifiableMap(publicMap);
    }
}

