/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.pci.model.Preference;
import org.exoplatform.services.portletcontainer.persistence.PortletPreferencesPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletPreferencesImp
implements PortletPreferences,
Serializable {
    private final transient PreferencesValidator validator_;
    private final transient ExoPortletPreferences defaultPreferences_;
    private transient int methodCalledIsAction_;
    private transient boolean stateChangeAuthorized_ = true;
    private ExoPortletPreferences preferences_ = new ExoPortletPreferences();
    private ExoPortletPreferences modifiedPreferences_ = new ExoPortletPreferences();
    private boolean stateSaveOnClient_;
    protected WindowID windowID_;
    private final PortletPreferencesPersister persister_;

    public PortletPreferencesImp(PreferencesValidator validator, ExoPortletPreferences defaultPreferences, WindowID windowID, PortletPreferencesPersister persister) {
        this.validator_ = validator;
        this.defaultPreferences_ = defaultPreferences;
        this.windowID_ = windowID;
        this.persister_ = persister;
        this.fillCurrentPreferences();
    }

    private void fillCurrentPreferences() {
        if (this.defaultPreferences_ == null) {
            return;
        }
        Collection collection = this.defaultPreferences_.values();
        for (Preference preferenceType : collection) {
            Preference wrapper = new Preference();
            wrapper.setName(preferenceType.getName());
            wrapper.setReadOnly(preferenceType.isReadOnly());
            List values = preferenceType.getValues();
            for (int j = 0; j < values.size(); ++j) {
                wrapper.addValue((String)values.get(j));
            }
            this.preferences_.put((Object)preferenceType.getName(), (Object)wrapper);
        }
    }

    public ExoPortletPreferences getCurrentPreferences() {
        return this.preferences_;
    }

    public void setCurrentPreferences(ExoPortletPreferences map) {
        this.preferences_ = map;
    }

    public boolean isReadOnly(String s) {
        if (s == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        Preference wrapper = (Preference)this.modifiedPreferences_.get((Object)s);
        if (wrapper == null) {
            wrapper = (Preference)this.preferences_.get((Object)s);
        }
        if (wrapper == null) {
            return false;
        }
        return wrapper.isReadOnly();
    }

    public String getValue(String s, String s1) {
        if (s == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        Preference wrapper = (Preference)this.modifiedPreferences_.get((Object)s);
        if (wrapper == null) {
            wrapper = (Preference)this.preferences_.get((Object)s);
        }
        if (wrapper == null || wrapper.getValues().isEmpty()) {
            return s1;
        }
        return (String)wrapper.getValues().iterator().next();
    }

    public String[] getValues(String s, String[] strings) {
        if (s == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        Preference wrapper = (Preference)this.modifiedPreferences_.get((Object)s);
        if (wrapper == null) {
            wrapper = (Preference)this.preferences_.get((Object)s);
        }
        if (wrapper == null || wrapper.getValues().isEmpty()) {
            return strings;
        }
        Object[] arr = wrapper.getValues().toArray();
        String[] sA = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Object o = arr[i];
            sA[i] = (String)o;
        }
        return sA;
    }

    public void setValue(String s, String s1) throws ReadOnlyException {
        if (s == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        if (this.isReadOnly(s)) {
            throw new ReadOnlyException("the value " + s + " can not be changed");
        }
        Preference wrapper = new Preference();
        wrapper.setName(s);
        wrapper.setReadOnly(false);
        wrapper.getValues().add(s1);
        this.modifiedPreferences_.put((Object)s, (Object)wrapper);
    }

    public void setValues(String s, String[] strings) throws ReadOnlyException {
        if (s == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        if (this.isReadOnly(s)) {
            throw new ReadOnlyException("the value " + s + " can not be changed");
        }
        Preference wrapper = new Preference();
        wrapper.setName(s);
        wrapper.setReadOnly(false);
        ArrayList<String> c = new ArrayList<String>(strings.length);
        for (String string : strings) {
            c.add(string);
        }
        wrapper.getValues().addAll(c);
        this.modifiedPreferences_.put((Object)s, (Object)wrapper);
    }

    public Enumeration<String> getNames() {
        ArrayList<String> c = new ArrayList<String>();
        Set names = this.mergeModifiedPreference().keySet();
        for (String s : names) {
            c.add(s);
        }
        return Collections.enumeration(c);
    }

    public Map<String, String[]> getMap() {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Set keys = this.mergeModifiedPreference().keySet();
        for (String key : keys) {
            Preference element = (Preference)this.mergeModifiedPreference().get((Object)key);
            List c2 = element.getValues();
            String[] myArray = new String[c2.size()];
            int i = 0;
            Iterator iterator3 = c2.iterator();
            while (iterator3.hasNext()) {
                String value;
                myArray[i] = value = (String)iterator3.next();
                ++i;
            }
            result.put(key, myArray);
        }
        return Collections.unmodifiableMap(result);
    }

    private ExoPortletPreferences mergeModifiedPreference() {
        ExoPortletPreferences result = new ExoPortletPreferences();
        result.putAll((Map)this.modifiedPreferences_);
        Set keys = this.preferences_.keySet();
        for (String key : keys) {
            if (result.containsKey((Object)key)) continue;
            result.put((Object)key, this.preferences_.get((Object)key));
        }
        return result;
    }

    public void reset(String s) throws ReadOnlyException {
        if (s == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        if (this.isReadOnly(s)) {
            throw new ReadOnlyException("the value " + s + " can not be changed");
        }
        Preference preferenceType = null;
        if (this.defaultPreferences_ != null) {
            preferenceType = (Preference)this.defaultPreferences_.get((Object)s);
        }
        try {
            if (preferenceType == null) {
                this.preferences_.remove((Object)s);
            } else {
                Preference wrapper = (Preference)this.preferences_.get((Object)s);
                wrapper.getValues().clear();
                List defaultValues = preferenceType.getValues();
                for (int i = 0; i < defaultValues.size(); ++i) {
                    wrapper.addValue((String)defaultValues.get(i));
                }
            }
            this.modifiedPreferences_.remove((Object)s);
            if (this.persister_.getPortletPreferences(this.windowID_) != null) {
                this.save(this.preferences_);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("can not remove preference", e);
        }
    }

    public void store() throws IOException, ValidatorException {
        if (!this.isMethodCalledIsAction()) {
            throw new IllegalStateException("the store() method can not be called from a render method");
        }
        if (!this.isStateChangeAuthorized()) {
            throw new IllegalStateException("the state of the portlet can not be changed");
        }
        if (this.validator_ != null) {
            this.validator_.validate((PortletPreferences)this);
        }
        this.preferences_ = this.mergeModifiedPreference();
        this.modifiedPreferences_ = new ExoPortletPreferences();
        if (!this.isStateSaveOnClient()) {
            this.save(this.getCurrentPreferences());
        }
    }

    private void save(ExoPortletPreferences preferences) throws IOException {
        try {
            this.persister_.savePortletPreferences(this.windowID_, preferences);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage()){

                public Throwable getCause() {
                    return ex;
                }
            };
        }
    }

    public void discard() {
        this.modifiedPreferences_ = new ExoPortletPreferences();
    }

    public void setMethodCalledIsAction(int b) {
        this.methodCalledIsAction_ = b;
    }

    public int getMethodCalledIsAction() {
        return this.methodCalledIsAction_;
    }

    public boolean isMethodCalledIsAction() {
        return this.methodCalledIsAction_ == 1;
    }

    public boolean isStateChangeAuthorized() {
        return this.stateChangeAuthorized_;
    }

    public void setStateChangeAuthorized(boolean stateChangeAuthorized) {
        this.stateChangeAuthorized_ = stateChangeAuthorized;
    }

    public void setStateSaveOnClient(boolean stateSaveOnClient) {
        this.stateSaveOnClient_ = stateSaveOnClient;
    }

    public boolean isStateSaveOnClient() {
        return this.stateSaveOnClient_;
    }
}

