/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.utils.CustomRequestWrapperUtil;

public class CustomRequestWrapper
extends HttpServletRequestWrapper {
    public String pathInfo;
    public String servletPath;
    public String query;
    private String windowId;
    private boolean redirected;
    public String contextPath;
    private Map parameterMap;
    private boolean ver2 = false;
    private boolean noInput;
    private boolean noValues;

    public CustomRequestWrapper(HttpServletRequest httpServletRequest, String windowId) {
        super(httpServletRequest);
        this.windowId = windowId;
        this.parameterMap = httpServletRequest.getParameterMap();
    }

    protected void setVer2(boolean val) {
        this.ver2 = val;
    }

    public Enumeration getAttributeNames() {
        Enumeration e = super.getAttributeNames();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            s = CustomRequestWrapperUtil.decodeRequestAttribute(this.windowId, s);
            v.add(s);
        }
        return v.elements();
    }

    public Object getAttribute(String s) {
        return super.getAttribute(CustomRequestWrapperUtil.encodeAttribute(this.windowId, s));
    }

    public void removeAttribute(String s) {
        super.removeAttribute(CustomRequestWrapperUtil.encodeAttribute(this.windowId, s));
    }

    public void setAttribute(String s, Object o) {
        super.setAttribute(CustomRequestWrapperUtil.encodeAttribute(this.windowId, s), o);
    }

    public Map getParameterMap() {
        Map superMap = super.getParameterMap();
        if (this.redirected) {
            HashMap filteredMap = new HashMap();
            Set keys = superMap.keySet();
            for (String element : keys) {
                if (element.startsWith("portal:")) continue;
                filteredMap.put(element, superMap.get(element));
            }
            return filteredMap;
        }
        return superMap;
    }

    public void setParameterMap(Map map) {
        this.parameterMap = map;
    }

    public boolean isRedirected() {
        return this.redirected;
    }

    public void setRedirected(boolean b) {
        this.redirected = b;
    }

    public int getContentLength() {
        if (this.noValues) {
            return 0;
        }
        if (this.redirected) {
            return -1;
        }
        return super.getContentLength();
    }

    public StringBuffer getRequestURL() {
        if (this.redirected) {
            return null;
        }
        return super.getRequestURL();
    }

    public String getCharacterEncoding() {
        if (this.noValues) {
            return null;
        }
        return super.getCharacterEncoding();
    }

    public String getContentType() {
        if (this.redirected) {
            return null;
        }
        return super.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.noInput) {
            return null;
        }
        return super.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        if (this.noInput) {
            return null;
        }
        return super.getReader();
    }

    public String getLocalAddr() {
        if (this.redirected) {
            return null;
        }
        return super.getLocalAddr();
    }

    public String getLocalName() {
        if (this.redirected) {
            return null;
        }
        return super.getLocalName();
    }

    public int getLocalPort() {
        if (this.redirected) {
            return 0;
        }
        return super.getLocalPort();
    }

    public int getRemotePort() {
        if (this.redirected) {
            return 0;
        }
        return super.getRemotePort();
    }

    public String getRealPath(String arg0) {
        if (this.redirected) {
            return null;
        }
        return super.getRealPath(arg0);
    }

    public String getRemoteAddr() {
        if (this.redirected) {
            return null;
        }
        return super.getRemoteAddr();
    }

    public String getRemoteHost() {
        if (this.redirected) {
            return null;
        }
        return super.getRemoteHost();
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        if (this.redirected) {
            return;
        }
        super.setCharacterEncoding(arg0);
    }

    public String getProtocol() {
        if (this.redirected) {
            return "HTTP/1.1";
        }
        return super.getProtocol();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean b) {
        return super.getSession(b);
    }

    public boolean isRequestedSessionIdValid() {
        return super.isRequestedSessionIdValid();
    }

    public void setContextPath(String string) {
        this.contextPath = string;
    }

    public String getContextPath() {
        if (this.redirected && this.contextPath != null) {
            return this.contextPath;
        }
        return super.getContextPath();
    }

    public void setRedirectedPath(String path) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        String[] key = StringUtils.split((String)path, (String)"?");
        String firstPart = "";
        if (key.length > 1) {
            this.query = key[1];
            firstPart = key[0];
        } else {
            firstPart = path;
        }
        if (firstPart.indexOf("/", 1) > 0) {
            this.servletPath = firstPart.substring(0, firstPart.indexOf("/", 1));
            this.pathInfo = firstPart.substring(firstPart.indexOf("/", 1));
        } else {
            this.servletPath = firstPart;
            this.pathInfo = null;
        }
    }

    public String getPathInfo() {
        if (this.redirected) {
            return this.pathInfo;
        }
        return super.getPathInfo();
    }

    public String getServletPath() {
        if (this.redirected) {
            return this.servletPath;
        }
        return super.getServletPath();
    }

    public String getQueryString() {
        if (this.redirected) {
            return this.query;
        }
        return super.getQueryString();
    }

    public String getRequestURI() {
        if (this.redirected) {
            return this.getContextPath() + (this.servletPath == null ? "" : this.servletPath) + (this.pathInfo == null ? "" : this.pathInfo);
        }
        return super.getRequestURI();
    }

    public void setNoInput(boolean noInput) {
        this.noInput = noInput;
    }

    public void setNoValues(boolean noValues) {
        this.noValues = noValues;
    }
}

