/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.consumer.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.PortletContainerConf;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.services.portletcontainer.PortletContainerPlugin;
import org.exoplatform.services.portletcontainer.PortletContainerService;
import org.exoplatform.services.portletcontainer.helper.WindowInfosContainer;
import org.exoplatform.services.portletcontainer.pci.ActionInput;
import org.exoplatform.services.portletcontainer.pci.ActionOutput;
import org.exoplatform.services.portletcontainer.pci.EventInput;
import org.exoplatform.services.portletcontainer.pci.EventOutput;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.ResourceInput;
import org.exoplatform.services.portletcontainer.pci.ResourceOutput;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.DisplayName;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletDataImp;
import org.exoplatform.services.wsrp.consumer.ConsumerEnvironment;
import org.exoplatform.services.wsrp.consumer.GroupSessionMgr;
import org.exoplatform.services.wsrp.consumer.PortletDriver;
import org.exoplatform.services.wsrp.consumer.PortletKey;
import org.exoplatform.services.wsrp.consumer.PortletSession;
import org.exoplatform.services.wsrp.consumer.PortletWindowSession;
import org.exoplatform.services.wsrp.consumer.Producer;
import org.exoplatform.services.wsrp.consumer.ProducerRegistry;
import org.exoplatform.services.wsrp.consumer.URLTemplateComposer;
import org.exoplatform.services.wsrp.consumer.User;
import org.exoplatform.services.wsrp.consumer.UserSessionMgr;
import org.exoplatform.services.wsrp.consumer.WSRPInteractionRequest;
import org.exoplatform.services.wsrp.consumer.WSRPMarkupRequest;
import org.exoplatform.services.wsrp.consumer.WSRPPortlet;
import org.exoplatform.services.wsrp.consumer.adapters.PortletKeyAdapter;
import org.exoplatform.services.wsrp.consumer.adapters.UserAdapter;
import org.exoplatform.services.wsrp.consumer.adapters.WSRPBaseRequestAdapter;
import org.exoplatform.services.wsrp.consumer.adapters.WSRPInteractionRequestAdapter;
import org.exoplatform.services.wsrp.consumer.adapters.WSRPMarkupRequestAdapter;
import org.exoplatform.services.wsrp.consumer.adapters.WSRPPortletAdapter;
import org.exoplatform.services.wsrp.consumer.impl.helpers.UserSessionImpl;
import org.exoplatform.services.wsrp.consumer.portlets.WSRPAdminPortletDataImp;
import org.exoplatform.services.wsrp.exceptions.WSRPException;
import org.exoplatform.services.wsrp.producer.impl.WSRPConfiguration;
import org.exoplatform.services.wsrp.type.BlockingInteractionResponse;
import org.exoplatform.services.wsrp.type.ClientData;
import org.exoplatform.services.wsrp.type.ItemDescription;
import org.exoplatform.services.wsrp.type.LocalizedString;
import org.exoplatform.services.wsrp.type.MarkupContext;
import org.exoplatform.services.wsrp.type.MarkupResponse;
import org.exoplatform.services.wsrp.type.MarkupType;
import org.exoplatform.services.wsrp.type.NamedString;
import org.exoplatform.services.wsrp.type.PersonName;
import org.exoplatform.services.wsrp.type.PortletContext;
import org.exoplatform.services.wsrp.type.PortletDescription;
import org.exoplatform.services.wsrp.type.ServiceDescription;
import org.exoplatform.services.wsrp.type.SessionContext;
import org.exoplatform.services.wsrp.type.StateChange;
import org.exoplatform.services.wsrp.type.UpdateResponse;
import org.exoplatform.services.wsrp.type.UserContext;
import org.exoplatform.services.wsrp.type.UserProfile;
import org.exoplatform.services.wsrp.utils.Modes;
import org.exoplatform.services.wsrp.utils.Utils;
import org.exoplatform.services.wsrp.utils.WindowStates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPConsumerPlugin
implements PortletContainerPlugin {
    private static final String[] characterEncodings = new String[]{"UTF-8"};
    private static final String[] mimeTypes = new String[]{"text/html", "text/wml"};
    public static final String[] SUPPORTED_LOCALES = new String[]{"en", "fr"};
    private static final String consumerAgent = "exoplatform.3.0";
    private static final String userAgent = "userAgent";
    private static final String basePath = "/portal/";
    protected WSRPAdminPortletDataImp adminPortlet = null;
    public static final String USER_SESSIONS_KEY = "user_session_key";
    private ExoContainer container;
    private ConsumerEnvironment consumer;
    private PortletContainerService pcService;
    private URLTemplateComposer templateComposer;
    private PortletContainerConf pcConf;
    private WSRPConfiguration conf;
    private Log log;
    private String pluginName;
    private static boolean init = false;

    public WSRPConsumerPlugin(ExoContainerContext context, ConsumerEnvironment consumer, PortletContainerService pcService, URLTemplateComposer templateComposer, PortletContainerConf pcConf, WSRPConfiguration conf) {
        this.container = context.getContainer();
        this.consumer = consumer;
        this.pcService = pcService;
        this.templateComposer = templateComposer;
        this.pcConf = pcConf;
        this.conf = conf;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp.consumer.impl.WSRPConsumerPlugin");
        this.initConsumer();
    }

    public void setName(String name) {
        this.pluginName = name;
    }

    public String getName() {
        return this.pluginName;
    }

    public void setDescription(String description) {
        this.pcConf.setDescription(description);
    }

    public String getDescription() {
        return this.pcConf.getDescription();
    }

    public void setMajorVersion(int majorVersion) {
        this.pcConf.setMajorVersion(majorVersion);
    }

    public void setMinorVersion(int minorVersion) {
        this.pcConf.setMinorVersion(minorVersion);
    }

    public void setProperties(Map<String, String> properties) {
        this.pcConf.setProperties(properties);
    }

    protected void initConsumer() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"WSRPConsumerPlugin.initConsumer");
        }
        this.consumer.setCharacterEncodingSet(characterEncodings);
        this.consumer.setConsumerAgent(consumerAgent);
        this.consumer.setMimeTypes(mimeTypes);
        this.consumer.setPortletStateChange(StateChange.readWrite);
        this.consumer.setSupportedModes(this.getPortletModes(this.pcService.getSupportedPortletModes()));
        this.consumer.setSupportedWindowStates(this.getWindowStates(this.pcService.getSupportedWindowStates()));
        this.consumer.setUserAuthentication("wsrp:none");
        this.consumer.setSupportedLocales(SUPPORTED_LOCALES);
        this.adminPortlet = new WSRPAdminPortletDataImp(this.container, this.conf.getAdminPortletParams());
        init = true;
    }

    private String[] getPortletModes(Collection<PortletMode> supportedPortletModes) {
        String[] array = new String[supportedPortletModes.size()];
        int i = 0;
        for (PortletMode portletMode : supportedPortletModes) {
            array[i] = portletMode.toString();
            ++i;
        }
        return array;
    }

    private String[] getWindowStates(Collection<WindowState> supportedWindowStates) {
        String[] array = new String[supportedWindowStates.size()];
        int i = 0;
        for (WindowState windowState : supportedWindowStates) {
            array[i] = windowState.toString();
            ++i;
        }
        return array;
    }

    public Collection<PortletMode> getSupportedPortletModes() {
        if (!init) {
            return null;
        }
        ProducerRegistry pregistry = this.consumer.getProducerRegistry();
        Iterator<Producer> i = pregistry.getAllProducers();
        ArrayList<PortletMode> result = null;
        while (i.hasNext()) {
            Producer producer = i.next();
            try {
                ServiceDescription desc = producer.getServiceDescription();
                result = new ArrayList<PortletMode>();
                ItemDescription[] iDArray = desc.getCustomModeDescriptions();
                if (iDArray == null) continue;
                for (int j = 0; j < Array.getLength(iDArray); ++j) {
                    ItemDescription iD = iDArray[j];
                    String mode = iD.getItemName();
                    if (result.contains(mode)) continue;
                    result.add(new PortletMode(mode));
                }
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Collection<WindowState> getSupportedWindowStates() {
        if (!init) {
            return null;
        }
        ProducerRegistry pregistry = this.consumer.getProducerRegistry();
        Iterator<Producer> i = pregistry.getAllProducers();
        ArrayList<WindowState> result = null;
        while (i.hasNext()) {
            Producer producer = i.next();
            try {
                ServiceDescription desc = producer.getServiceDescription();
                result = new ArrayList<WindowState>();
                ItemDescription[] iDArray = desc.getCustomWindowStateDescriptions();
                if (iDArray == null) continue;
                for (int j = 0; j < Array.getLength(iDArray); ++j) {
                    ItemDescription iD = iDArray[j];
                    String state = iD.getItemName();
                    if (result.contains(state)) continue;
                    result.add(new WindowState(state));
                }
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Collection<PortletMode> getPortletModes(String portletAppName, String portletName, String markup) {
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            return this.adminPortlet.getPortletModes(markup);
        }
        String producerID = portletAppName.substring(0, portletAppName.indexOf("@"));
        String portletHandle = portletAppName.substring(portletAppName.indexOf("@") + 1) + "/" + portletName;
        if (!init) {
            return null;
        }
        ArrayList<PortletMode> result = null;
        ProducerRegistry pregistry = this.consumer.getProducerRegistry();
        Iterator<Producer> i = pregistry.getAllProducers();
        while (i.hasNext()) {
            Producer producer = i.next();
            if (!producer.getID().equalsIgnoreCase(producerID)) continue;
            try {
                ServiceDescription sD = producer.getServiceDescription();
                result = new ArrayList<PortletMode>();
                PortletDescription[] portletDescriptions = sD.getOfferedPortlets();
                if (portletDescriptions == null) continue;
                for (int k = 0; k < portletDescriptions.length; ++k) {
                    PortletDescription portletDescription = portletDescriptions[k];
                    String portletHandleTemp = portletDescription.getPortletHandle();
                    if (!portletHandleTemp.equalsIgnoreCase(portletHandle)) continue;
                    MarkupType[] markupType = portletDescription.getMarkupTypes();
                    for (int j = 0; j < markupType.length; ++j) {
                        MarkupType type = markupType[j];
                        if (!type.getMimeType().equalsIgnoreCase(markup)) continue;
                        String[] result_in_array = type.getModes();
                        for (int m = 0; m < result_in_array.length; ++m) {
                            result.add(Modes.getJsrPortletMode(result_in_array[m]));
                        }
                    }
                    return result;
                }
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean isModeSuported(String portletAppName, String portletName, String markup, PortletMode mode) {
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            return this.adminPortlet.isModeSuported(markup, mode);
        }
        return false;
    }

    public final String[] getPortalManagedPortletModes(String portletAppName, String portletName) {
        return new String[0];
    }

    public Collection<WindowState> getWindowStates(String portletAppName, String portletName, String markup) {
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            return this.adminPortlet.getWindowStates(markup);
        }
        String producerID = portletAppName.substring(0, portletAppName.indexOf("@"));
        String portletHandle = portletAppName.substring(portletAppName.indexOf("@") + 1) + "/" + portletName;
        if (!init) {
            return null;
        }
        ArrayList<WindowState> result = null;
        ProducerRegistry pregistry = this.consumer.getProducerRegistry();
        Iterator<Producer> i = pregistry.getAllProducers();
        while (i.hasNext()) {
            Producer producer = i.next();
            if (!producer.getID().equalsIgnoreCase(producerID)) continue;
            try {
                ServiceDescription sD = producer.getServiceDescription();
                result = new ArrayList<WindowState>();
                PortletDescription[] portletDescriptions = sD.getOfferedPortlets();
                if (portletDescriptions == null) continue;
                for (int k = 0; k < portletDescriptions.length; ++k) {
                    PortletDescription portletDescription = portletDescriptions[k];
                    String portletHandleTemp = portletDescription.getPortletHandle();
                    if (!portletHandleTemp.equalsIgnoreCase(portletHandle)) continue;
                    MarkupType[] markupType = portletDescription.getMarkupTypes();
                    for (int j = 0; j < markupType.length; ++j) {
                        MarkupType type = markupType[j];
                        if (!type.getMimeType().equalsIgnoreCase(markup)) continue;
                        String[] result_in_array = type.getWindowStates();
                        for (int m = 0; m < result_in_array.length; ++m) {
                            result.add(WindowStates.getJsrWindowState(result_in_array[m]));
                        }
                    }
                    return result;
                }
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean isStateSupported(String portletAppName, String portletName, String markup, WindowState state) {
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            return this.adminPortlet.isStateSupported(markup, state);
        }
        return false;
    }

    public boolean isEventPayloadTypeMatches(String portletAppName, QName eventName, Serializable payload) throws PortletContainerException {
        throw new UnsupportedOperationException("Unsupported operation 'isEventPayloadTypeMatches' for WSRP1 plugin");
    }

    public Map<String, PortletData> getAllPortletMetaData() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"getAllPortletMetaData() entered");
        }
        HashMap<String, PortletData> result = new HashMap<String, PortletData>();
        result.put("@WSRP1App/WSRPAdminPortlet", (PortletData)this.adminPortlet);
        String producerId = null;
        String portletHandle = null;
        ProducerRegistry pregistry = this.consumer.getProducerRegistry();
        Iterator<Producer> i = pregistry.getAllProducers();
        ServiceDescription desc = null;
        while (i.hasNext()) {
            Producer producer = i.next();
            try {
                desc = producer.getServiceDescription();
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
            producerId = producer.getID();
            PortletDescription[] portletDescriptions = desc.getOfferedPortlets();
            if (portletDescriptions == null) continue;
            for (int k = 0; k < portletDescriptions.length; ++k) {
                PortletDescription portletDescription = portletDescriptions[k];
                portletHandle = portletDescription.getPortletHandle();
                Portlet portlet = new Portlet();
                portlet.setPortletName(portletDescription.getPortletHandle());
                portlet.setPortletClass(null);
                if (portletDescription.getDisplayName() != null) {
                    DisplayName displayName = new DisplayName();
                    displayName.setDisplayName(portletDescription.getDisplayName().getValue());
                    displayName.setLang("en");
                    portlet.addDisplayName(displayName);
                }
                if (portletDescription.getMarkupTypes() != null) {
                    MarkupType[] mt = portletDescription.getMarkupTypes();
                    for (int t = 0; t < mt.length; ++t) {
                        MarkupType markupType = mt[t];
                        Supports supports = new Supports();
                        supports.setMimeType(markupType.getMimeType());
                        ArrayList<String> modes = new ArrayList<String>();
                        String[] mm = markupType.getModes();
                        for (int j = 0; j < mm.length; ++j) {
                            modes.add(mm[j]);
                        }
                        supports.setPortletMode(modes);
                        ArrayList<String> states = new ArrayList<String>();
                        String[] ss = markupType.getWindowStates();
                        for (int j = 0; j < ss.length; ++j) {
                            states.add(ss[j]);
                        }
                        supports.setWindowState(states);
                        portlet.addSupports(supports);
                    }
                }
                if (StringUtils.split((String)portletHandle, (String)"/").length == 1) {
                    portletHandle = "unnamed/" + portletHandle;
                }
                String newPortletHandle = producerId + "@" + portletHandle;
                result.put(newPortletHandle, (PortletData)new PortletDataImp(this.container, portlet, null, new ArrayList(), false));
            }
        }
        return result;
    }

    public PortletApp getPortletApp(String portletAppName) {
        return null;
    }

    public ResourceBundle getBundle(HttpServletRequest request, HttpServletResponse response, String portletAppName, String portletName, Locale locale) throws PortletContainerException {
        MapResourceBundle bundle = new MapResourceBundle(locale);
        if (portletAppName.equals("@WSRP1App") && portletName.equals("WSRPAdminPortlet")) {
            bundle.add("javax.portlet.title", (Object)"WSRPAdminPortlet");
            bundle.add("javax.portlet.short-title", (Object)"WSRPAdminPortlet");
            bundle.add("javax.portlet.keywords", (Object)"WSRPAdminPortlet");
            return bundle;
        }
        String producerID = portletAppName.substring(0, portletAppName.indexOf("@"));
        String portletHandle = portletAppName.substring(portletAppName.indexOf("@") + 1) + "/" + portletName;
        try {
            PortletDescription pd = this.getProducer(producerID).getPortletDescription(portletHandle);
            bundle.add("javax.portlet.title", (Object)Utils.getStringFromLocalizedString(pd.getTitle()));
            bundle.add("javax.portlet.short-title", (Object)Utils.getStringFromLocalizedString(pd.getShortTitle()));
            if (pd.getKeywords() != null) {
                bundle.add("javax.portlet.keywords", (Object)Utils.getStringFromLocalizedString(pd.getKeywords()[0]));
            } else {
                bundle.add("javax.portlet.keywords", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bundle;
    }

    public void setPortletPreference(Input input, Map<String, String> preferences) throws PortletContainerException {
    }

    public Map<String, String[]> getPortletPreference(Input input) {
        return null;
    }

    public PortletPreferences getPortletPreferences(Input input) {
        return null;
    }

    public void setPortletPreference2(Input input, Map<String, String[]> preferences) throws PortletContainerException {
    }

    public void setPortletPreferences(Input input, PortletPreferences preferences) throws PortletContainerException {
    }

    public ActionOutput processAction(HttpServletRequest request, HttpServletResponse response, ActionInput input) throws PortletContainerException {
        this.log.debug((Object)"processAction method in WSRPConsumerPlugin entered");
        if (!init) {
            return null;
        }
        String portletAppName = input.getInternalWindowID().getPortletApplicationName();
        String portletName = input.getInternalWindowID().getPortletName();
        String uniqueID = input.getInternalWindowID().getUniqueID();
        String producerID = portletAppName.substring(0, portletAppName.indexOf("@"));
        String portletHandle = portletAppName.substring(portletAppName.indexOf("@") + 1) + "/" + portletName;
        ActionOutput output = new ActionOutput();
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            this.adminPortlet.getPortletObject().processAction(input, output, request);
            return output;
        }
        PortletKey portletKey = null;
        try {
            portletKey = this.getPortletKey(producerID, portletHandle);
        }
        catch (Exception e) {
            throw new PortletContainerException("exception in WSRPConsumerPlugin.processAction method", (Throwable)e);
        }
        if (this.getProducer(portletKey.getProducerId()) != null) {
            try {
                String key = input.getInternalWindowID().generateKey();
                this.log.debug((Object)("use windowID : " + key));
                User user = this.getUser(request);
                String userID = null;
                if (user != null) {
                    userID = user.getUserID();
                    this.log.debug((Object)("use userID : " + userID));
                }
                WSRPPortlet portlet = this.getPortlet(portletKey, portletHandle);
                String newPortletHandle = portletHandle + "/" + uniqueID;
                portlet.getPortletContext().setPortletHandle(newPortletHandle);
                UserSessionMgr userSession = this.getUserSession(request.getSession(), portletKey.getProducerId());
                userSession.setUserID(userID);
                PortletWindowSession windowSession = this.getWindowSession(portletKey, portlet, userSession, key);
                PortletDriver portletDriver = this.consumer.getPortletDriverRegistry().getPortletDriver(portlet);
                WSRPInteractionRequest iRequest = this.getInteractionRequest(windowSession, request, input);
                BlockingInteractionResponse iResponse = portletDriver.performBlockingInteraction(iRequest, userSession, userID);
                if (iResponse != null) {
                    this.log.debug((Object)"manage BlockingInteractionResponse object content");
                    UpdateResponse updateResponse = iResponse.getUpdateResponse();
                    String redirectURL = iResponse.getRedirectURL();
                    if (updateResponse != null) {
                        String newWindowState;
                        String newMode;
                        if (windowSession != null) {
                            this.updateSessionContext(updateResponse.getSessionContext(), windowSession.getPortletSession());
                            windowSession.updateMarkupCache(updateResponse.getMarkupContext());
                        }
                        this.updatePortletContext(updateResponse.getPortletContext(), portlet);
                        String navState = updateResponse.getNavigationalState();
                        if (navState != null) {
                            this.log.debug((Object)("set new navigational state : " + navState));
                            output.setRenderParameter("wsrp-navigationalState", navState);
                        }
                        if ((newMode = updateResponse.getNewMode()) != null) {
                            this.log.debug((Object)("set Mode required : " + newMode));
                            output.setNextMode(Modes.getJsrPortletMode(newMode));
                        }
                        if ((newWindowState = updateResponse.getNewWindowState()) != null) {
                            this.log.debug((Object)("set new required window state : " + newWindowState));
                            output.setNextState(WindowStates.getJsrWindowState(newWindowState));
                        }
                    } else if (redirectURL != null) {
                        this.log.debug((Object)("Redirect action to URL : " + redirectURL));
                        if (redirectURL.startsWith("/") || redirectURL.startsWith("http://") || redirectURL.startsWith("https://")) {
                            output.addProperty("_send_redirect_", (Object)redirectURL);
                        } else {
                            this.log.error((Object)"Can not redirect action: a relative or incorrect path URL is given");
                        }
                    }
                }
                return output;
            }
            catch (WSRPException e) {
                throw new PortletContainerException("exception in WSRPConsumerPlugin.processAction method", (Throwable)e);
            }
        }
        return output;
    }

    public EventOutput processEvent(HttpServletRequest request, HttpServletResponse response, EventInput input) throws PortletContainerException {
        throw new UnsupportedOperationException("Unsupported operation 'processEvent' for WSRP1 plugin");
    }

    public ResourceOutput serveResource(HttpServletRequest request, HttpServletResponse response, ResourceInput input) throws PortletContainerException {
        throw new UnsupportedOperationException("Unsupported operation 'serveResource' for WSRP1 plugin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RenderOutput render(HttpServletRequest request, HttpServletResponse response, RenderInput input) throws PortletContainerException {
        this.log.debug((Object)"Render method in WSRPConsumerPlugin entered");
        this.templateComposer.setHost(request.getServerName());
        this.templateComposer.setPort(request.getServerPort());
        String portletAppName = input.getInternalWindowID().getPortletApplicationName();
        String portletName = input.getInternalWindowID().getPortletName();
        String uniqueID = input.getInternalWindowID().getUniqueID();
        RenderOutput output = new RenderOutput();
        if (WSRPAdminPortletDataImp.isOfferToProcess(portletAppName, portletName)) {
            response.setContentType("text/html");
            this.adminPortlet.getPortletObject().render(input, output);
            return output;
        }
        String producerID = portletAppName.substring(0, portletAppName.indexOf("@"));
        String portletHandle = portletAppName.substring(portletAppName.indexOf("@") + 1) + "/" + portletName;
        try {
            try {
                WindowState state = input.getWindowState();
                if (!state.equals((Object)WindowState.MINIMIZED)) {
                    PortletKey portletKey = this.getPortletKey(producerID, portletHandle);
                    if (this.getProducer(portletKey.getProducerId()) == null) {
                        return output;
                    }
                    WindowID windowID = input.getInternalWindowID();
                    String key = windowID.generateKey();
                    this.log.debug((Object)("key generated by windowID : " + key));
                    response.setContentType(input.getMarkup());
                    User user = this.getUser(request);
                    String userID = null;
                    if (user != null) {
                        userID = user.getUserID();
                        this.log.debug((Object)("use userID : " + userID));
                    }
                    WSRPPortlet portlet = null;
                    PortletDriver portletDriver = null;
                    PortletWindowSession portletWindowSession = null;
                    MarkupResponse mResponse = null;
                    UserSessionMgr userSession = null;
                    try {
                        userSession = this.getUserSession(request.getSession(), portletKey.getProducerId());
                        userSession.setUserID(userID);
                        portlet = this.getPortlet(portletKey, portletHandle);
                        String newPortletHandle = portletHandle + "/" + uniqueID;
                        portlet.getPortletContext().setPortletHandle(newPortletHandle);
                        portletDriver = this.consumer.getPortletDriverRegistry().getPortletDriver(portlet);
                        portletWindowSession = this.getWindowSession(portletKey, portlet, userSession, key);
                        WSRPMarkupRequest markupRequest = this.getMarkupRequest(request, portletWindowSession, input);
                        String path = null;
                        path = request.getRequestURI();
                        this.log.debug((Object)("User path info : " + path));
                        if (path == null) {
                            path = basePath;
                        }
                        path = path + "?";
                        String remoteUser = request.getRemoteUser();
                        if (remoteUser != null) {
                            path = path + "portal:ctx=" + request.getRemoteUser() + "&";
                        }
                        path = path + "portal:componentId=" + portletAppName + "/" + portletName;
                        this.log.debug((Object)("use base path : " + path));
                        path = input.getBaseURL();
                        mResponse = portletDriver.getMarkup(markupRequest, userSession, path);
                        if (mResponse != null) {
                            if (portletWindowSession != null) {
                                this.updateSessionContext(mResponse.getSessionContext(), portletWindowSession.getPortletSession());
                            }
                            this.processMarkupContext(mResponse.getMarkupContext(), response, output);
                        }
                        if (portletWindowSession != null) {
                            this.log.debug((Object)"Update cache");
                            portletWindowSession.updateMarkupCache(null);
                        }
                        if (input.getTitle() == null) return output;
                        output.setTitle(input.getTitle());
                        return output;
                    }
                    catch (Throwable t) {
                        this.log.error((Object)"WS Fault occured", t);
                        PrintWriter w = response.getWriter();
                        ((Writer)w).write("a WSRP Fault occured");
                        return output;
                    }
                }
                if (input.getTitle() != null) {
                    output.setTitle(input.getTitle());
                    return output;
                }
                LocalizedString locStr = this.consumer.getProducerRegistry().getProducer(producerID).getPortletDescription(portletHandle).getTitle();
                output.setTitle(Utils.getStringFromLocalizedString(locStr));
                return output;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    output.setContent(e.toString().getBytes("utf-8"));
                }
                catch (UnsupportedEncodingException unExc) {
                    output.setContent(unExc.toString().getBytes());
                }
            }
        }
        finally {
            return output;
        }
    }

    public void sendAttrs(HttpServletRequest request, HttpServletResponse response, Map<String, Object> attrs, String portletApplicationName) throws PortletContainerException {
    }

    private UserSessionMgr getUserSession(HttpSession httpSession, String producerID) throws WSRPException {
        UserSessionMgr userSession = (UserSessionMgr)httpSession.getAttribute(USER_SESSIONS_KEY + producerID);
        if (userSession == null) {
            this.log.debug((Object)"Create new UserSession");
            userSession = new UserSessionImpl(this.getProducer(producerID).getMarkupInterfaceEndpoint());
            httpSession.setAttribute(USER_SESSIONS_KEY + producerID, (Object)userSession);
        } else {
            this.log.debug((Object)"Use existing UserSession");
        }
        return userSession;
    }

    private PortletKey getPortletKey(String producerID, String portletHandle) throws PortletException {
        PortletKey portletKey = null;
        Iterator<WSRPPortlet> iter = this.consumer.getPortletRegistry().getAllPortlets();
        while (iter.hasNext()) {
            WSRPPortlet element = iter.next();
            if (!producerID.equals(element.getPortletKey().getProducerId()) || !portletHandle.equals(element.getPortletKey().getPortletHandle())) continue;
            portletKey = element.getPortletKey();
        }
        if (portletKey == null) {
            portletKey = new PortletKeyAdapter();
            portletKey.setProducerId(producerID);
            this.log.debug((Object)"user portlet key, producerID : ");
            portletKey.setPortletHandle(portletHandle);
        }
        return portletKey;
    }

    private Producer getProducer(String producerID) {
        this.log.debug((Object)("getProducer : " + producerID));
        Producer producer = this.consumer.getProducerRegistry().getProducer(producerID);
        return producer;
    }

    private User getUser(HttpServletRequest request) {
        User user = null;
        WindowInfosContainer scontainer = WindowInfosContainer.getInstance();
        if (scontainer != null) {
            String userKey = request.getRemoteUser();
            this.log.debug((Object)("getUser method with user key : " + userKey));
            user = this.consumer.getUserRegistry().getUser(userKey);
            if (user == null) {
                user = new UserAdapter();
                UserContext userContext = new UserContext();
                userContext.setProfile(this.fillUserProfile(request));
                userContext.setUserContextKey(userKey);
                user.setUserID(userKey);
                user.setUserContext(userContext);
                this.consumer.getUserRegistry().addUser(user);
            }
        }
        return user;
    }

    private UserProfile fillUserProfile(HttpServletRequest request) {
        UserProfile userProfile = null;
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        if (userInfo != null) {
            userProfile = new UserProfile();
            PersonName personName = new PersonName();
            Object nameObject = userInfo.get("name.given");
            if (nameObject == null) {
                personName.setGiven("unknow name");
            } else {
                personName.setGiven(nameObject.toString());
            }
            userProfile.setName(personName);
        }
        return userProfile;
    }

    private WSRPPortlet getPortlet(PortletKey portletKey, String parentHandle) throws WSRPException {
        WSRPPortlet portlet = null;
        if (portletKey != null && (portlet = this.consumer.getPortletRegistry().getPortlet(portletKey)) == null) {
            portlet = this.createPortlet(portletKey, parentHandle);
            this.consumer.getPortletRegistry().addPortlet(portlet);
        }
        return portlet;
    }

    private WSRPPortlet createPortlet(PortletKey portletKey, String parentHandle) {
        WSRPPortletAdapter portlet = new WSRPPortletAdapter(portletKey);
        PortletContext portletContext = new PortletContext();
        portletContext.setPortletHandle(portletKey.getPortletHandle());
        portlet.setPortletContext(portletContext);
        if (parentHandle != null) {
            portlet.setParent(parentHandle);
        } else {
            portlet.setParent(portletKey.getPortletHandle());
        }
        return portlet;
    }

    private PortletWindowSession getWindowSession(PortletKey portletKey, WSRPPortlet portlet, UserSessionMgr userSession, String windowID) throws WSRPException {
        if (userSession != null) {
            this.log.debug((Object)"get group session form user session");
            String groupID = this.getPortletDescription(portlet).getGroupID();
            groupID = groupID == null ? "default" : groupID;
            this.log.debug((Object)("group ID : " + groupID));
            GroupSessionMgr groupSession = userSession.getGroupSession(groupID);
            if (groupSession != null) {
                this.log.debug((Object)"get portlet session from group session");
                PortletSession portletSession = groupSession.getPortletSession(portletKey.getPortletHandle());
                this.log.debug((Object)("portlet handle : " + portletKey.getPortletHandle()));
                if (portletSession != null) {
                    PortletWindowSession windowSession = portletSession.getPortletWindowSession(windowID);
                    this.log.debug((Object)"success in extraction of the window session");
                    return windowSession;
                }
                this.log.error((Object)"portlet session was null");
                throw new WSRPException("InvalidSession");
            }
            this.log.error((Object)"group session was null");
            throw new WSRPException("InvalidSession");
        }
        this.log.error((Object)"user session was null");
        throw new WSRPException("InvalidSession");
    }

    private PortletDescription getPortletDescription(WSRPPortlet portlet) throws WSRPException {
        this.log.debug((Object)"getPortletDescription entered");
        String producerID = portlet.getPortletKey().getProducerId();
        Producer producer = this.getProducer(producerID);
        PortletDescription portletDesc = producer.getPortletDescription(portlet.getParent());
        if (portletDesc == null) {
            throw new WSRPException("unknownPortletDescription");
        }
        return portletDesc;
    }

    private WSRPInteractionRequest getInteractionRequest(PortletWindowSession portletWindowSession, HttpServletRequest request, ActionInput input) {
        this.log.debug((Object)"getInteractionRequest entered");
        WSRPInteractionRequestAdapter interactionRequest = new WSRPInteractionRequestAdapter();
        this.fillMarkupRequest(interactionRequest, request, portletWindowSession, (Input)input);
        interactionRequest.setNavigationalState(this.getNavigationalState(request, portletWindowSession, (Input)input));
        interactionRequest.setInteractionState(this.getInteractionState(request, portletWindowSession));
        interactionRequest.setFormParameters(this.getRenderParametersAsNamedString((Input)input));
        return interactionRequest;
    }

    private NamedString[] getRenderParametersAsNamedString(Input input) {
        Map params = input.getRenderParameters();
        return Utils.getNamedStringArrayParametersFromMap(params, true);
    }

    private String getInteractionState(HttpServletRequest request, PortletWindowSession portletWindowSession) {
        String is = request.getParameter("wsrp-interactionState");
        this.log.debug((Object)("user interaction state : " + is));
        return is;
    }

    private void fillMarkupRequest(WSRPBaseRequestAdapter markupRequest, HttpServletRequest request, PortletWindowSession portletWindowSession, Input input) {
        markupRequest.setCharacterEncodingSet(characterEncodings);
        markupRequest.setClientData(this.getClientData());
        List locales = input.getLocales();
        ArrayList<String> localesStrings = new ArrayList<String>();
        if (locales != null) {
            for (Locale locale : locales) {
                localesStrings.add(locale.toString());
            }
            markupRequest.setLocales(localesStrings.toArray(new String[input.getLocales().size()]));
        } else {
            markupRequest.setLocales(SUPPORTED_LOCALES);
        }
        Collection supportedContent = this.pcConf.getSupportedContent();
        String[] mimeTypes = supportedContent.toArray(new String[supportedContent.size()]);
        markupRequest.setMimeTypes(mimeTypes);
        markupRequest.setMode(Modes.getWSRPModeString(input.getPortletMode()));
        markupRequest.setModes(null);
        markupRequest.setUserAuthentication("none");
        markupRequest.setWindowState(WindowStates.getWSRPStateString(input.getWindowState()));
        markupRequest.setWindowStates(null);
        if (portletWindowSession.getPortletSession().getSessionContext() != null) {
            markupRequest.setSessionID(portletWindowSession.getPortletSession().getSessionContext().getSessionID());
        }
        markupRequest.setPortletInstanceKey(input.getInternalWindowID().generateKey());
    }

    private ClientData getClientData() {
        ClientData clientData = new ClientData();
        clientData.setUserAgent(userAgent);
        return clientData;
    }

    private String getNavigationalState(HttpServletRequest request, PortletWindowSession portletWindowSession, Input input) {
        if (input != null && input.getRenderParameters() != null) {
            String[] navigationalState = (String[])input.getRenderParameters().get("wsrp-navigationalState");
            if (navigationalState != null && navigationalState.length != 0) {
                this.log.debug((Object)("user navigational state : " + navigationalState[0]));
                portletWindowSession.setNavigationalState(navigationalState[0]);
            } else {
                this.log.debug((Object)"Navigational state is null or empty");
            }
        } else {
            this.log.debug((Object)"Input input is null or input.getRenderParameters() is null");
        }
        return portletWindowSession.getNavigationalState();
    }

    private void updateSessionContext(SessionContext sessionContext, PortletSession portletSession) {
        if (sessionContext != null) {
            this.log.debug((Object)"update session context");
            if (portletSession != null) {
                portletSession.setSessionContext(sessionContext);
            }
        }
    }

    private void updatePortletContext(PortletContext portletContext, WSRPPortlet portlet) throws WSRPException {
        if (portletContext != null && portlet != null) {
            this.log.debug((Object)"update portlet context");
            String newPortletHandle = portletContext.getPortletHandle();
            PortletKey portletKey = portlet.getPortletKey();
            if (newPortletHandle != null && !newPortletHandle.equals(portletKey.getPortletHandle())) {
                this.log.debug((Object)("portlet was cloned, new handle : " + newPortletHandle));
                String producerID = portletKey.getProducerId();
                PortletKeyAdapter newPortletKey = new PortletKeyAdapter();
                portletKey.setPortletHandle(newPortletHandle);
                portletKey.setPortletHandle(producerID);
                portlet = this.createPortlet(newPortletKey, portlet.getParent());
                this.consumer.getPortletRegistry().addPortlet(portlet);
            }
            portlet.setPortletContext(portletContext);
        }
    }

    private WSRPMarkupRequest getMarkupRequest(HttpServletRequest request, PortletWindowSession portletWindowSession, RenderInput input) {
        WSRPMarkupRequestAdapter markupRequest = new WSRPMarkupRequestAdapter();
        this.fillMarkupRequest(markupRequest, request, portletWindowSession, (Input)input);
        markupRequest.setNavigationalState(this.getNavigationalState(request, portletWindowSession, (Input)input));
        markupRequest.setCachedMarkup(portletWindowSession.getCachedMarkup());
        return markupRequest;
    }

    private String processMarkupContext(MarkupContext markupContext, HttpServletResponse response, RenderOutput output) throws WSRPException {
        this.log.debug((Object)"process returned markup");
        String markup = null;
        byte[] binaryMarkup = null;
        if (markupContext != null && output != null) {
            String title = markupContext.getPreferredTitle();
            if (title != null) {
                this.log.debug((Object)("user title : " + title));
                output.setTitle(title);
            }
            output.setContentType(markupContext.getMimeType());
            markup = markupContext.getMarkupString();
            binaryMarkup = markupContext.getMarkupBinary();
            if (markup != null) {
                this.log.debug((Object)"markup non null");
                try {
                    output.setContent(markup.getBytes("utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    output.setContent(markup.getBytes());
                }
            }
            if (binaryMarkup != null) {
                output.setContent(binaryMarkup);
            }
        }
        return markup;
    }

    public final Collection<String> getPortletAppNames() {
        this.log.debug((Object)"getPortletAppNames() entered");
        HashSet<String> result = new HashSet<String>();
        result.add("@WSRP1App");
        String producerId = null;
        String portletHandle = null;
        ProducerRegistry pregistry = this.consumer.getProducerRegistry();
        Iterator<Producer> i = pregistry.getAllProducers();
        ServiceDescription desc = null;
        while (i.hasNext()) {
            Producer producer = i.next();
            try {
                desc = producer.getServiceDescription();
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
            producerId = producer.getID();
            PortletDescription[] portletDescriptions = desc.getOfferedPortlets();
            if (portletDescriptions == null) continue;
            for (int k = 0; k < portletDescriptions.length; ++k) {
                PortletDescription portletDescription = portletDescriptions[k];
                portletHandle = portletDescription.getPortletHandle();
                if (StringUtils.split((String)portletHandle, (String)"/").length == 1) {
                    portletHandle = "unnamed/" + portletHandle;
                }
                String newPortletHandle = producerId + "@" + portletHandle;
                String[] ss = StringUtils.split((String)newPortletHandle, (String)"/");
                String portletAppName = ss[0];
                result.add(portletAppName);
            }
        }
        return result;
    }
}

