/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.producer.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.IdentifierUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wsrp.exceptions.Exception2Fault;
import org.exoplatform.services.wsrp.exceptions.WSRPException;
import org.exoplatform.services.wsrp.producer.PersistentStateManager;
import org.exoplatform.services.wsrp.producer.PortletContainerProxy;
import org.exoplatform.services.wsrp.producer.PortletManagementOperationsInterface;
import org.exoplatform.services.wsrp.producer.impl.utils.Utils;
import org.exoplatform.services.wsrp.type.DestroyFailed;
import org.exoplatform.services.wsrp.type.DestroyPortletsResponse;
import org.exoplatform.services.wsrp.type.PortletContext;
import org.exoplatform.services.wsrp.type.PortletDescription;
import org.exoplatform.services.wsrp.type.PortletDescriptionResponse;
import org.exoplatform.services.wsrp.type.PortletPropertyDescriptionResponse;
import org.exoplatform.services.wsrp.type.Property;
import org.exoplatform.services.wsrp.type.PropertyList;
import org.exoplatform.services.wsrp.type.RegistrationContext;
import org.exoplatform.services.wsrp.type.ResourceList;
import org.exoplatform.services.wsrp.type.UserContext;

public class PortletManagementOperationsInterfaceImpl
implements PortletManagementOperationsInterface {
    private PortletContainerProxy container;
    private Log log;
    private PersistentStateManager stateManager;

    public PortletManagementOperationsInterfaceImpl(PersistentStateManager stateManager, PortletContainerProxy container) {
        this.container = container;
        this.stateManager = stateManager;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp");
    }

    public PortletContext clonePortlet(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("Clone a portlet for the registered consumer : " + registrationHandle));
        Utils.testRegistration(registrationContext, this.stateManager);
        String portletHandle = portletContext.getPortletHandle();
        String newPortletHandle = null;
        try {
            if (this.stateManager.isConsumerConfiguredPortlet(portletHandle, registrationContext)) {
                this.log.debug((Object)("Clone a Consumer Configured Portlet with handle : " + portletHandle));
                PropertyList list = this.getPortletProperties(registrationContext, portletContext, userContext, null);
                newPortletHandle = this.createNewPortletHandle(portletHandle);
                this.stateManager.addConsumerConfiguredPortletHandle(newPortletHandle, registrationContext);
                portletContext.setPortletHandle(newPortletHandle);
                this.setPortletProperties(registrationContext, portletContext, userContext, list);
            } else {
                this.log.debug((Object)("Clone a Producer Offered Portlet with handle : " + portletHandle));
                if (!this.container.isPortletOffered(portletHandle)) {
                    this.log.debug((Object)"The latter handle is not offered by the Producer");
                    Exception2Fault.handleException(new WSRPException("InvalidHandle"));
                }
                newPortletHandle = this.createNewPortletHandle(portletHandle);
                this.stateManager.addConsumerConfiguredPortletHandle(newPortletHandle, registrationContext);
            }
        }
        catch (WSRPException e) {
            this.log.error((Object)"Can not clone portlet", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        this.log.debug((Object)("New portlet handle : " + newPortletHandle));
        PortletContext clonedPortletContext = new PortletContext();
        clonedPortletContext.setPortletHandle(newPortletHandle);
        return clonedPortletContext;
    }

    public DestroyPortletsResponse destroyPortlets(RegistrationContext registrationContext, String[] portletHandles) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("Destroy portlet for registration handle " + registrationHandle));
        Utils.testRegistration(registrationContext, this.stateManager);
        ArrayList<DestroyFailed> fails = new ArrayList<DestroyFailed>();
        for (int i = 0; i < portletHandles.length; ++i) {
            String portletHandle = portletHandles[i];
            try {
                if (this.stateManager.isConsumerConfiguredPortlet(portletHandle, registrationContext)) {
                    this.log.debug((Object)("Destroy a consumer configured portlet : " + portletHandle));
                    this.stateManager.removeConsumerConfiguredPortletHandle(portletHandle, registrationContext);
                    continue;
                }
                this.log.debug((Object)("Can't destroy a portlet that did not exist : " + portletHandle));
                DestroyFailed destroyFailed = new DestroyFailed();
                destroyFailed.setPortletHandle(portletHandle);
                destroyFailed.setReason("Can't destroy a portlet that did not exist");
                fails.add(destroyFailed);
                continue;
            }
            catch (WSRPException e) {
                Exception2Fault.handleException(e);
            }
        }
        DestroyPortletsResponse response = new DestroyPortletsResponse();
        DestroyFailed[] array = fails.toArray(new DestroyFailed[fails.size()]);
        if (array != null) {
            response.setDestroyFailed(array);
        }
        return response;
    }

    public PortletDescriptionResponse getPortletDescription(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, String[] desiredLocales) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("Get portlet description for registration handle " + registrationHandle));
        Utils.testRegistration(registrationContext, this.stateManager);
        String portletHandle = portletContext.getPortletHandle();
        try {
            if (!this.stateManager.isConsumerConfiguredPortlet(portletHandle, registrationContext)) {
                this.log.debug((Object)("This portlet handle " + portletHandle + " is not valid in the scope of that registration "));
                Exception2Fault.handleException(new WSRPException("AccessDenied"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        PortletDescription pD = this.container.getPortletDescription(portletHandle, desiredLocales);
        ResourceList resourceList = this.container.getResourceList(desiredLocales);
        PortletDescriptionResponse response = new PortletDescriptionResponse();
        response.setPortletDescription(pD);
        response.setResourceList(resourceList);
        return response;
    }

    public PortletContext setPortletProperties(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, PropertyList propertyList) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("Set portlet properties for registration handle " + registrationHandle));
        Utils.testRegistration(registrationContext, this.stateManager);
        String portletHandle = portletContext.getPortletHandle();
        try {
            if (!this.stateManager.isConsumerConfiguredPortlet(portletHandle, registrationContext)) {
                this.log.debug((Object)("This portlet handle " + portletHandle + " is not valid in the scope of that registration "));
                Exception2Fault.handleException(new WSRPException("AccessDenied"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        String userID = userContext.getUserContextKey();
        try {
            this.container.setPortletProperties(portletHandle, userID, propertyList);
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        return portletContext;
    }

    public PropertyList getPortletProperties(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, String[] names) throws RemoteException {
        String registrationHandle = registrationContext.getRegistrationHandle();
        this.log.debug((Object)("get portlet properties for registration handle " + registrationHandle));
        Utils.testRegistration(registrationContext, this.stateManager);
        String portletHandle = portletContext.getPortletHandle();
        try {
            if (!this.stateManager.isConsumerConfiguredPortlet(portletHandle, registrationContext)) {
                this.log.debug((Object)("This portlet handle " + portletHandle + " is not valid in the scope of that registration "));
                Exception2Fault.handleException(new WSRPException("AccessDenied"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        String userID = userContext.getUserContextKey();
        Map<String, String[]> properties = null;
        try {
            properties = this.container.getPortletProperties(portletHandle, userID);
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        ArrayList<Property> properties2return = new ArrayList<Property>();
        Set<String> keys = properties.keySet();
        for (String key : keys) {
            if (names != null && !this.arrayContainsKey(names, key)) continue;
            String[] values = properties.get(key);
            Property prop = new Property();
            prop.setName(key);
            prop.setStringValue(values[0]);
            properties2return.add(prop);
        }
        PropertyList list = new PropertyList();
        Property[] propertiesResult = properties2return.toArray(new Property[properties2return.size()]);
        list.setProperties(propertiesResult);
        list.setResetProperties(null);
        return list;
    }

    public PortletPropertyDescriptionResponse getPortletPropertyDescription(RegistrationContext registrationContext, PortletContext portletContext, UserContext userContext, String[] desiredLocales) throws RemoteException {
        return new PortletPropertyDescriptionResponse();
    }

    private boolean arrayContainsKey(String[] array, String key) {
        for (int i = 0; i < array.length; ++i) {
            String s = array[i];
            if (!s.equals(key)) continue;
            return true;
        }
        return false;
    }

    private String createNewPortletHandle(String portletHandle) {
        String[] keys = StringUtils.split((String)portletHandle, (String)"/");
        String newPortletHandle = keys[0] + "/" + keys[1] + "/" + IdentifierUtil.generateUUID((Object)portletHandle);
        return newPortletHandle;
    }
}

