/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.consumer.impl;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wsrp.consumer.ConsumerEnvironment;
import org.exoplatform.services.wsrp.consumer.GroupSessionMgr;
import org.exoplatform.services.wsrp.consumer.PortletDriver;
import org.exoplatform.services.wsrp.consumer.Producer;
import org.exoplatform.services.wsrp.consumer.URLRewriter;
import org.exoplatform.services.wsrp.consumer.URLTemplateComposer;
import org.exoplatform.services.wsrp.consumer.User;
import org.exoplatform.services.wsrp.consumer.UserSessionMgr;
import org.exoplatform.services.wsrp.consumer.WSRPBaseRequest;
import org.exoplatform.services.wsrp.consumer.WSRPInteractionRequest;
import org.exoplatform.services.wsrp.consumer.WSRPMarkupRequest;
import org.exoplatform.services.wsrp.consumer.WSRPPortlet;
import org.exoplatform.services.wsrp.exceptions.WSRPException;
import org.exoplatform.services.wsrp.intf.WSRP_v1_Markup_PortType;
import org.exoplatform.services.wsrp.intf.WSRP_v1_PortletManagement_PortType;
import org.exoplatform.services.wsrp.type.BlockingInteractionRequest;
import org.exoplatform.services.wsrp.type.BlockingInteractionResponse;
import org.exoplatform.services.wsrp.type.ClientData;
import org.exoplatform.services.wsrp.type.ClonePortletRequest;
import org.exoplatform.services.wsrp.type.CookieProtocol;
import org.exoplatform.services.wsrp.type.DestroyPortletsRequest;
import org.exoplatform.services.wsrp.type.DestroyPortletsResponse;
import org.exoplatform.services.wsrp.type.GetPortletPropertiesRequest;
import org.exoplatform.services.wsrp.type.InitCookieRequest;
import org.exoplatform.services.wsrp.type.InteractionParams;
import org.exoplatform.services.wsrp.type.InvalidCookieFault;
import org.exoplatform.services.wsrp.type.MarkupContext;
import org.exoplatform.services.wsrp.type.MarkupParams;
import org.exoplatform.services.wsrp.type.MarkupRequest;
import org.exoplatform.services.wsrp.type.MarkupResponse;
import org.exoplatform.services.wsrp.type.PortletContext;
import org.exoplatform.services.wsrp.type.PortletDescription;
import org.exoplatform.services.wsrp.type.PortletDescriptionRequest;
import org.exoplatform.services.wsrp.type.PortletDescriptionResponse;
import org.exoplatform.services.wsrp.type.PortletPropertyDescriptionRequest;
import org.exoplatform.services.wsrp.type.PortletPropertyDescriptionResponse;
import org.exoplatform.services.wsrp.type.PropertyList;
import org.exoplatform.services.wsrp.type.RegistrationContext;
import org.exoplatform.services.wsrp.type.ReleaseSessionsRequest;
import org.exoplatform.services.wsrp.type.ReturnAny;
import org.exoplatform.services.wsrp.type.RuntimeContext;
import org.exoplatform.services.wsrp.type.ServiceDescription;
import org.exoplatform.services.wsrp.type.SetPortletPropertiesRequest;
import org.exoplatform.services.wsrp.type.StateChange;
import org.exoplatform.services.wsrp.type.Templates;
import org.exoplatform.services.wsrp.type.UserContext;

public class PortletDriverImpl
implements PortletDriver {
    private WSRPPortlet portlet = null;
    private WSRP_v1_Markup_PortType markupPort = null;
    private WSRP_v1_PortletManagement_PortType portletPort = null;
    private ConsumerEnvironment consumerEnv = null;
    private Producer producer = null;
    private CookieProtocol initCookie = CookieProtocol.none;
    private Log log;

    public PortletDriverImpl(ExoContainer cont, WSRPPortlet portlet) throws WSRPException {
        this.consumerEnv = (ConsumerEnvironment)cont.getComponentInstanceOfType(ConsumerEnvironment.class);
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp.consumer");
        this.portlet = portlet;
        this.producer = this.consumerEnv.getProducerRegistry().getProducer(portlet.getPortletKey().getProducerId());
        this.portletPort = this.producer.getPortletManagementInterface();
        ServiceDescription serviceDescription = this.producer.getServiceDescription(false);
        if (serviceDescription != null) {
            this.initCookie = serviceDescription.getRequiresInitCookie();
            this.log.debug((Object)("Requires cookie initialization : " + this.initCookie.getValue()));
            if (this.initCookie == null) {
                this.initCookie = CookieProtocol.none;
            }
        }
    }

    public WSRPPortlet getPortlet() {
        return this.portlet;
    }

    private void resetInitCookie(UserSessionMgr userSession) throws WSRPException {
        this.log.debug((Object)"reset cookies");
        if (this.initCookie.getValue().equalsIgnoreCase("none")) {
            userSession.setInitCookieDone(false);
        } else if (this.initCookie.getValue().equalsIgnoreCase("perGroup")) {
            PortletDescription portletDescription = null;
            portletDescription = this.producer.getPortletDescription(this.getPortlet().getParent());
            String groupID = null;
            if (portletDescription != null && (groupID = portletDescription.getGroupID()) != null) {
                GroupSessionMgr groupSession = userSession.getGroupSession(groupID);
                groupSession.setInitCookieDone(false);
            }
        }
    }

    private void checkInitCookie(UserSessionMgr userSession) throws WSRPException {
        this.log.debug((Object)("init cookies : " + this.initCookie.getValue()));
        if (this.initCookie.getValue().equalsIgnoreCase("perUser")) {
            this.log.debug((Object)"cookies management per user");
            if (!userSession.isInitCookieDone()) {
                this.log.debug((Object)("Init cookies : " + userSession));
                this.markupPort = userSession.getWSRPMarkupService();
                userSession.setInitCookieRequired(true);
                this.initCookie();
                userSession.setInitCookieDone(true);
            }
        } else if (this.initCookie.getValue().equalsIgnoreCase("perGroup")) {
            this.log.debug((Object)"cookies management per group");
            PortletDescription portletDescription = this.producer.getPortletDescription(this.getPortlet().getParent());
            String groupID = null;
            if (portletDescription != null) {
                groupID = portletDescription.getGroupID();
                this.log.debug((Object)("Group Id used for cookies management : " + groupID));
            }
            if (groupID != null) {
                GroupSessionMgr groupSession = userSession.getGroupSession(groupID);
                this.markupPort = groupSession.getWSRPMarkupService();
                if (!groupSession.isInitCookieDone()) {
                    this.log.debug((Object)("Group session in init cookies : " + groupSession));
                    groupSession.setInitCookieRequired(true);
                    this.initCookie();
                    groupSession.setInitCookieDone(true);
                }
            }
        } else {
            this.markupPort = userSession.getWSRPMarkupService();
        }
    }

    private MarkupParams getMarkupParams(WSRPBaseRequest request) {
        MarkupParams markupParams = new MarkupParams();
        ClientData clientData = new ClientData();
        if (this.producer.getRegistrationData() != null) {
            clientData.setUserAgent(this.producer.getRegistrationData().getConsumerAgent());
        }
        markupParams.setClientData(clientData);
        markupParams.setSecureClientCommunication(false);
        markupParams.setLocales(this.consumerEnv.getSupportedLocales());
        markupParams.setMimeTypes(this.consumerEnv.getMimeTypes());
        markupParams.setMode(request.getMode());
        markupParams.setWindowState(request.getWindowState());
        markupParams.setNavigationalState(request.getNavigationalState());
        markupParams.setMarkupCharacterSets(this.consumerEnv.getCharacterEncodingSet());
        markupParams.setValidateTag(null);
        markupParams.setValidNewModes(this.consumerEnv.getSupportedModes());
        markupParams.setValidNewWindowStates(this.consumerEnv.getSupportedWindowStates());
        markupParams.setExtensions(null);
        return markupParams;
    }

    private RuntimeContext getRuntimeContext(WSRPBaseRequest request, String baseURL) throws WSRPException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("PortletDriverImpl.getRuntimeContext() baseURL = " + baseURL));
        }
        RuntimeContext runtimeContext = new RuntimeContext();
        runtimeContext.setUserAuthentication(this.consumerEnv.getUserAuthentication());
        runtimeContext.setPortletInstanceKey(request.getPortletInstanceKey());
        URLTemplateComposer templateComposer = this.consumerEnv.getTemplateComposer();
        if (templateComposer != null) {
            runtimeContext.setNamespacePrefix(templateComposer.getNamespacePrefix());
            Boolean doesUrlTemplateProcess = null;
            Boolean getTemplatesStoredInSession = null;
            PortletDescription desc = this.producer.getPortletDescription(this.getPortlet().getParent());
            if (desc != null) {
                doesUrlTemplateProcess = desc.getDoesUrlTemplateProcessing();
                getTemplatesStoredInSession = desc.getTemplatesStoredInSession();
                if (getTemplatesStoredInSession.booleanValue()) {
                    // empty if block
                }
                Templates templates = null;
                if (doesUrlTemplateProcess != null && doesUrlTemplateProcess.booleanValue()) {
                    templates = new Templates();
                    if (baseURL != null) {
                        templates.setBlockingActionTemplate(templateComposer.createBlockingActionTemplate(baseURL));
                        templates.setRenderTemplate(templateComposer.createRenderTemplate(baseURL));
                        templates.setDefaultTemplate(templateComposer.createDefaultTemplate(baseURL));
                        templates.setResourceTemplate(templateComposer.createResourceTemplate(baseURL));
                        templates.setSecureBlockingActionTemplate(templateComposer.createSecureBlockingActionTemplate(baseURL));
                        templates.setSecureRenderTemplate(templateComposer.createSecureRenderTemplate(baseURL));
                        templates.setSecureDefaultTemplate(templateComposer.createSecureDefaultTemplate(baseURL));
                        templates.setSecureResourceTemplate(templateComposer.createSecureResourceTemplate(baseURL));
                    }
                }
                runtimeContext.setTemplates(templates);
            }
        }
        runtimeContext.setSessionID(request.getSessionID());
        runtimeContext.setExtensions(null);
        return runtimeContext;
    }

    private UserContext getUserContext(UserSessionMgr userSession) {
        User user;
        UserContext userContext = null;
        if (userSession.getUserID() != null && (user = this.consumerEnv.getUserRegistry().getUser(userSession.getUserID())) != null) {
            userContext = user.getUserContext();
        }
        if (userContext == null) {
            userContext = new UserContext();
            userContext.setUserContextKey("dummyUserContextKey");
        }
        return userContext;
    }

    private InteractionParams getInteractionParams(WSRPInteractionRequest actionRequest) {
        InteractionParams interactionParams = new InteractionParams();
        interactionParams.setPortletStateChange(this.consumerEnv.getPortletStateChange());
        if (!this.portlet.isConsumerConfigured() && interactionParams.getPortletStateChange().toString().equalsIgnoreCase("readWrite")) {
            interactionParams.setPortletStateChange(StateChange.cloneBeforeWrite);
        }
        interactionParams.setInteractionState(actionRequest.getInteractionState());
        interactionParams.setFormParameters(actionRequest.getFormParameters());
        interactionParams.setUploadContexts(null);
        interactionParams.setExtensions(null);
        return interactionParams;
    }

    public MarkupResponse getMarkup(WSRPMarkupRequest markupRequest, UserSessionMgr userSession, String path) throws WSRPException {
        this.checkInitCookie(userSession);
        MarkupResponse response = null;
        try {
            MarkupContext markupContext = markupRequest.getCachedMarkup();
            if (markupContext == null) {
                UserContext userCtx;
                this.log.debug((Object)"get non cached markup");
                MarkupRequest request = new MarkupRequest();
                request.setPortletContext(this.getPortlet().getPortletContext());
                request.setMarkupParams(this.getMarkupParams(markupRequest));
                request.setRuntimeContext(this.getRuntimeContext(markupRequest, path));
                RegistrationContext regCtx = this.producer.getRegistrationContext();
                if (regCtx != null) {
                    this.log.debug((Object)("Registration context used in getMarkup : " + regCtx.getRegistrationHandle()));
                    request.setRegistrationContext(regCtx);
                }
                if ((userCtx = this.getUserContext(userSession)) != null) {
                    request.setUserContext(this.getUserContext(userSession));
                }
                response = this.markupPort.getMarkup(request);
            } else {
                this.log.debug((Object)"get cached markup");
                response = new MarkupResponse();
                response.setMarkupContext(markupContext);
            }
            Boolean requiresRewriting = response.getMarkupContext().getRequiresUrlRewriting();
            this.log.debug((Object)("response.getMarkupContext().getMarkupString() = " + response.getMarkupContext().getMarkupString()));
            this.log.debug((Object)("requires URL rewriting : " + requiresRewriting));
            if (!Boolean.TRUE.equals(requiresRewriting)) {
                URLRewriter urlRewriter = this.consumerEnv.getURLRewriter();
                String rewrittenMarkup = urlRewriter.rewriteURLs(path, response.getMarkupContext().getMarkupString());
                if (rewrittenMarkup != null) {
                    response.getMarkupContext().setMarkupString(rewrittenMarkup);
                }
                this.log.debug((Object)("rewrittenMarkup = " + rewrittenMarkup));
            }
        }
        catch (InvalidCookieFault cookieFault) {
            this.log.error((Object)"Problem with cookies ", (Throwable)((Object)cookieFault));
            this.resetInitCookie(userSession);
            this.getMarkup(markupRequest, userSession, path);
        }
        catch (RemoteException wsrpFault) {
            this.log.error((Object)"Remote exception ", (Throwable)wsrpFault);
            throw new WSRPException("OperationFailed", wsrpFault);
        }
        return response;
    }

    public BlockingInteractionResponse performBlockingInteraction(WSRPInteractionRequest actionRequest, UserSessionMgr userSession, String path) throws WSRPException {
        this.checkInitCookie(userSession);
        BlockingInteractionResponse response = null;
        try {
            UserContext userCtx;
            BlockingInteractionRequest request = new BlockingInteractionRequest();
            request.setPortletContext(this.getPortlet().getPortletContext());
            request.setInteractionParams(this.getInteractionParams(actionRequest));
            request.setMarkupParams(this.getMarkupParams(actionRequest));
            request.setRuntimeContext(this.getRuntimeContext(actionRequest, path));
            RegistrationContext regCtx = this.producer.getRegistrationContext();
            if (regCtx != null) {
                request.setRegistrationContext(regCtx);
            }
            if ((userCtx = this.getUserContext(userSession)) != null) {
                request.setUserContext(userCtx);
            }
            response = this.markupPort.performBlockingInteraction(request);
        }
        catch (InvalidCookieFault cookieFault) {
            this.resetInitCookie(userSession);
            this.performBlockingInteraction(actionRequest, userSession, path);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        return response;
    }

    public PortletContext clonePortlet(UserSessionMgr userSession) throws WSRPException {
        UserContext userCtx;
        ClonePortletRequest request = new ClonePortletRequest();
        request.setPortletContext(this.getPortlet().getPortletContext());
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        if ((userCtx = this.getUserContext(userSession)) != null) {
            request.setUserContext(userCtx);
        }
        PortletContext response = null;
        try {
            response = this.portletPort.clonePortlet(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        return response;
    }

    public DestroyPortletsResponse destroyPortlets(String[] portletHandles, UserSessionMgr userSession) throws WSRPException {
        DestroyPortletsRequest request = new DestroyPortletsRequest();
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        request.setPortletHandles(portletHandles);
        DestroyPortletsResponse response = null;
        try {
            response = this.portletPort.destroyPortlets(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        return response;
    }

    public ReturnAny releaseSessions(String[] sessionIDs, UserSessionMgr userSession) throws WSRPException {
        this.checkInitCookie(userSession);
        ReleaseSessionsRequest request = new ReleaseSessionsRequest();
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        request.setSessionIDs(sessionIDs);
        ReturnAny response = null;
        try {
            response = this.markupPort.releaseSessions(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        return response;
    }

    public void initCookie() throws WSRPException {
        InitCookieRequest request = new InitCookieRequest();
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            this.log.debug((Object)("Registration context use d in initCookie : " + regCtx.getRegistrationHandle()));
            request.setRegistrationContext(regCtx);
        }
        try {
            this.log.debug((Object)"Call initCookie on Markup Port");
            this.markupPort.initCookie(request);
        }
        catch (RemoteException wsrpFault) {
            this.log.error((Object)"Problem while initializing cookies", (Throwable)wsrpFault);
            throw new WSRPException("Problem while initializing cookies", wsrpFault);
        }
    }

    public PortletDescriptionResponse getPortletDescription(UserSessionMgr userSession, String[] desiredLocales) throws WSRPException {
        PortletDescriptionRequest request = new PortletDescriptionRequest();
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        request.setPortletContext(this.getPortlet().getPortletContext());
        UserContext userCtx = this.getUserContext(userSession);
        if (userCtx != null) {
            request.setUserContext(userCtx);
        }
        request.setDesiredLocales(desiredLocales);
        PortletDescriptionResponse response = null;
        try {
            response = this.portletPort.getPortletDescription(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        return response;
    }

    public PortletPropertyDescriptionResponse getPortletPropertyDescription(UserSessionMgr userSession) throws WSRPException {
        UserContext userCtx;
        PortletPropertyDescriptionRequest request = new PortletPropertyDescriptionRequest();
        request.setPortletContext(this.getPortlet().getPortletContext());
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        if ((userCtx = this.getUserContext(userSession)) != null) {
            request.setUserContext(userCtx);
        }
        request.setDesiredLocales(this.consumerEnv.getSupportedLocales());
        PortletPropertyDescriptionResponse response = null;
        try {
            response = this.portletPort.getPortletPropertyDescription(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        return response;
    }

    public PropertyList getPortletProperties(String[] names, UserSessionMgr userSession) throws WSRPException {
        UserContext userCtx;
        GetPortletPropertiesRequest request = new GetPortletPropertiesRequest();
        request.setPortletContext(this.getPortlet().getPortletContext());
        request.setNames(names);
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        if ((userCtx = this.getUserContext(userSession)) != null) {
            request.setUserContext(userCtx);
        }
        PropertyList response = null;
        try {
            response = this.portletPort.getPortletProperties(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        return response;
    }

    public PortletContext setPortletProperties(PropertyList properties, UserSessionMgr userSession) throws WSRPException {
        UserContext userCtx;
        SetPortletPropertiesRequest request = new SetPortletPropertiesRequest();
        request.setPortletContext(this.getPortlet().getPortletContext());
        RegistrationContext regCtx = this.producer.getRegistrationContext();
        if (regCtx != null) {
            request.setRegistrationContext(regCtx);
        }
        if ((userCtx = this.getUserContext(userSession)) != null) {
            request.setUserContext(userCtx);
        }
        request.setPropertyList(properties);
        PortletContext response = null;
        try {
            response = this.portletPort.setPortletProperties(request);
        }
        catch (RemoteException wsrpFault) {
            throw new WSRPException();
        }
        return response;
    }
}

