/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.consumer.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.wsrp.consumer.URLGenerator;
import org.exoplatform.services.wsrp.utils.Modes;
import org.exoplatform.services.wsrp.utils.WindowStates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLGeneratorImpl
implements URLGenerator {
    @Override
    public String getBlockingActionURL(String baseURL, Map<String, String> params) {
        return this.getURL(baseURL, params);
    }

    @Override
    public String getRenderURL(String baseURL, Map<String, String> params) {
        return this.getURL(baseURL, params);
    }

    @Override
    public String getResourceURL(String baseURL, Map<String, String> params) {
        return this.getURL(baseURL, params);
    }

    private String getURL(String baseURL, Map<String, String> params) {
        StringBuffer sB = new StringBuffer();
        sB.append(baseURL);
        return this.computeParameters(sB, params);
    }

    @Override
    public String getNamespacedToken(String token) {
        return token;
    }

    private String computeParameters(StringBuffer sB, Map<String, String> parameters) {
        Set<String> names = parameters.keySet();
        for (String name : names) {
            if (name.equalsIgnoreCase("wsrp-portletHandle")) continue;
            String value = parameters.get(name);
            sB.append("&");
            sB.append(this.encode(this.replaceName(name)));
            sB.append("=");
            sB.append(this.encode(this.replaceValue(name, value)));
        }
        return sB.toString();
    }

    private String replaceName(String name) {
        if ("wsrp-mode".equals(name)) {
            return "portal:portletMode";
        }
        if ("wsrp-windowState".equals(name)) {
            return "portal:windowState";
        }
        if ("wsrp-portletHandle".equals(name)) {
            return "portal:componentId";
        }
        if ("wsrp-secureURL".equals(name)) {
            return "portal:isSecure";
        }
        if ("wsrp-urlType".equals(name)) {
            return "portal:type";
        }
        return name;
    }

    private String replaceValue(String name, String value) {
        if ("wsrp-urlType".equals(name) && "blockingAction".equals(value)) {
            return "action";
        }
        if ("wsrp-mode".equals(name)) {
            return Modes.delAllPrefixesWSRP(value);
        }
        if ("wsrp-windowState".equals(name)) {
            return WindowStates.delAllPrefixesWSRP(value);
        }
        return value;
    }

    private String encode(String s) {
        try {
            return URLEncoder.encode(s, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }
}

