/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.producer.impl;

import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.IdentifierUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wsrp.exceptions.Exception2Fault;
import org.exoplatform.services.wsrp.exceptions.WSRPException;
import org.exoplatform.services.wsrp.producer.PersistentStateManager;
import org.exoplatform.services.wsrp.producer.RegistrationOperationsInterface;
import org.exoplatform.services.wsrp.type.RegistrationContext;
import org.exoplatform.services.wsrp.type.RegistrationData;
import org.exoplatform.services.wsrp.type.RegistrationState;
import org.exoplatform.services.wsrp.type.ReturnAny;

public class RegistrationOperationsInterfaceImp
implements RegistrationOperationsInterface {
    private Log log;
    private PersistentStateManager stateManager;

    public RegistrationOperationsInterfaceImp(PersistentStateManager stateManager) {
        this.stateManager = stateManager;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp");
    }

    public RegistrationContext register(RegistrationData data) throws RemoteException {
        data.setConsumerAgent("exoplatform.1.0");
        this.log.debug((Object)"Register method entered");
        String registrationHandle = null;
        byte[] registrationState = null;
        try {
            this.validateRegistrationDatas(data);
            registrationHandle = IdentifierUtil.generateUUID((Object)data);
            registrationState = this.stateManager.register(registrationHandle, data);
        }
        catch (WSRPException e) {
            this.log.debug((Object)"Registration failed", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        RegistrationContext rC = new RegistrationContext();
        rC.setRegistrationHandle(registrationHandle);
        rC.setRegistrationState(registrationState);
        this.log.debug((Object)("Registration done with handle : " + registrationHandle));
        return rC;
    }

    public RegistrationState modifyRegistration(RegistrationContext registrationContext, RegistrationData data) throws RemoteException {
        this.log.debug((Object)"Modify registrion method entered");
        try {
            if (!this.stateManager.isRegistered(registrationContext)) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        String registrationHandle = registrationContext.getRegistrationHandle();
        try {
            this.validateRegistrationDatas(data);
            this.stateManager.register(registrationHandle, data);
        }
        catch (WSRPException e) {
            this.log.debug((Object)"Registration failed", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        return new RegistrationState();
    }

    public ReturnAny deregister(RegistrationContext registrationContext) throws RemoteException {
        this.log.debug((Object)"Deregister method entered");
        ReturnAny any = null;
        try {
            if (!this.stateManager.isRegistered(registrationContext)) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        try {
            this.stateManager.deregister(registrationContext);
        }
        catch (WSRPException e) {
            this.log.debug((Object)"Registration failed", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        return any;
    }

    private void validateRegistrationDatas(RegistrationData data) throws WSRPException {
        String consumerAgent = data.getConsumerAgent();
        String[] members = StringUtils.split((String)consumerAgent, (String)".");
        if (!StringUtils.isNumeric((String)members[1])) {
            throw new WSRPException("MissingParameters");
        }
        if (!StringUtils.isNumeric((String)members[2])) {
            throw new WSRPException("MissingParameters");
        }
    }
}

