/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.utils;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.WindowState;

public class WindowStates
implements Serializable {
    private static final long serialVersionUID = 2161181578039145431L;
    private String _value_;
    private static Map<String, WindowStates> _table_ = new HashMap<String, WindowStates>();
    private static final String _normal_jsr = WindowState.NORMAL.toString();
    private static final String _minimized_jsr = WindowState.MINIMIZED.toString();
    private static final String _maximized_jsr = WindowState.MAXIMIZED.toString();
    private static final String _solo_jsr = "solo";
    public static final String _normal_wsrp = "wsrp:" + _normal_jsr;
    public static final String _minimized_wsrp = "wsrp:" + _minimized_jsr;
    public static final String _maximized_wsrp = "wsrp:" + _maximized_jsr;
    public static final String _solo_wsrp = "wsrp:solo";
    public static final WindowStates NORMAL = new WindowStates(_normal_wsrp);
    public static final WindowStates MINIMIZED = new WindowStates(_minimized_wsrp);
    public static final WindowStates MAXIMIZED = new WindowStates(_maximized_wsrp);
    public static final WindowStates SOLO = new WindowStates("wsrp:solo");

    public WindowStates(String value) {
        this._value_ = "wsrp:" + value.toLowerCase(Locale.ENGLISH);
        _table_.put(this._value_, this);
    }

    public String getValue() {
        return this._value_;
    }

    public static WindowStates fromValue(String value) {
        return _table_.get(value.toLowerCase(Locale.ENGLISH));
    }

    public static WindowStates fromString(String value) {
        return WindowStates.fromValue(value.toLowerCase(Locale.ENGLISH));
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this._value_;
    }

    public Object readResolve() throws ObjectStreamException {
        return WindowStates.fromValue(this._value_);
    }

    public static String[] getWindowStatesAsStringArray() {
        return (String[])_table_.keySet().toArray();
    }

    public static WindowState getJsrWindowState(String state) {
        if (state == null) {
            throw new IllegalArgumentException("WSRP portlet state must not be null.");
        }
        if ((state = WindowStates.delAllPrefixesWSRP(state)).equalsIgnoreCase(_normal_jsr)) {
            return WindowState.NORMAL;
        }
        if (state.equalsIgnoreCase(_maximized_jsr)) {
            return WindowState.MAXIMIZED;
        }
        if (state.equalsIgnoreCase(_minimized_jsr)) {
            return WindowState.MINIMIZED;
        }
        if (state.equalsIgnoreCase(_solo_jsr)) {
            return new WindowState(_solo_jsr);
        }
        return new WindowState(state);
    }

    public static String getWSRPStateString(WindowState jsrWindowState) {
        return WindowStates.addPrefixWSRP(jsrWindowState.toString());
    }

    public static String addPrefixWSRP(String forAddWSRP) {
        return "wsrp:" + forAddWSRP.toLowerCase(Locale.ENGLISH);
    }

    public static String delAllPrefixesWSRP(String forDelWSRP) {
        forDelWSRP = forDelWSRP.toLowerCase(Locale.ENGLISH);
        while (forDelWSRP.startsWith("wsrp:")) {
            forDelWSRP = forDelWSRP.substring("wsrp:".length());
        }
        return forDelWSRP;
    }
}

