/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.consumer.impl;

import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.wsrp.consumer.URLGenerator;

public class URLGeneratorImpl
implements URLGenerator {
    public String getBlockingActionURL(String baseURL, Map params) {
        return this.getURL(baseURL, params);
    }

    public String getRenderURL(String baseURL, Map params) {
        return this.getURL(baseURL, params);
    }

    public String getResourceURL(String baseURL, Map params) {
        return this.getURL(baseURL, params);
    }

    private String getURL(String baseURL, Map params) {
        StringBuffer sB = new StringBuffer();
        sB.append(baseURL);
        return this.computeParameters(sB, params);
    }

    public String getNamespacedToken(String token) {
        return token;
    }

    private String computeParameters(StringBuffer sB, Map parameters) {
        Set names = parameters.keySet();
        for (String name : names) {
            if (name.equalsIgnoreCase("wsrp-portletHandle")) continue;
            Object obj = parameters.get(name);
            if (obj instanceof String) {
                String value = (String)obj;
                sB.append("&");
                sB.append(URLEncoder.encode(this.replaceName(name)));
                sB.append("=");
                sB.append(URLEncoder.encode(this.replaceValue(value)));
                continue;
            }
            String[] values = (String[])obj;
            for (int i = 0; i < values.length; ++i) {
                name = this.replaceName(name);
                sB.append("&");
                sB.append(URLEncoder.encode(name));
                sB.append("=");
                sB.append(URLEncoder.encode(values[i]));
            }
        }
        return sB.toString();
    }

    private String replaceName(String name) {
        if ("wsrp-mode".equals(name)) {
            return "portal:portletMode";
        }
        if ("wsrp-windowState".equals(name)) {
            return "portal:windowState";
        }
        if ("wsrp-portletHandle".equals(name)) {
            return "portal:componentId";
        }
        if ("wsrp-secureURL".equals(name)) {
            return "portal:isSecure";
        }
        if ("wsrp-urlType".equals(name)) {
            return "portal:type";
        }
        return name;
    }

    private String replaceValue(String value) {
        if (value.startsWith("wsrp:")) {
            value = value.substring("wsrp:".length());
        }
        if ("blockingAction".equals(value)) {
            value = "action";
        }
        return value;
    }
}

